/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.unpack.ppm;

import de.innosystec.unrar.io.Raw;
import de.innosystec.unrar.unpack.ppm.PPMContext;
import de.innosystec.unrar.unpack.ppm.Pointer;
import de.innosystec.unrar.unpack.ppm.StateRef;

public class State
extends Pointer {
    public State(byte[] mem) {
        super(mem);
    }

    public State init(byte[] mem) {
        this.mem = mem;
        this.pos = 0;
        return this;
    }

    public int getSymbol() {
        return this.mem[this.pos] & 0xFF;
    }

    public void setSymbol(int symbol) {
        this.mem[this.pos] = (byte)symbol;
    }

    public int getFreq() {
        return this.mem[this.pos + 1] & 0xFF;
    }

    public void setFreq(int freq) {
        this.mem[this.pos + 1] = (byte)freq;
    }

    public void incFreq(int dFreq) {
        int n = this.pos + 1;
        this.mem[n] = (byte)(this.mem[n] + dFreq);
    }

    public int getSuccessor() {
        return Raw.readIntLittleEndian(this.mem, this.pos + 2);
    }

    public void setSuccessor(PPMContext successor) {
        this.setSuccessor(successor.getAddress());
    }

    public void setSuccessor(int successor) {
        Raw.writeIntLittleEndian(this.mem, this.pos + 2, successor);
    }

    public void setValues(StateRef state) {
        this.setSymbol(state.getSymbol());
        this.setFreq(state.getFreq());
        this.setSuccessor(state.getSuccessor());
    }

    public void setValues(State ptr) {
        System.arraycopy(ptr.mem, ptr.pos, this.mem, this.pos, 6);
    }

    public State decAddress() {
        this.setAddress(this.pos - 6);
        return this;
    }

    public State incAddress() {
        this.setAddress(this.pos + 6);
        return this;
    }

    public static void ppmdSwap(State ptr1, State ptr2) {
        byte[] mem1 = ptr1.mem;
        byte[] mem2 = ptr2.mem;
        int i = 0;
        int pos1 = ptr1.pos;
        int pos2 = ptr2.pos;
        while (i < 6) {
            byte temp = mem1[pos1];
            mem1[pos1] = mem2[pos2];
            mem2[pos2] = temp;
            ++i;
            ++pos1;
            ++pos2;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("State[");
        buffer.append("\n  pos=");
        buffer.append(this.pos);
        buffer.append("\n  size=");
        buffer.append(6);
        buffer.append("\n  symbol=");
        buffer.append(this.getSymbol());
        buffer.append("\n  freq=");
        buffer.append(this.getFreq());
        buffer.append("\n  successor=");
        buffer.append(this.getSuccessor());
        buffer.append("\n]");
        return buffer.toString();
    }
}

