/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.unpack;

import de.innosystec.unrar.Archive;
import de.innosystec.unrar.Volume;
import de.innosystec.unrar.crc.RarCRC;
import de.innosystec.unrar.exception.RarException;
import de.innosystec.unrar.io.ReadOnlyAccessInputStream;
import de.innosystec.unrar.rarfile.FileHeader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ComprDataIO {
    private final Archive archive;
    private long unpPackedSize;
    private boolean testMode;
    private boolean skipUnpCRC;
    private InputStream inputStream;
    private OutputStream outputStream;
    private FileHeader subHead;
    private boolean packVolume;
    private boolean unpVolume;
    private boolean nextVolumeMissing;
    private long totalPackRead;
    private long curPackRead;
    private long curPackWrite;
    private long curUnpRead;
    private long curUnpWrite;
    private long processedArcSize;
    private long totalArcSize;
    private long packFileCRC;
    private long unpFileCRC;
    private long packedCRC;
    private int encryption;
    private int decryption;
    private int lastPercent;
    private char currentCommand;

    public ComprDataIO(Archive arc) {
        this.archive = arc;
    }

    public void init(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.unpPackedSize = 0L;
        this.testMode = false;
        this.skipUnpCRC = false;
        this.packVolume = false;
        this.unpVolume = false;
        this.nextVolumeMissing = false;
        this.encryption = 0;
        this.decryption = 0;
        this.totalPackRead = 0L;
        this.curUnpWrite = 0L;
        this.curUnpRead = 0L;
        this.curPackWrite = 0L;
        this.curPackRead = 0L;
        this.packedCRC = -1L;
        this.unpFileCRC = -1L;
        this.packFileCRC = -1L;
        this.lastPercent = -1;
        this.subHead = null;
        this.currentCommand = '\u0000';
        this.totalArcSize = 0L;
        this.processedArcSize = 0L;
    }

    public void init(FileHeader hd) throws IOException {
        long startPos = hd.getPositionInFile() + (long)hd.getHeaderSize();
        this.unpPackedSize = hd.getFullPackSize();
        this.inputStream = new ReadOnlyAccessInputStream(this.archive.getRof(), startPos, startPos + this.unpPackedSize);
        this.subHead = hd;
        this.curUnpRead = 0L;
        this.curPackWrite = 0L;
        this.packedCRC = -1L;
    }

    public int unpRead(byte[] addr, int offset, int count) throws IOException, RarException {
        int retCode = 0;
        int totalRead = 0;
        while (count > 0) {
            int readSize = (long)count > this.unpPackedSize ? (int)this.unpPackedSize : count;
            retCode = this.inputStream.read(addr, offset, readSize);
            if (retCode < 0) {
                throw new EOFException();
            }
            if (this.subHead.isSplitAfter()) {
                this.packedCRC = RarCRC.checkCrc((int)this.packedCRC, addr, offset, retCode);
            }
            this.curUnpRead += (long)retCode;
            totalRead += retCode;
            offset += retCode;
            count -= retCode;
            this.unpPackedSize -= (long)retCode;
            this.archive.bytesReadRead(retCode);
            if (this.unpPackedSize != 0L || !this.subHead.isSplitAfter()) break;
            if (Volume.mergeArchive(this.archive, this)) continue;
            this.nextVolumeMissing = true;
            return -1;
        }
        if (retCode != -1) {
            retCode = totalRead;
        }
        return retCode;
    }

    public void unpWrite(byte[] addr, int offset, int count) throws IOException {
        if (!this.testMode) {
            this.outputStream.write(addr, offset, count);
        }
        this.curUnpWrite += (long)count;
        if (!this.skipUnpCRC) {
            this.unpFileCRC = this.archive.isOldFormat() ? (long)RarCRC.checkOldCrc((short)this.unpFileCRC, addr, count) : (long)RarCRC.checkCrc((int)this.unpFileCRC, addr, offset, count);
        }
    }

    public long getPackedCRC() {
        return this.packedCRC;
    }

    public long getUnpFileCRC() {
        return this.unpFileCRC;
    }

    public void setUnpFileCRC(long unpFileCRC) {
        this.unpFileCRC = unpFileCRC;
    }

    public FileHeader getSubHeader() {
        return this.subHead;
    }
}

