/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.rarfile;

import de.innosystec.unrar.io.Raw;
import de.innosystec.unrar.rarfile.BlockHeader;
import de.innosystec.unrar.rarfile.SubBlockHeaderType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubBlockHeader
extends BlockHeader {
    private Log logger = LogFactory.getLog(this.getClass());
    private short subType;
    private byte level;

    public SubBlockHeader(SubBlockHeader sb) {
        super(sb);
        this.subType = sb.getSubType().getSubblocktype();
        this.level = sb.getLevel();
    }

    public SubBlockHeader(BlockHeader bh, byte[] subblock) {
        super(bh);
        int position = 0;
        this.subType = Raw.readShortLittleEndian(subblock, position);
        this.level = (byte)(this.level | subblock[position += 2] & 0xFF);
    }

    public byte getLevel() {
        return this.level;
    }

    public SubBlockHeaderType getSubType() {
        return SubBlockHeaderType.findSubblockHeaderType(this.subType);
    }

    public void print() {
        super.print();
        this.logger.info("subtype: " + (Object)((Object)this.getSubType()));
        this.logger.info("level: " + this.level);
    }
}

