/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.rarfile;

import de.innosystec.unrar.io.Raw;
import de.innosystec.unrar.rarfile.BaseBlock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockHeader
extends BaseBlock {
    private Log logger = LogFactory.getLog(BlockHeader.class.getName());
    private int dataSize;
    private int packSize;

    public BlockHeader() {
    }

    public BlockHeader(BlockHeader blockHeader) {
        super(blockHeader);
        this.dataSize = this.packSize = blockHeader.getDataSize();
        this.positionInFile = blockHeader.getPositionInFile();
    }

    public BlockHeader(BaseBlock baseBlock, byte[] byArray) {
        super(baseBlock);
        this.dataSize = this.packSize = Raw.readIntLittleEndian(byArray, 0);
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getPackSize() {
        return this.packSize;
    }

    public void print() {
        super.print();
        String s = "DataSize: " + this.getDataSize() + " packSize: " + this.getPackSize();
        this.logger.info(s);
    }
}

