/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar;

import de.innosystec.unrar.Archive;
import de.innosystec.unrar.UnrarCallback;
import de.innosystec.unrar.rarfile.FileHeader;
import de.innosystec.unrar.unpack.ComprDataIO;
import java.io.File;
import java.io.IOException;

public class Volume {
    private Volume() {
    }

    public static boolean mergeArchive(Archive archive, ComprDataIO dataIO) throws IOException {
        FileHeader hd = dataIO.getSubHeader();
        if (hd.getUnpVersion() >= 20 && hd.getFileCRC() != -1 && dataIO.getPackedCRC() != (long)(~hd.getFileCRC())) {
            System.err.println("Data Bad CRC");
        }
        boolean oldNumbering = !archive.getMainHeader().isNewNumbering() || archive.isOldFormat();
        String nextName = Volume.nextVolumeName(archive.getFile().getAbsolutePath(), oldNumbering);
        File nextVolume = new File(nextName);
        UnrarCallback callback = archive.getUnrarCallback();
        if (callback != null && !callback.isNextVolumeReady(nextVolume)) {
            return false;
        }
        if (!nextVolume.exists()) {
            return false;
        }
        archive.setFile(nextVolume);
        hd = archive.nextFileHeader();
        if (hd == null) {
            return false;
        }
        dataIO.init(hd);
        return true;
    }

    public static String nextVolumeName(String arcName, boolean oldNumbering) {
        if (!oldNumbering) {
            int indexL;
            int indexR;
            int len = arcName.length();
            for (indexR = len - 1; indexR >= 0 && !Volume.isDigit(arcName.charAt(indexR)); --indexR) {
            }
            int index = indexR + 1;
            for (indexL = indexR - 1; indexL >= 0 && Volume.isDigit(arcName.charAt(indexL)); --indexL) {
            }
            if (indexL < 0) {
                return null;
            }
            StringBuilder buffer = new StringBuilder(len);
            buffer.append(arcName, 0, ++indexL);
            char[] digits = new char[indexR - indexL + 1];
            arcName.getChars(indexL, indexR + 1, digits, 0);
            for (indexR = digits.length - 1; indexR >= 0; --indexR) {
                int n = indexR;
                digits[n] = (char)(digits[n] + '\u0001');
                if (digits[n] != ':') break;
                digits[indexR] = 48;
            }
            if (indexR < 0) {
                buffer.append('1');
            }
            buffer.append(digits);
            buffer.append(arcName, index, len);
            return buffer.toString();
        }
        int len = arcName.length();
        if (len <= 4 || arcName.charAt(len - 4) != '.') {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        int off = len - 3;
        buffer.append(arcName, 0, off);
        if (!Volume.isDigit(arcName.charAt(off + 1)) || !Volume.isDigit(arcName.charAt(off + 2))) {
            buffer.append("r00");
        } else {
            char[] ext = new char[3];
            arcName.getChars(off, len, ext, 0);
            int i = ext.length - 1;
            while (true) {
                int n = --i;
                ext[n] = (char)(ext[n] + '\u0001');
                if (ext[n] != ':') break;
                ext[i] = 48;
            }
            buffer.append(ext);
        }
        return buffer.toString();
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }
}

