/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar;

import de.innosystec.unrar.UnrarCallback;
import de.innosystec.unrar.exception.RarException;
import de.innosystec.unrar.io.IReadOnlyAccess;
import de.innosystec.unrar.io.ReadOnlyAccessFile;
import de.innosystec.unrar.rarfile.AVHeader;
import de.innosystec.unrar.rarfile.BaseBlock;
import de.innosystec.unrar.rarfile.BlockHeader;
import de.innosystec.unrar.rarfile.CommentHeader;
import de.innosystec.unrar.rarfile.EAHeader;
import de.innosystec.unrar.rarfile.EndArcHeader;
import de.innosystec.unrar.rarfile.FileHeader;
import de.innosystec.unrar.rarfile.MacInfoHeader;
import de.innosystec.unrar.rarfile.MainHeader;
import de.innosystec.unrar.rarfile.MarkHeader;
import de.innosystec.unrar.rarfile.ProtectHeader;
import de.innosystec.unrar.rarfile.SignHeader;
import de.innosystec.unrar.rarfile.SubBlockHeader;
import de.innosystec.unrar.rarfile.UnixOwnersHeader;
import de.innosystec.unrar.rarfile.UnrarHeadertype;
import de.innosystec.unrar.unpack.ComprDataIO;
import de.innosystec.unrar.unpack.Unpack;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Archive
implements Closeable {
    private static Logger logger = Logger.getLogger(Archive.class.getName());
    private File file;
    private IReadOnlyAccess rof;
    private final UnrarCallback unrarCallback;
    private final ComprDataIO dataIO;
    private final List<BaseBlock> headers = new ArrayList<BaseBlock>();
    private MarkHeader markHead = null;
    private MainHeader newMhd = null;
    private EndArcHeader endHeader = null;
    private Unpack unpack;
    private long arcDataCRC = -1L;
    private int currentHeaderIndex;
    private boolean encrypted = false;
    private int sfxSize = 0;
    private long totalPackedSize = 0L;
    private long totalPackedRead = 0L;

    public Archive(File file) throws RarException, IOException {
        this(file, null);
    }

    public Archive(File file, UnrarCallback unrarCallback) throws RarException, IOException {
        this.setFile(file);
        this.unrarCallback = unrarCallback;
        this.dataIO = new ComprDataIO(this);
    }

    public File getFile() {
        return this.file;
    }

    void setFile(File file) throws IOException {
        this.file = file;
        this.totalPackedSize = 0L;
        this.totalPackedRead = 0L;
        this.close();
        this.rof = new ReadOnlyAccessFile(file);
        try {
            this.readHeaders();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "exception in archive constructor maybe file is encrypted or currupt", e);
        }
        for (BaseBlock block : this.headers) {
            if (block.getHeaderType() != UnrarHeadertype.FileHeader) continue;
            this.totalPackedSize += ((FileHeader)block).getFullPackSize();
        }
        if (this.unrarCallback != null) {
            this.unrarCallback.volumeProgressChanged(this.totalPackedRead, this.totalPackedSize);
        }
    }

    public void bytesReadRead(int count) {
        if (count > 0) {
            this.totalPackedRead += (long)count;
            if (this.unrarCallback != null) {
                this.unrarCallback.volumeProgressChanged(this.totalPackedRead, this.totalPackedSize);
            }
        }
    }

    public IReadOnlyAccess getRof() {
        return this.rof;
    }

    public List<FileHeader> getFileHeaders() {
        ArrayList<FileHeader> list = new ArrayList<FileHeader>();
        for (BaseBlock block : this.headers) {
            if (!block.getHeaderType().equals((Object)UnrarHeadertype.FileHeader)) continue;
            list.add((FileHeader)block);
        }
        return list;
    }

    public FileHeader nextFileHeader() {
        int n = this.headers.size();
        while (this.currentHeaderIndex < n) {
            BaseBlock block;
            if ((block = this.headers.get(this.currentHeaderIndex++)).getHeaderType() != UnrarHeadertype.FileHeader) continue;
            return (FileHeader)block;
        }
        return null;
    }

    public UnrarCallback getUnrarCallback() {
        return this.unrarCallback;
    }

    private void readHeaders() throws IOException, RarException {
        block27: {
            this.markHead = null;
            this.newMhd = null;
            this.endHeader = null;
            this.headers.clear();
            this.currentHeaderIndex = 0;
            int toRead = 0;
            long fileLength = this.file.length();
            block21: while (true) {
                int size = 0;
                long newpos = 0L;
                byte[] baseBlockBuffer = new byte[7];
                long position = this.rof.getPosition();
                if (position >= fileLength || (size = this.rof.readFully(baseBlockBuffer, 7)) == 0) break block27;
                BaseBlock block = new BaseBlock(baseBlockBuffer);
                block.setPositionInFile(position);
                switch (block.getHeaderType()) {
                    case MarkHeader: {
                        this.markHead = new MarkHeader(block);
                        if (!this.markHead.isSignature()) {
                            throw new RarException(RarException.RarExceptionType.badRarArchive);
                        }
                        this.headers.add(this.markHead);
                        continue block21;
                    }
                    case MainHeader: {
                        int mainHeaderSize = 0;
                        toRead = block.hasEncryptVersion() ? 7 : 6;
                        byte[] mainbuff = new byte[toRead];
                        mainHeaderSize = this.rof.readFully(mainbuff, toRead);
                        MainHeader mainhead = new MainHeader(block, mainbuff);
                        this.headers.add(mainhead);
                        this.newMhd = mainhead;
                        if (!this.newMhd.isEncrypted()) continue block21;
                        throw new RarException(RarException.RarExceptionType.rarEncryptedException);
                    }
                    case SignHeader: {
                        int signHeaderSize = 0;
                        toRead = 8;
                        byte[] signBuff = new byte[toRead];
                        signHeaderSize = this.rof.readFully(signBuff, toRead);
                        SignHeader signHead = new SignHeader(block, signBuff);
                        this.headers.add(signHead);
                        continue block21;
                    }
                    case AvHeader: {
                        int avHeaderSize = 0;
                        toRead = 7;
                        byte[] avBuff = new byte[toRead];
                        avHeaderSize = this.rof.readFully(avBuff, toRead);
                        AVHeader avHead = new AVHeader(block, avBuff);
                        this.headers.add(avHead);
                        continue block21;
                    }
                    case CommHeader: {
                        int commHeaderSize = 0;
                        toRead = 6;
                        byte[] commBuff = new byte[toRead];
                        commHeaderSize = this.rof.readFully(commBuff, toRead);
                        CommentHeader commHead = new CommentHeader(block, commBuff);
                        this.headers.add(commHead);
                        newpos = commHead.getPositionInFile() + (long)commHead.getHeaderSize();
                        this.rof.setPosition(newpos);
                        continue block21;
                    }
                    case EndArcHeader: {
                        EndArcHeader endArcHead;
                        toRead = 0;
                        if (block.hasArchiveDataCRC()) {
                            toRead += 4;
                        }
                        if (block.hasVolumeNumber()) {
                            toRead += 2;
                        }
                        if (toRead > 0) {
                            int endArcHeaderSize = 0;
                            byte[] endArchBuff = new byte[toRead];
                            endArcHeaderSize = this.rof.readFully(endArchBuff, toRead);
                            endArcHead = new EndArcHeader(block, endArchBuff);
                        } else {
                            endArcHead = new EndArcHeader(block, null);
                        }
                        this.headers.add(endArcHead);
                        this.endHeader = endArcHead;
                        return;
                    }
                }
                byte[] blockHeaderBuffer = new byte[4];
                int bhsize = this.rof.readFully(blockHeaderBuffer, 4);
                BlockHeader blockHead = new BlockHeader(block, blockHeaderBuffer);
                switch (blockHead.getHeaderType()) {
                    case NewSubHeader: 
                    case FileHeader: {
                        toRead = blockHead.getHeaderSize() - 7 - 4;
                        byte[] fileHeaderBuffer = new byte[toRead];
                        int fhsize = this.rof.readFully(fileHeaderBuffer, toRead);
                        FileHeader fh = new FileHeader(blockHead, fileHeaderBuffer);
                        this.headers.add(fh);
                        newpos = fh.getPositionInFile() + (long)fh.getHeaderSize() + fh.getFullPackSize();
                        this.rof.setPosition(newpos);
                        continue block21;
                    }
                    case ProtectHeader: {
                        toRead = blockHead.getHeaderSize() - 7 - 4;
                        byte[] protectHeaderBuffer = new byte[toRead];
                        int phsize = this.rof.readFully(protectHeaderBuffer, toRead);
                        ProtectHeader ph = new ProtectHeader(blockHead, protectHeaderBuffer);
                        newpos = ph.getPositionInFile() + (long)ph.getHeaderSize() + (long)ph.getDataSize();
                        this.rof.setPosition(newpos);
                        continue block21;
                    }
                    case SubHeader: {
                        byte[] subHeadbuffer = new byte[3];
                        int subheadersize = this.rof.readFully(subHeadbuffer, 3);
                        SubBlockHeader subHead = new SubBlockHeader(blockHead, subHeadbuffer);
                        subHead.print();
                        switch (subHead.getSubType()) {
                            case MAC_HEAD: {
                                byte[] macHeaderbuffer = new byte[8];
                                int macheadersize = this.rof.readFully(macHeaderbuffer, 8);
                                MacInfoHeader macHeader = new MacInfoHeader(subHead, macHeaderbuffer);
                                macHeader.print();
                                this.headers.add(macHeader);
                                break;
                            }
                            case BEEA_HEAD: {
                                break;
                            }
                            case EA_HEAD: {
                                byte[] eaHeaderBuffer = new byte[10];
                                int eaheadersize = this.rof.readFully(eaHeaderBuffer, 10);
                                EAHeader eaHeader = new EAHeader(subHead, eaHeaderBuffer);
                                eaHeader.print();
                                this.headers.add(eaHeader);
                                break;
                            }
                            case NTACL_HEAD: {
                                break;
                            }
                            case STREAM_HEAD: {
                                break;
                            }
                            case UO_HEAD: {
                                toRead = subHead.getHeaderSize();
                                toRead -= 7;
                                toRead -= 4;
                                byte[] uoHeaderBuffer = new byte[toRead -= 3];
                                int uoHeaderSize = this.rof.readFully(uoHeaderBuffer, toRead);
                                UnixOwnersHeader uoHeader = new UnixOwnersHeader(subHead, uoHeaderBuffer);
                                uoHeader.print();
                                this.headers.add(uoHeader);
                                break;
                            }
                        }
                        continue block21;
                    }
                }
                break;
            }
            logger.warning("Unknown Header");
            throw new RarException(RarException.RarExceptionType.notRarArchive);
        }
    }

    public void extractFile(FileHeader hd, OutputStream os) throws RarException {
        if (!this.headers.contains(hd)) {
            throw new RarException(RarException.RarExceptionType.headerNotInArchive);
        }
        try {
            this.doExtractFile(hd, os);
        }
        catch (Exception e) {
            if (e instanceof RarException) {
                throw (RarException)e;
            }
            throw new RarException(e);
        }
    }

    private void doExtractFile(FileHeader hd, OutputStream os) throws RarException, IOException {
        this.dataIO.init(os);
        this.dataIO.init(hd);
        this.dataIO.setUnpFileCRC(this.isOldFormat() ? 0L : -1L);
        if (this.unpack == null) {
            this.unpack = new Unpack(this.dataIO);
        }
        if (!hd.isSolid()) {
            this.unpack.init(null);
        }
        this.unpack.setDestSize(hd.getFullUnpackSize());
        try {
            this.unpack.doUnpack(hd.getUnpVersion(), hd.isSolid());
            hd = this.dataIO.getSubHeader();
            long actualCRC = hd.isSplitAfter() ? this.dataIO.getPackedCRC() ^ 0xFFFFFFFFFFFFFFFFL : this.dataIO.getUnpFileCRC() ^ 0xFFFFFFFFFFFFFFFFL;
            int expectedCRC = hd.getFileCRC();
            if (actualCRC != (long)expectedCRC) {
                throw new RarException(RarException.RarExceptionType.crcError);
            }
        }
        catch (Exception e) {
            this.unpack.cleanUp();
            if (e instanceof RarException) {
                throw (RarException)e;
            }
            throw new RarException(e);
        }
    }

    public MainHeader getMainHeader() {
        return this.newMhd;
    }

    public boolean isOldFormat() {
        return this.markHead.isOldFormat();
    }

    @Override
    public void close() throws IOException {
        if (this.rof != null) {
            this.rof.close();
            this.rof = null;
        }
        if (this.unpack != null) {
            this.unpack.cleanUp();
        }
    }
}

