/*
 * Decompiled with CFR 0.152.
 */
package contribs.mx;

import contribs.mx.LongCounter;
import contribs.mx.S3BucketMx;
import contribs.mx.S3ServiceMx;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.jets3t.service.model.S3Object;

public class S3ObjectMx {
    public static final boolean isEnabled = "true".equals(System.getProperty("jets3t.object.mx"));
    private static Map objects = Collections.synchronizedMap(new HashMap());
    private LongCounter[] counters = new LongCounter[6];

    private S3ObjectMx() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = new LongCounter();
        }
    }

    public static void registerMBeans(String bucketName, S3Object[] objects) {
        if (!isEnabled) {
            return;
        }
        for (int i = 0; i < objects.length; ++i) {
            S3ObjectMx.getInstance(bucketName, objects[i].getKey());
        }
    }

    private static S3ObjectMx getInstance(String bucketName, String key) {
        String props = new StringBuffer().append("Type=S3Object,Bucket=").append(bucketName).append(",").append("Name=").append(key).toString();
        S3ObjectMx object = (S3ObjectMx)objects.get(props);
        if (object == null) {
            object = new S3ObjectMx();
            objects.put(props, object);
            ObjectName name = S3ServiceMx.getObjectName(props);
            try {
                S3ServiceMx.registerMBean(object, name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public static void increment(int type, String bucketName, String key) {
        if (isEnabled) {
            S3ObjectMx object = S3ObjectMx.getInstance(bucketName, key);
            object.counters[0].increment();
            object.counters[type].increment();
        }
    }

    public static void get(String bucketName, String key) {
        S3ObjectMx.increment(1, bucketName, key);
        S3BucketMx.o_get(bucketName);
    }

    public static void head(String bucketName, String key) {
        S3ObjectMx.increment(2, bucketName, key);
        S3BucketMx.o_head(bucketName);
    }

    public static void put(String bucketName, String key) {
        S3ObjectMx.increment(3, bucketName, key);
        S3BucketMx.o_put(bucketName);
    }

    public static void delete(String bucketName, String key) {
        S3ObjectMx.increment(4, bucketName, key);
        S3BucketMx.o_delete(bucketName);
    }

    public static void copy(String bucketName, String key) {
        S3ObjectMx.increment(5, bucketName, key);
        S3BucketMx.o_copy(bucketName);
    }
}

