/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xfile;

import com.sun.xfile.XFile;
import com.sun.xfile.XFileAccessor;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class XRandomAccessFile
implements DataInput,
DataOutput {
    private long fp;
    private boolean readOnly;
    private XFileAccessor xfa;

    public XRandomAccessFile(XFile xFile, String string) throws IOException {
        if (!string.equals("r") && !string.equals("rw")) {
            throw new IllegalArgumentException("mode must be r or rw");
        }
        this.readOnly = string.equals("r");
        this.xfa = xFile.newAccessor();
        this.xfa.open(xFile, false, this.readOnly);
        if (this.xfa.exists()) {
            if (this.readOnly && !this.xfa.canRead()) {
                throw new IOException("no read permission");
            }
            if (!this.readOnly && !this.xfa.canWrite()) {
                throw new IOException("no write permission");
            }
        } else {
            if (this.readOnly) {
                throw new IOException("no such file or directory");
            }
            if (!this.xfa.mkfile()) {
                throw new IOException("no write permission");
            }
        }
    }

    private int XFAread(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (n < 0 || n2 < 0 || n >= byArray.length || n + n2 > byArray.length) {
            throw new IllegalArgumentException("Invalid argument");
        }
        int n3 = this.xfa.read(byArray, n, n2, this.fp);
        if (n3 >= 0) {
            this.fp += (long)n3;
        }
        return n3;
    }

    private void XFAwrite(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (this.readOnly) {
            throw new IOException("Read only file");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Invalid argument");
        }
        this.xfa.write(byArray, n, n2, this.fp);
        this.fp += (long)n2;
    }

    public void close() throws IOException {
        this.xfa.close();
    }

    public long getFilePointer() throws IOException {
        return this.fp;
    }

    public long length() throws IOException {
        return this.xfa.length();
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.XFAread(byArray, 0, 1) != 1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.XFAread(byArray, n, n2);
    }

    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + n);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (this.XFAread(byArray, n, n2) < n2) {
            throw new EOFException();
        }
    }

    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    public final String readLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read()) != -1 && n != 10) {
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }

    public void seek(long l) throws IOException {
        if (l < 0L || this.readOnly && l >= this.xfa.length()) {
            throw new IOException(new StringBuffer("illegal seek").append(l).toString());
        }
        this.fp = l;
    }

    public int skipBytes(int n) throws IOException {
        if (this.fp + (long)n > this.xfa.length()) {
            throw new EOFException();
        }
        this.seek(this.fp + (long)n);
        return n;
    }

    public void write(int n) throws IOException {
        this.XFAwrite(new byte[]{(byte)n}, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.write((byte)string.charAt(n2));
            ++n2;
        }
    }

    private void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this.XFAwrite(byArray, n, n2);
    }

    public final void writeChar(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public final void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.write(c >>> 8 & 0xFF);
            this.write(c & 0xFF);
            ++n2;
        }
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeInt(int n) throws IOException {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public final void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)l & 0xFF);
    }

    public final void writeShort(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public final void writeUTF(String string) throws IOException {
        int n;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n = string.charAt(n4);
            n3 = n >= 1 && n <= 127 ? ++n3 : (n > 2047 ? (n3 += 3) : (n3 += 2));
            ++n4;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(n3 >>> 8 & 0xFF);
        this.write(n3 & 0xFF);
        n = 0;
        while (n < n2) {
            char c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
            } else if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c & 0x3F);
            } else {
                this.write(0xC0 | c >> 6 & 0x1F);
                this.write(0x80 | c & 0x3F);
            }
            ++n;
        }
    }
}

