/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xfile;

import com.sun.xfile.XFile;
import com.sun.xfile.XFileAccessor;
import java.io.IOException;
import java.io.OutputStream;

public class XFileOutputStream
extends OutputStream {
    private long fp;
    private XFileAccessor xfa;

    public XFileOutputStream(XFile xFile, boolean bl) throws IOException {
        this.xfa = xFile.newAccessor();
        boolean bl2 = this.xfa.open(xFile, true, false);
        if (bl2) {
            if (!this.xfa.isFile()) {
                throw new IOException("not a file");
            }
            if (!this.xfa.canWrite()) {
                throw new IOException("no write permission");
            }
        }
        if (!(bl2 && bl || this.xfa.mkfile())) {
            throw new IOException("no write permission");
        }
        if (bl) {
            this.fp = this.xfa.length();
        }
    }

    public XFileOutputStream(String string, boolean bl) throws IOException {
        this(new XFile(string), bl);
    }

    private synchronized void XFAwrite(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n >= byArray.length || n + n2 > byArray.length) {
            throw new IllegalArgumentException("Invalid argument");
        }
        this.xfa.write(byArray, n, n2, this.fp);
        this.fp += (long)n2;
    }

    public void close() throws IOException {
        this.xfa.close();
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public void flush() throws IOException {
        this.xfa.flush();
    }

    public void write(int n) throws IOException {
        this.XFAwrite(new byte[]{(byte)n}, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.XFAwrite(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.XFAwrite(byArray, n, n2);
    }
}

