/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

import com.sun.rpc.ConnectDatagram;
import com.sun.rpc.ConnectSocket;
import com.sun.rpc.Connection;
import com.sun.rpc.Cred;
import com.sun.rpc.CredNone;
import com.sun.rpc.CredUnix;
import com.sun.rpc.MsgAcceptedException;
import com.sun.rpc.MsgRejectedException;
import com.sun.rpc.RpcException;
import com.sun.rpc.RpcHandler;
import com.sun.rpc.Xdr;
import java.io.IOException;
import java.io.InterruptedIOException;

public class Rpc {
    public Connection conn;
    int prog;
    int vers;
    Cred cred;
    RpcHandler rhandler = new RpcHandler();
    private static int xid = (int)System.currentTimeMillis() & 0xFFFFFFF;

    public Rpc(Connection connection, int n, int n2) {
        this.conn = connection;
        this.prog = n;
        this.vers = n2;
        this.cred = new CredNone();
    }

    public Rpc(Connection connection, int n, int n2, Cred cred) {
        this.conn = connection;
        this.prog = n;
        this.vers = n2;
        this.cred = cred;
    }

    public Rpc(String string, int n, int n2, int n3, String string2, int n4) throws IOException {
        this.conn = this.getConnection(string, n, n2, n3, string2, n4);
        this.prog = n2;
        this.vers = n3;
        this.cred = new CredNone();
    }

    private Xdr call_reconstruct(Xdr xdr, byte[] byArray) throws IOException, RpcException {
        Xdr xdr2 = new Xdr(xdr.xdr_size());
        xdr2.xid = xdr.xid;
        xdr2.xdr_raw(xdr.xdr_raw(0, this.conn instanceof ConnectSocket ? 28 : 24));
        this.cred.putCred(xdr2);
        if (byArray != null) {
            if (xdr2.xdr_offset() == xdr2.xdr_wrap_offset()) {
                xdr2.xdr_raw(byArray);
            } else {
                xdr2.xdr_raw(byArray, 4, byArray.length - 4);
            }
        }
        return xdr2;
    }

    private Connection getConnection(String string, int n, int n2, int n3, String string2, int n4) throws IOException {
        Object object;
        if (n == 0) {
            object = new Rpc(string, 111, 100000, 2, "udp", 128);
            Xdr xdr = new Xdr(128);
            ((Rpc)object).rpc_header(xdr, 3);
            xdr.xdr_int(n2);
            xdr.xdr_int(n3);
            xdr.xdr_int(string2.equals("tcp") ? 6 : 17);
            xdr.xdr_int(0);
            Xdr xdr2 = ((Rpc)object).rpc_call(xdr, 5000, 3);
            n = xdr2.xdr_int();
            if (n == 0) {
                throw new MsgAcceptedException(1);
            }
        }
        object = Connection.connections;
        synchronized (object) {
            this.conn = Connection.getCache(string, n, string2);
            if (this.conn == null) {
                this.conn = string2.equals("tcp") ? new ConnectSocket(string, n, n4) : new ConnectDatagram(string, n, n4);
                Connection.putCache(this.conn);
            }
        }
        return this.conn;
    }

    static synchronized int next_xid() {
        return xid++;
    }

    public Xdr rpc_call(Xdr xdr, int n, int n2) throws IOException {
        boolean bl = false;
        Xdr xdr2 = null;
        long l = System.currentTimeMillis();
        if (n2 == 0) {
            n2 = Integer.MAX_VALUE;
        }
        if (this.conn instanceof ConnectSocket) {
            n = 30000;
        }
        int n3 = 2;
        int n4 = 0;
        while (n4 < n2) {
            block13: {
                byte[] byArray = null;
                if (!(this.cred instanceof CredUnix) && !(this.cred instanceof CredNone) && xdr.xdr_offset() > xdr.xdr_wrap_offset()) {
                    byArray = xdr.xdr_raw(xdr.xdr_wrap_offset(), xdr.xdr_offset() - xdr.xdr_wrap_offset());
                }
                try {
                    xdr2 = this.rpc_call_one(xdr, byArray, n);
                    break;
                }
                catch (MsgRejectedException msgRejectedException) {
                    if (n3 > 0 && (msgRejectedException.why == 13 || msgRejectedException.why == 14) && this.cred.refresh(this.conn, this.prog, this.vers)) {
                        xdr = this.call_reconstruct(xdr, byArray);
                        --n3;
                        --n4;
                    }
                    throw msgRejectedException;
                }
                catch (RpcException rpcException) {
                    throw rpcException;
                }
                catch (IOException iOException) {
                    if (this.rhandler.timeout(this.conn.server, n4, (int)(System.currentTimeMillis() - l))) {
                        throw new InterruptedIOException();
                    }
                    bl = true;
                    if ((n *= 2) > 30000) {
                        n = 30000;
                    }
                    if (this.cred instanceof CredUnix || this.cred instanceof CredNone) break block13;
                    xdr = this.call_reconstruct(xdr, byArray);
                }
            }
            ++n4;
        }
        if (xdr2 == null) {
            throw new InterruptedIOException();
        }
        if (bl && xdr2 != null) {
            this.rhandler.ok(this.conn.server);
        }
        return xdr2;
    }

    public Xdr rpc_call_one(Xdr xdr, byte[] byArray, int n) throws IOException, RpcException {
        Xdr xdr2;
        if (byArray != null) {
            this.cred.wrap(xdr, byArray);
        }
        if ((xdr2 = this.conn.send(xdr, n)).xdr_int() != 1) {
            throw new RpcException("Unknown RPC header");
        }
        int n2 = xdr2.xdr_int();
        block0 : switch (n2) {
            case 0: {
                xdr2.xdr_skip(4);
                byte[] byArray2 = xdr2.xdr_bytes();
                int n3 = xdr2.xdr_int();
                switch (n3) {
                    case 0: {
                        int n4 = this.cred.unwrap(xdr2);
                        if (n4 <= 0) break block0;
                        this.cred.validate(byArray2, n4);
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        throw new MsgAcceptedException(n3, xdr2.xdr_int(), xdr2.xdr_int());
                    }
                }
                throw new MsgAcceptedException(n3);
            }
            case 1: {
                int n5 = xdr2.xdr_int();
                switch (n5) {
                    case 0: {
                        throw new MsgRejectedException(n5, xdr2.xdr_int(), xdr2.xdr_int());
                    }
                    case 1: {
                        int n6 = xdr2.xdr_int();
                        throw new MsgRejectedException(n5, n6);
                    }
                }
                throw new MsgRejectedException(n5);
            }
        }
        return xdr2;
    }

    public void rpc_header(Xdr xdr, int n) throws RpcException {
        xdr.xid = Rpc.next_xid();
        xdr.xdr_offset(this.conn instanceof ConnectSocket ? 4 : 0);
        xdr.xdr_int(xdr.xid);
        xdr.xdr_int(0);
        xdr.xdr_int(2);
        xdr.xdr_int(this.prog);
        xdr.xdr_int(this.vers);
        xdr.xdr_int(n);
        this.cred.putCred(xdr);
    }

    public void setCred(Cred cred) throws RpcException {
        this.cred = cred;
        this.cred.init(this.conn, this.prog, this.vers);
    }

    public void setRpcHandler(RpcHandler rpcHandler) {
        this.rhandler = rpcHandler == null ? new RpcHandler() : rpcHandler;
    }
}

