/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

import com.sun.rpc.Connection;
import com.sun.rpc.Cred;
import com.sun.rpc.Xdr;

public class CredUnix
extends Cred {
    private int uid;
    private int gid;
    private int[] gids;
    private String home;
    private int def_umask;
    private Xdr cr = new Xdr(64);

    public CredUnix() {
        this(60001, 60001);
    }

    public CredUnix(int n, int n2) {
        this.uid = n;
        this.gid = n2;
    }

    public int getGid() {
        return this.gid;
    }

    public int[] getGids() {
        return this.gids;
    }

    public int getUid() {
        return this.uid;
    }

    public void init(Connection connection, int n, int n2) {
    }

    synchronized void putCred(Xdr xdr) {
        xdr.xdr_int(1);
        this.cr.xdr_offset(0);
        this.cr.xdr_int((int)(System.currentTimeMillis() / 1000L));
        this.cr.xdr_string("javaclient");
        this.cr.xdr_int(this.uid);
        this.cr.xdr_int(this.gid);
        if (this.gids == null) {
            this.cr.xdr_int(0);
        } else {
            this.cr.xdr_int(this.gids.length);
            int n = 0;
            while (n < this.gids.length) {
                this.cr.xdr_int(this.gids[n]);
                ++n;
            }
        }
        xdr.xdr_bytes(this.cr);
        xdr.xdr_int(0);
        xdr.xdr_int(0);
    }

    public boolean refresh(Connection connection, int n, int n2) {
        return true;
    }

    public String toString() {
        String string = new StringBuffer("AUTH_UNIX:\n   uid=").append(this.uid).append(",gid=").append(this.gid).append("\n").toString();
        if (this.gids != null) {
            string = new StringBuffer(String.valueOf(string)).append("   gids=").toString();
            int n = 0;
            while (n < this.gids.length) {
                string = new StringBuffer(String.valueOf(string)).append(this.gids[n]).append(" ").toString();
                ++n;
            }
        }
        if (this.home != null) {
            string = new StringBuffer(String.valueOf(string)).append("\n   home=").append(this.home).toString();
        }
        if (this.def_umask != 0) {
            string = new StringBuffer(String.valueOf(string)).append("\n   umask=0").append(Long.toOctalString(this.def_umask)).toString();
        }
        return string;
    }

    public int unwrap(Xdr xdr) {
        return 0;
    }

    public void validate(byte[] byArray, int n) {
    }

    public void wrap(Xdr xdr, byte[] byArray) {
    }
}

