/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.Buffer;
import com.sun.nfs.Fattr3;
import com.sun.nfs.Nfs;
import com.sun.nfs.NfsConnect;
import com.sun.nfs.NfsException;
import com.sun.nfs.NfsSecurity;
import com.sun.rpc.CredGss;
import com.sun.rpc.CredUnix;
import com.sun.rpc.MsgRejectedException;
import com.sun.rpc.Rpc;
import com.sun.rpc.Xdr;
import java.io.IOException;

class Nfs3
extends Nfs {
    Fattr3 attr;
    int accessBits = -1;
    long accessTime;
    int prevWriteIndex = -1;

    Nfs3(Rpc rpc2, byte[] byArray, String string, Fattr3 fattr3) {
        this.rpc = rpc2;
        this.fh = byArray;
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        this.name = string;
        this.attr = fattr3 == null ? new Fattr3() : fattr3;
        this.rsize = 32768;
        this.NRA = 1;
        this.NWB = 4;
        this.NWC = 10;
    }

    boolean cacheOK(long l) throws IOException {
        this.checkAttr();
        return l == this.attr.mtime;
    }

    boolean canRead() throws IOException {
        return this.check_access(4);
    }

    boolean canWrite() throws IOException {
        return this.check_access(2);
    }

    void checkAttr() throws IOException {
        if (!this.attr.valid()) {
            this.getattr();
        }
    }

    private boolean check_access(int n) throws IOException {
        int n2 = 1;
        int n3 = 28;
        if (this.accessBits < 0 || !this.cacheOK(this.accessTime)) {
            Xdr xdr = new Xdr(this.rsize + 512);
            this.rpc.rpc_header(xdr, 4);
            xdr.xdr_bytes(this.fh);
            xdr.xdr_int(n2 | n3);
            Xdr xdr2 = this.rpc.rpc_call(xdr, 5000, 0);
            int n4 = xdr2.xdr_int();
            if (xdr2.xdr_bool()) {
                this.attr.getFattr(xdr2);
            }
            if (n4 != 0) {
                throw new NfsException(n4);
            }
            this.accessBits = xdr2.xdr_int();
            this.accessTime = this.attr.mtime;
        }
        if ((n & 4) != 0) {
            return (this.accessBits & n2) != 0;
        }
        if ((n & 2) != 0) {
            return (this.accessBits & n3) != 0;
        }
        return true;
    }

    long commit(int n, int n2) throws IOException {
        Xdr xdr = new Xdr(this.wsize + 512);
        this.rpc.rpc_header(xdr, 21);
        xdr.xdr_bytes(this.fh);
        xdr.xdr_hyper(n);
        xdr.xdr_u_int(n2);
        Xdr xdr2 = this.rpc.rpc_call(xdr, 2000, 0);
        int n3 = xdr2.xdr_int();
        if (xdr2.xdr_bool()) {
            xdr2.xdr_hyper();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
        }
        if (xdr2.xdr_bool()) {
            this.attr.getFattr(xdr2);
        }
        if (n3 != 0) {
            throw new NfsException(n3);
        }
        return xdr2.xdr_hyper();
    }

    Nfs create(String string, long l) throws IOException {
        Nfs3 nfs3;
        byte[] byArray = null;
        Fattr3 fattr3 = null;
        Xdr xdr = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(xdr, 8);
        xdr.xdr_bytes(this.fh);
        xdr.xdr_string(string);
        xdr.xdr_int(0);
        xdr.xdr_bool(true);
        xdr.xdr_u_int(l);
        xdr.xdr_bool(true);
        xdr.xdr_u_int(NfsConnect.getCred().getUid());
        xdr.xdr_bool(true);
        xdr.xdr_u_int(NfsConnect.getCred().getGid());
        xdr.xdr_bool(true);
        xdr.xdr_hyper(0L);
        xdr.xdr_int(1);
        xdr.xdr_int(1);
        Xdr xdr2 = this.rpc.rpc_call(xdr, 2000, 0);
        int n = xdr2.xdr_int();
        if (n != 0) {
            if (xdr2.xdr_bool()) {
                xdr2.xdr_hyper();
                xdr2.xdr_u_int();
                xdr2.xdr_u_int();
                xdr2.xdr_u_int();
                xdr2.xdr_u_int();
            }
            if (xdr2.xdr_bool()) {
                this.attr.getFattr(xdr2);
            }
            throw new NfsException(n);
        }
        if (xdr2.xdr_bool()) {
            byArray = xdr2.xdr_bytes();
        }
        if (xdr2.xdr_bool()) {
            fattr3 = new Fattr3(xdr2);
        }
        if (xdr2.xdr_bool()) {
            xdr2.xdr_hyper();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
        }
        if (xdr2.xdr_bool()) {
            this.attr.getFattr(xdr2);
        }
        if (byArray != null && fattr3 != null) {
            String string2 = new StringBuffer(String.valueOf(this.name)).append("/").append(string).toString();
            nfs3 = new Nfs3(this.rpc, byArray, string2, fattr3);
            Nfs.cache_put(nfs3);
        } else {
            nfs3 = null;
        }
        return nfs3;
    }

    boolean exists() throws IOException {
        this.checkAttr();
        return true;
    }

    void fsinfo() throws IOException {
        Xdr xdr = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(xdr, 19);
        xdr.xdr_bytes(this.fh);
        Xdr xdr2 = this.rpc.rpc_call(xdr, 2000, 0);
        int n = xdr2.xdr_int();
        if (xdr2.xdr_bool()) {
            this.attr.getFattr(xdr2);
        }
        if (n != 0) {
            throw new NfsException(n);
        }
        xdr2.xdr_u_int();
        xdr2.xdr_u_int();
        xdr2.xdr_u_int();
        xdr2.xdr_u_int();
        this.wsize = xdr2.xdr_int();
    }

    void getattr() throws IOException {
        Xdr xdr;
        Xdr xdr2 = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(xdr2, 1);
        xdr2.xdr_bytes(this.fh);
        try {
            xdr = this.rpc.rpc_call(xdr2, 2000, 2);
        }
        catch (IOException iOException) {
            return;
        }
        int n = xdr.xdr_int();
        if (n != 0) {
            throw new NfsException(n);
        }
        this.attr.getFattr(xdr);
    }

    void invalidate() {
        this.attr.validtime = 0L;
    }

    boolean isDirectory() throws IOException {
        this.checkAttr();
        return this.attr.ftype == 2;
    }

    boolean isFile() throws IOException {
        this.checkAttr();
        return this.attr.ftype == 1;
    }

    boolean isSymlink() throws IOException {
        this.checkAttr();
        return this.attr.ftype == 5;
    }

    long length() throws IOException {
        this.checkAttr();
        return this.maxLength > this.attr.size ? this.maxLength : this.attr.size;
    }

    Nfs lookup(String string) throws IOException {
        String string2;
        Fattr3 fattr3 = null;
        if (string == null) {
            string2 = this.name;
            string = this.name;
        } else {
            string2 = this.name == null ? string : new StringBuffer(String.valueOf(this.name)).append("/").append(string).toString();
        }
        Nfs nfs = Nfs.cache_get(this.rpc.conn.server, string2);
        if (nfs != null && nfs.cacheOK(this.cacheTime)) {
            if (((Nfs3)nfs).attr.ftype == 5) {
                nfs = NfsConnect.followLink(nfs);
            }
            return nfs;
        }
        Xdr xdr = new Xdr(this.rsize + 512);
        Xdr xdr2 = null;
        int n = 1;
        while (n >= 0) {
            this.rpc.rpc_header(xdr, 3);
            xdr.xdr_bytes(this.fh);
            xdr.xdr_string(string);
            try {
                xdr2 = this.rpc.rpc_call(xdr, 5000, 0);
                break;
            }
            catch (MsgRejectedException msgRejectedException) {
                if (this.fh.length == 0 && msgRejectedException.why == 5) {
                    String string3 = this.lookupSec();
                    if (string3 != null && NfsSecurity.getMech(string3) != null) {
                        this.rpc.setCred(new CredGss("nfs", NfsSecurity.getMech(string3), NfsSecurity.getService(string3), NfsSecurity.getQop(string3)));
                    }
                    if (string3 != null && string3.equals("1")) {
                        this.rpc.setCred(new CredUnix());
                    }
                }
                throw msgRejectedException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            --n;
        }
        int n2 = xdr2.xdr_int();
        if (n2 != 0) {
            if (xdr2.xdr_bool()) {
                this.attr.getFattr(xdr2);
            }
            throw new NfsException(n2);
        }
        byte[] byArray = xdr2.xdr_bytes();
        if (xdr2.xdr_bool()) {
            fattr3 = new Fattr3(xdr2);
        }
        if (xdr2.xdr_bool()) {
            this.attr.getFattr(xdr2);
        }
        nfs = new Nfs3(this.rpc, byArray, string2, fattr3);
        Nfs.cache_put(nfs);
        if (((Nfs3)nfs).attr.ftype == 5) {
            nfs = NfsConnect.followLink(nfs);
        }
        return nfs;
    }

    public String lookupSec() throws IOException {
        int n = 1;
        boolean bl = false;
        String string = null;
        Xdr xdr = new Xdr(this.rsize + 512);
        do {
            this.rpc.rpc_header(xdr, 3);
            xdr.xdr_bytes(new byte[0]);
            int n2 = this.name.getBytes().length + 2;
            byte[] byArray = new byte[n2];
            byArray[0] = -127;
            byArray[1] = (byte)n;
            System.arraycopy(this.name.getBytes(), 0, byArray, 2, this.name.getBytes().length);
            xdr.xdr_bytes(byArray);
            Xdr xdr2 = this.rpc.rpc_call(xdr, 5000, 3);
            int n3 = xdr2.xdr_int();
            if (n3 != 0) {
                return null;
            }
            int n4 = xdr2.xdr_int() / 4 - 1;
            byte[] byArray2 = xdr2.xdr_raw(1);
            if (byArray2[0] == 0) {
                bl = false;
            } else {
                bl = true;
                n += n4;
            }
            String string2 = NfsSecurity.getPrefer();
            while (n4-- > 0) {
                String string3 = Integer.toString(xdr2.xdr_int());
                if (string2 != null && string2.equals(string3)) {
                    return string2;
                }
                if (string != null || !NfsSecurity.hasValue(string3)) continue;
                string = string3;
            }
        } while (bl);
        return string;
    }

    Nfs mkdir(String string, long l) throws IOException {
        byte[] byArray = null;
        Fattr3 fattr3 = null;
        Nfs3 nfs3 = null;
        Xdr xdr = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(xdr, 9);
        xdr.xdr_bytes(this.fh);
        xdr.xdr_string(string);
        xdr.xdr_bool(true);
        xdr.xdr_u_int(l);
        xdr.xdr_bool(true);
        xdr.xdr_u_int(NfsConnect.getCred().getUid());
        xdr.xdr_bool(true);
        xdr.xdr_u_int(NfsConnect.getCred().getGid());
        xdr.xdr_bool(true);
        xdr.xdr_hyper(0L);
        xdr.xdr_int(1);
        xdr.xdr_int(1);
        Xdr xdr2 = this.rpc.rpc_call(xdr, 2000, 0);
        int n = xdr2.xdr_int();
        if (n != 0) {
            if (xdr2.xdr_bool()) {
                xdr2.xdr_hyper();
                xdr2.xdr_u_int();
                xdr2.xdr_u_int();
                xdr2.xdr_u_int();
                xdr2.xdr_u_int();
            }
            if (xdr2.xdr_bool()) {
                this.attr.getFattr(xdr2);
            }
            throw new NfsException(n);
        }
        if (xdr2.xdr_bool()) {
            byArray = xdr2.xdr_bytes();
        }
        if (xdr2.xdr_bool()) {
            fattr3 = new Fattr3(xdr2);
        }
        if (xdr2.xdr_bool()) {
            xdr2.xdr_hyper();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
        }
        if (xdr2.xdr_bool()) {
            this.attr.getFattr(xdr2);
        }
        if (byArray != null && fattr3 != null) {
            String string2 = new StringBuffer(String.valueOf(this.name)).append("/").append(string).toString();
            nfs3 = new Nfs3(this.rpc, byArray, string2, fattr3);
            Nfs.cache_put(nfs3);
        }
        this.dircache = null;
        return nfs3;
    }

    long mtime() throws IOException {
        this.checkAttr();
        return this.attr.mtime;
    }

    void read_otw(Buffer buffer) throws IOException {
        Xdr xdr = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(xdr, 6);
        xdr.xdr_bytes(this.fh);
        xdr.xdr_hyper(buffer.foffset);
        xdr.xdr_int(this.rsize);
        Xdr xdr2 = this.rpc.rpc_call(xdr, 1000, 0);
        int n = xdr2.xdr_int();
        if (xdr2.xdr_bool()) {
            this.attr.getFattr(xdr2);
        }
        if (n != 0) {
            throw new NfsException(n);
        }
        int n2 = xdr2.xdr_int();
        buffer.eof = xdr2.xdr_bool();
        if ((long)n2 != xdr2.xdr_u_int()) {
            throw new NfsException(10005);
        }
        buffer.buf = xdr2.xdr_buf();
        buffer.bufoff = xdr2.xdr_offset();
        buffer.buflen = n2;
        this.cacheTime = this.attr.mtime;
    }

    String[] readdir() throws IOException {
        Object object;
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        String[] stringArray = new String[32];
        int n = 0;
        if (this.dircache != null) {
            if (this.cacheOK(this.cacheTime)) {
                return this.dircache;
            }
            this.dircache = null;
            return this.readdir_old();
        }
        Xdr xdr = new Xdr(this.rsize + 512);
        while (!bl) {
            this.rpc.rpc_header(xdr, 17);
            xdr.xdr_bytes(this.fh);
            xdr.xdr_hyper(l);
            xdr.xdr_hyper(l2);
            xdr.xdr_u_int(1024L);
            xdr.xdr_u_int(8192L);
            object = this.rpc.rpc_call(xdr, 3000, 0);
            int n2 = ((Xdr)object).xdr_int();
            if (((Xdr)object).xdr_bool()) {
                this.attr.getFattr((Xdr)object);
            }
            if (n2 == 10004) {
                return this.readdir_old();
            }
            if (n2 != 0) {
                throw new NfsException(n2);
            }
            l2 = ((Xdr)object).xdr_hyper();
            while (((Xdr)object).xdr_bool()) {
                ((Xdr)object).xdr_hyper();
                String string = ((Xdr)object).xdr_string();
                l = ((Xdr)object).xdr_hyper();
                Fattr3 fattr3 = null;
                byte[] byArray = null;
                if (((Xdr)object).xdr_bool()) {
                    fattr3 = new Fattr3((Xdr)object);
                }
                if (((Xdr)object).xdr_bool()) {
                    byArray = ((Xdr)object).xdr_bytes();
                }
                if (string.equals(".") || string.equals("..")) continue;
                stringArray[n++] = string;
                if (n >= stringArray.length) {
                    String[] stringArray2 = stringArray;
                    stringArray = new String[n * 2];
                    System.arraycopy(stringArray2, 0, stringArray, 0, n);
                }
                if (byArray == null || fattr3 == null) continue;
                String string2 = this.name == null ? string : new StringBuffer(String.valueOf(this.name)).append("/").append(string).toString();
                Nfs.cache_put(new Nfs3(this.rpc, byArray, string2, fattr3));
            }
            bl = ((Xdr)object).xdr_bool();
        }
        if (n < stringArray.length) {
            object = stringArray;
            stringArray = new String[n];
            System.arraycopy(object, 0, stringArray, 0, n);
        }
        this.dircache = stringArray;
        this.cacheTime = this.attr.mtime;
        return stringArray;
    }

    String[] readdir_old() throws IOException {
        Object object;
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        String[] stringArray = new String[32];
        int n = 0;
        if (this.dircache != null && this.cacheOK(this.cacheTime)) {
            return this.dircache;
        }
        Xdr xdr = new Xdr(this.rsize + 512);
        while (!bl) {
            this.rpc.rpc_header(xdr, 16);
            xdr.xdr_bytes(this.fh);
            xdr.xdr_hyper(l);
            xdr.xdr_hyper(l2);
            xdr.xdr_u_int(8192L);
            object = this.rpc.rpc_call(xdr, 3000, 0);
            int n2 = ((Xdr)object).xdr_int();
            if (((Xdr)object).xdr_bool()) {
                this.attr.getFattr((Xdr)object);
            }
            if (n2 != 0) {
                throw new NfsException(n2);
            }
            l2 = ((Xdr)object).xdr_hyper();
            while (((Xdr)object).xdr_bool()) {
                ((Xdr)object).xdr_hyper();
                String string = ((Xdr)object).xdr_string();
                if (!string.equals(".") && !string.equals("..")) {
                    stringArray[n++] = string;
                }
                if (n >= stringArray.length) {
                    String[] stringArray2 = stringArray;
                    stringArray = new String[n * 2];
                    System.arraycopy(stringArray2, 0, stringArray, 0, n);
                }
                l = ((Xdr)object).xdr_hyper();
            }
            bl = ((Xdr)object).xdr_bool();
        }
        if (n == 0) {
            return null;
        }
        if (n < stringArray.length) {
            object = stringArray;
            stringArray = new String[n];
            System.arraycopy(object, 0, stringArray, 0, n);
        }
        this.dircache = stringArray;
        this.cacheTime = this.attr.mtime;
        return stringArray;
    }

    String readlink() throws IOException {
        if (this.symlink != null && this.cacheOK(this.cacheTime)) {
            return this.symlink;
        }
        Xdr xdr = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(xdr, 5);
        xdr.xdr_bytes(this.fh);
        Xdr xdr2 = this.rpc.rpc_call(xdr, 2000, 0);
        int n = xdr2.xdr_int();
        if (xdr2.xdr_bool()) {
            this.attr.getFattr(xdr2);
        }
        if (n != 0) {
            throw new NfsException(n);
        }
        this.symlink = xdr2.xdr_string();
        this.cacheTime = this.attr.mtime;
        return this.symlink;
    }

    boolean remove(String string) throws IOException {
        return this.remove_otw(12, string);
    }

    private boolean remove_otw(int n, String string) throws IOException {
        Xdr xdr = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(xdr, n);
        xdr.xdr_bytes(this.fh);
        xdr.xdr_string(string);
        Xdr xdr2 = this.rpc.rpc_call(xdr, 2000, 0);
        int n2 = xdr2.xdr_int();
        if (xdr2.xdr_bool()) {
            xdr2.xdr_hyper();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
        }
        if (xdr2.xdr_bool()) {
            this.attr.getFattr(xdr2);
        }
        if (n2 != 0) {
            throw new NfsException(n2);
        }
        Nfs.cache_remove(this, string);
        this.dircache = null;
        return true;
    }

    boolean rename(Nfs nfs, String string, String string2) throws IOException {
        Xdr xdr = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(xdr, 14);
        xdr.xdr_bytes(this.fh);
        xdr.xdr_string(string);
        xdr.xdr_bytes(nfs.getFH());
        xdr.xdr_string(string2);
        Xdr xdr2 = this.rpc.rpc_call(xdr, 2000, 0);
        int n = xdr2.xdr_int();
        if (xdr2.xdr_bool()) {
            xdr2.xdr_hyper();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
        }
        if (xdr2.xdr_bool()) {
            this.attr.getFattr(xdr2);
        }
        if (n != 0) {
            throw new NfsException(n);
        }
        Nfs.cache_remove(this, string);
        this.dircache = null;
        nfs.dircache = null;
        return true;
    }

    boolean rmdir(String string) throws IOException {
        return this.remove_otw(13, string);
    }

    int write_otw(Buffer buffer) throws IOException {
        Xdr xdr = new Xdr(this.wsize + 512);
        this.rpc.rpc_header(xdr, 7);
        xdr.xdr_bytes(this.fh);
        xdr.xdr_hyper(buffer.foffset + (long)buffer.minOffset);
        xdr.xdr_u_int(buffer.maxOffset - buffer.minOffset);
        xdr.xdr_int(buffer.syncType);
        xdr.xdr_bytes(buffer.buf, buffer.bufoff + buffer.minOffset, buffer.maxOffset - buffer.minOffset);
        Xdr xdr2 = this.rpc.rpc_call(xdr, 2000, 0);
        int n = xdr2.xdr_int();
        if (xdr2.xdr_bool()) {
            xdr2.xdr_hyper();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
            xdr2.xdr_u_int();
        }
        if (xdr2.xdr_bool()) {
            this.attr.getFattr(xdr2);
            this.cacheTime = this.attr.mtime;
        }
        if (n != 0) {
            throw new NfsException(n);
        }
        int n2 = xdr2.xdr_int();
        buffer.status = xdr2.xdr_int() == 2 ? 1 : 3;
        buffer.writeVerifier = xdr2.xdr_hyper();
        return n2;
    }
}

