/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.IntegerType;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StructureReadContext;
import com.sun.jna.StructureWriteContext;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.Union;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class Structure {
    private static final boolean REVERSE_FIELDS;
    static boolean REQUIRES_FIELD_ORDER;
    static final boolean isPPC;
    static final boolean isSPARC;
    public static final int ALIGN_DEFAULT = 0;
    public static final int ALIGN_NONE = 1;
    public static final int ALIGN_GNUC = 2;
    public static final int ALIGN_MSVC = 3;
    private static final int MAX_GNUC_ALIGNMENT;
    protected static final int CALCULATE_SIZE = -1;
    private Pointer memory;
    private int size = -1;
    private int alignType;
    private int structAlignment;
    private final Map structFields = new LinkedHashMap();
    private final Map nativeStrings = new HashMap();
    private TypeMapper typeMapper;
    private long typeInfo;
    private List fieldOrder;
    private boolean autoRead = true;
    private boolean autoWrite = true;
    private Structure[] array;
    private static final ThreadLocal busy;
    static /* synthetic */ Class class$com$sun$jna$Structure$MemberOrder;
    static /* synthetic */ Class class$com$sun$jna$Structure;
    static /* synthetic */ Class class$com$sun$jna$Callback;
    static /* synthetic */ Class class$java$nio$Buffer;
    static /* synthetic */ Class class$com$sun$jna$Pointer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$jna$WString;
    static /* synthetic */ Class class$com$sun$jna$Structure$ByReference;
    static /* synthetic */ Class class$com$sun$jna$NativeMapped;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Void;

    protected Structure() {
        this((Pointer)null);
    }

    protected Structure(TypeMapper mapper) {
        this(null, 0, mapper);
    }

    protected Structure(Pointer p) {
        this(p, 0);
    }

    protected Structure(Pointer p, int alignment) {
        this(p, alignment, null);
    }

    protected Structure(Pointer p, int alignment, TypeMapper mapper) {
        this.setAlignType(alignment);
        this.setTypeMapper(mapper);
        if (p != null) {
            this.useMemory(p);
        } else {
            this.allocateMemory(-1);
        }
    }

    Map fields() {
        return this.structFields;
    }

    protected void setTypeMapper(TypeMapper mapper) {
        Class<?> declaring;
        if (mapper == null && (declaring = this.getClass().getDeclaringClass()) != null) {
            mapper = Native.getTypeMapper(declaring);
        }
        this.typeMapper = mapper;
        this.size = -1;
        if (this.memory instanceof AutoAllocated) {
            this.memory = null;
        }
    }

    protected void setAlignType(int alignType) {
        if (alignType == 0) {
            Class<?> declaring = this.getClass().getDeclaringClass();
            if (declaring != null) {
                alignType = Native.getStructureAlignment(declaring);
            }
            if (alignType == 0) {
                alignType = Platform.isWindows() ? 3 : 2;
            }
        }
        this.alignType = alignType;
        this.size = -1;
        if (this.memory instanceof AutoAllocated) {
            this.memory = null;
        }
    }

    protected void useMemory(Pointer m) {
        this.useMemory(m, 0);
    }

    protected void useMemory(Pointer m, int offset) {
        try {
            this.memory = m.share(offset, this.size());
            this.array = null;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Structure exceeds provided memory bounds");
        }
    }

    protected void ensureAllocated() {
        if (this.size == -1) {
            this.allocateMemory();
        }
    }

    protected void allocateMemory() {
        this.allocateMemory(this.calculateSize(true));
    }

    protected void allocateMemory(int size) {
        if (size == -1) {
            size = this.calculateSize(false);
        } else if (size <= 0) {
            throw new IllegalArgumentException(new StringBuffer().append("Structure size must be greater than zero: ").append(size).toString());
        }
        if (size != -1) {
            if (this.memory == null || this.memory instanceof AutoAllocated) {
                this.memory = new AutoAllocated(size);
                this.memory.clear(size);
            }
            this.size = size;
        }
    }

    public int size() {
        this.ensureAllocated();
        return this.size;
    }

    public void clear() {
        this.memory.clear(this.size());
    }

    public Pointer getPointer() {
        this.ensureAllocated();
        return this.memory;
    }

    Set busy() {
        return (Set)busy.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        this.ensureAllocated();
        if (this.busy().contains(this)) {
            return;
        }
        this.busy().add(this);
        try {
            Iterator i = this.structFields.values().iterator();
            while (i.hasNext()) {
                this.readField((StructField)i.next());
            }
        }
        finally {
            this.busy().remove(this);
        }
    }

    public Object readField(String name) {
        this.ensureAllocated();
        StructField f = (StructField)this.structFields.get(name);
        if (f == null) {
            throw new IllegalArgumentException(new StringBuffer().append("No such field: ").append(name).toString());
        }
        return this.readField(f);
    }

    Object getField(StructField structField) {
        try {
            return structField.field.get(this);
        }
        catch (Exception e) {
            throw new Error(new StringBuffer().append("Exception reading field '").append(structField.name).append("' in ").append(this.getClass()).append(": ").append(e).toString());
        }
    }

    void setField(StructField structField, Object value) {
        try {
            structField.field.set(this, value);
        }
        catch (IllegalAccessException e) {
            throw new Error(new StringBuffer().append("Unexpectedly unable to write to field '").append(structField.name).append("' within ").append(this.getClass()).append(": ").append(e).toString());
        }
    }

    static Structure updateStructureByReference(Class type, Structure s, Pointer address) {
        if (address == null) {
            s = null;
        } else {
            if (s == null || !address.equals(s.getPointer())) {
                s = Structure.newInstance(type);
                s.useMemory(address);
            }
            s.autoRead();
        }
        return s;
    }

    Object readField(StructField structField) {
        int offset = structField.offset;
        Class fieldType = structField.type;
        FromNativeConverter readConverter = structField.readConverter;
        if (readConverter != null) {
            fieldType = readConverter.nativeType();
        }
        Object currentValue = (class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Structure.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(fieldType) || (class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Structure.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(fieldType) || (class$java$nio$Buffer == null ? (class$java$nio$Buffer = Structure.class$("java.nio.Buffer")) : class$java$nio$Buffer).isAssignableFrom(fieldType) || (class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = Structure.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer).isAssignableFrom(fieldType) || fieldType.isArray() ? this.getField(structField) : null;
        Object result = this.memory.getValue(offset, fieldType, currentValue);
        if (readConverter != null) {
            result = readConverter.fromNative(result, structField.context);
        }
        this.setField(structField, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() {
        this.ensureAllocated();
        if (this instanceof ByValue) {
            this.getTypeInfo();
        }
        if (this.busy().contains(this)) {
            return;
        }
        this.busy().add(this);
        try {
            for (StructField sf : this.structFields.values()) {
                if (sf.isVolatile) continue;
                this.writeField(sf);
            }
        }
        finally {
            this.busy().remove(this);
        }
    }

    public void writeField(String name) {
        this.ensureAllocated();
        StructField f = (StructField)this.structFields.get(name);
        if (f == null) {
            throw new IllegalArgumentException(new StringBuffer().append("No such field: ").append(name).toString());
        }
        this.writeField(f);
    }

    public void writeField(String name, Object value) {
        this.ensureAllocated();
        StructField f = (StructField)this.structFields.get(name);
        if (f == null) {
            throw new IllegalArgumentException(new StringBuffer().append("No such field: ").append(name).toString());
        }
        this.setField(f, value);
        this.writeField(f);
    }

    void writeField(StructField structField) {
        int offset = structField.offset;
        Object value = this.getField(structField);
        Class fieldType = structField.type;
        ToNativeConverter converter = structField.writeConverter;
        if (converter != null) {
            value = converter.toNative(value, new StructureWriteContext(this, structField.field));
            fieldType = converter.nativeType();
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = Structure.class$("java.lang.String")) : class$java$lang$String) == fieldType || (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Structure.class$("com.sun.jna.WString")) : class$com$sun$jna$WString) == fieldType) {
            boolean wide;
            boolean bl = wide = fieldType == (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Structure.class$("com.sun.jna.WString")) : class$com$sun$jna$WString);
            if (value != null) {
                NativeString nativeString = new NativeString(value.toString(), wide);
                this.nativeStrings.put(structField.name, nativeString);
                value = nativeString.getPointer();
            } else {
                value = null;
                this.nativeStrings.remove(structField.name);
            }
        }
        try {
            this.memory.setValue(offset, value, fieldType);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            String msg = new StringBuffer().append("Structure field \"").append(structField.name).append("\" was declared as ").append(structField.type).append(structField.type == fieldType ? "" : new StringBuffer().append(" (native type ").append(fieldType).append(")").toString()).append(", which is not supported within a Structure").toString();
            throw new IllegalArgumentException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getFieldOrder() {
        Structure structure = this;
        synchronized (structure) {
            if (this.fieldOrder == null) {
                this.fieldOrder = new ArrayList();
            }
            return this.fieldOrder;
        }
    }

    protected void setFieldOrder(String[] fields) {
        this.getFieldOrder().addAll(Arrays.asList(fields));
    }

    protected void sortFields(Field[] fields, String[] names) {
        block0: for (int i = 0; i < names.length; ++i) {
            for (int f = i; f < fields.length; ++f) {
                if (!names[i].equals(fields[f].getName())) continue;
                Field tmp = fields[f];
                fields[f] = fields[i];
                fields[i] = tmp;
                continue block0;
            }
        }
    }

    int calculateSize(boolean force) {
        int i;
        this.structAlignment = 1;
        int calculatedSize = 0;
        Field[] fields = this.getClass().getFields();
        ArrayList<Field> flist = new ArrayList<Field>();
        for (i = 0; i < fields.length; ++i) {
            int modifiers = fields[i].getModifiers();
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            flist.add(fields[i]);
        }
        fields = flist.toArray(new Field[flist.size()]);
        if (REVERSE_FIELDS) {
            for (i = 0; i < fields.length / 2; ++i) {
                int idx = fields.length - 1 - i;
                Field tmp = fields[i];
                fields[i] = fields[idx];
                fields[idx] = tmp;
            }
        } else if (REQUIRES_FIELD_ORDER) {
            List fieldOrder = this.getFieldOrder();
            if (fieldOrder.size() < fields.length) {
                if (force) {
                    throw new Error(new StringBuffer().append("This VM does not store fields in a predictable order; you must use setFieldOrder: ").append(System.getProperty("java.vendor")).append(", ").append(System.getProperty("java.version")).toString());
                }
                return -1;
            }
            this.sortFields(fields, fieldOrder.toArray(new String[fieldOrder.size()]));
        }
        for (int i2 = 0; i2 < fields.length; ++i2) {
            Field field = fields[i2];
            int modifiers = field.getModifiers();
            Class type = field.getType();
            StructField structField = new StructField();
            structField.isVolatile = Modifier.isVolatile(modifiers);
            structField.field = field;
            if (Modifier.isFinal(modifiers)) {
                field.setAccessible(true);
            }
            structField.name = field.getName();
            structField.type = type;
            if ((class$com$sun$jna$Callback == null ? Structure.class$("com.sun.jna.Callback") : class$com$sun$jna$Callback).isAssignableFrom(type) && !type.isInterface()) {
                throw new IllegalArgumentException(new StringBuffer().append("Structure Callback field '").append(field.getName()).append("' must be an interface").toString());
            }
            if (type.isArray() && (class$com$sun$jna$Structure == null ? Structure.class$("com.sun.jna.Structure") : class$com$sun$jna$Structure).equals(type.getComponentType())) {
                String msg = "Nested Structure arrays must use a derived Structure type so that the size of the elements can be determined";
                throw new IllegalArgumentException(msg);
            }
            int fieldAlignment = 1;
            if (!Modifier.isPublic(field.getModifiers())) continue;
            Object value = this.getField(structField);
            if (value == null) {
                if ((class$com$sun$jna$Structure == null ? Structure.class$("com.sun.jna.Structure") : class$com$sun$jna$Structure).isAssignableFrom(type) && !(class$com$sun$jna$Structure$ByReference == null ? Structure.class$("com.sun.jna.Structure$ByReference") : class$com$sun$jna$Structure$ByReference).isAssignableFrom(type)) {
                    try {
                        value = Structure.newInstance(type);
                        this.setField(structField, value);
                    }
                    catch (IllegalArgumentException e) {
                        String msg = new StringBuffer().append("Can't determine size of nested structure: ").append(e.getMessage()).toString();
                        throw new IllegalArgumentException(msg);
                    }
                } else if (type.isArray()) {
                    if (force) {
                        throw new IllegalStateException("Array fields must be initialized");
                    }
                    return -1;
                }
            }
            Class nativeType = type;
            if ((class$com$sun$jna$NativeMapped == null ? Structure.class$("com.sun.jna.NativeMapped") : class$com$sun$jna$NativeMapped).isAssignableFrom(type)) {
                NativeMappedConverter tc = NativeMappedConverter.getInstance(type);
                if (value == null) {
                    value = tc.defaultValue();
                    this.setField(structField, value);
                }
                nativeType = tc.nativeType();
                structField.writeConverter = tc;
                structField.readConverter = tc;
                structField.context = new StructureReadContext(this, field);
            } else if (this.typeMapper != null) {
                ToNativeConverter writeConverter = this.typeMapper.getToNativeConverter(type);
                FromNativeConverter readConverter = this.typeMapper.getFromNativeConverter(type);
                if (writeConverter != null && readConverter != null) {
                    nativeType = (value = writeConverter.toNative(value, new StructureWriteContext(this, structField.field))) != null ? value.getClass() : (class$com$sun$jna$Pointer == null ? Structure.class$("com.sun.jna.Pointer") : class$com$sun$jna$Pointer);
                    structField.writeConverter = writeConverter;
                    structField.readConverter = readConverter;
                    structField.context = new StructureReadContext(this, field);
                } else if (writeConverter != null || readConverter != null) {
                    String msg = new StringBuffer().append("Structures require bidirectional type conversion for ").append(type).toString();
                    throw new IllegalArgumentException(msg);
                }
            }
            try {
                structField.size = Native.getNativeSize(nativeType, value);
                fieldAlignment = this.getNativeAlignment(nativeType, value, i2 == 0);
            }
            catch (IllegalArgumentException e) {
                if (!force && this.typeMapper == null) {
                    return -1;
                }
                String msg = new StringBuffer().append("Invalid Structure field in ").append(this.getClass()).append(", field name '").append(structField.name).append("', ").append(structField.type).append(": ").append(e.getMessage()).toString();
                throw new IllegalArgumentException(msg);
            }
            this.structAlignment = Math.max(this.structAlignment, fieldAlignment);
            if (calculatedSize % fieldAlignment != 0) {
                calculatedSize += fieldAlignment - calculatedSize % fieldAlignment;
            }
            structField.offset = calculatedSize;
            calculatedSize += structField.size;
            this.structFields.put(structField.name, structField);
        }
        if (calculatedSize > 0) {
            int size = this.calculateAlignedSize(calculatedSize);
            if (this instanceof ByValue) {
                this.getTypeInfo();
            }
            return size;
        }
        throw new IllegalArgumentException(new StringBuffer().append("Structure ").append(this.getClass()).append(" has unknown size (ensure ").append("all fields are public)").toString());
    }

    int calculateAlignedSize(int calculatedSize) {
        if (this.alignType != 1 && calculatedSize % this.structAlignment != 0) {
            calculatedSize += this.structAlignment - calculatedSize % this.structAlignment;
        }
        return calculatedSize;
    }

    protected int getStructAlignment() {
        if (this.size == -1) {
            this.calculateSize(true);
        }
        return this.structAlignment;
    }

    protected int getNativeAlignment(Class type, Object value, boolean isFirstElement) {
        int alignment = 1;
        if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = Structure.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(type)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(type);
            type = tc.nativeType();
            value = tc.toNative(value, new ToNativeContext());
        }
        int size = Native.getNativeSize(type, value);
        if (type.isPrimitive() || (class$java$lang$Long == null ? (class$java$lang$Long = Structure.class$("java.lang.Long")) : class$java$lang$Long) == type || (class$java$lang$Integer == null ? (class$java$lang$Integer = Structure.class$("java.lang.Integer")) : class$java$lang$Integer) == type || (class$java$lang$Short == null ? (class$java$lang$Short = Structure.class$("java.lang.Short")) : class$java$lang$Short) == type || (class$java$lang$Character == null ? (class$java$lang$Character = Structure.class$("java.lang.Character")) : class$java$lang$Character) == type || (class$java$lang$Byte == null ? (class$java$lang$Byte = Structure.class$("java.lang.Byte")) : class$java$lang$Byte) == type || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Structure.class$("java.lang.Boolean")) : class$java$lang$Boolean) == type || (class$java$lang$Float == null ? (class$java$lang$Float = Structure.class$("java.lang.Float")) : class$java$lang$Float) == type || (class$java$lang$Double == null ? (class$java$lang$Double = Structure.class$("java.lang.Double")) : class$java$lang$Double) == type) {
            alignment = size;
        } else if ((class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = Structure.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer) == type || (class$java$nio$Buffer == null ? (class$java$nio$Buffer = Structure.class$("java.nio.Buffer")) : class$java$nio$Buffer).isAssignableFrom(type) || (class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Structure.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(type) || (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Structure.class$("com.sun.jna.WString")) : class$com$sun$jna$WString) == type || (class$java$lang$String == null ? (class$java$lang$String = Structure.class$("java.lang.String")) : class$java$lang$String) == type) {
            alignment = Pointer.SIZE;
        } else if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Structure.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(type)) {
            if ((class$com$sun$jna$Structure$ByReference == null ? (class$com$sun$jna$Structure$ByReference = Structure.class$("com.sun.jna.Structure$ByReference")) : class$com$sun$jna$Structure$ByReference).isAssignableFrom(type)) {
                alignment = Pointer.SIZE;
            } else {
                if (value == null) {
                    value = Structure.newInstance(type);
                }
                alignment = ((Structure)value).getStructAlignment();
            }
        } else if (type.isArray()) {
            alignment = this.getNativeAlignment(type.getComponentType(), null, isFirstElement);
        } else {
            throw new IllegalArgumentException(new StringBuffer().append("Type ").append(type).append(" has unknown ").append("native alignment").toString());
        }
        if (this.alignType == 1) {
            alignment = 1;
        } else if (this.alignType == 3) {
            alignment = Math.min(8, alignment);
        } else if (!(this.alignType != 2 || isFirstElement && Platform.isMac() && isPPC)) {
            alignment = Math.min(MAX_GNUC_ALIGNMENT, alignment);
        }
        return alignment;
    }

    public String toString() {
        return this.toString(0, true);
    }

    private String format(Class type) {
        String s = type.getName();
        int dot = s.lastIndexOf(".");
        return s.substring(dot + 1);
    }

    private String toString(int n, boolean bl) {
        Object object;
        String string = System.getProperty("line.separator");
        String string2 = new StringBuffer().append(this.format(this.getClass())).append("(").append(this.getPointer()).append(")").toString();
        if (!(this.getPointer() instanceof Memory)) {
            string2 = new StringBuffer().append(string2).append(" (").append(this.size()).append(" bytes)").toString();
        }
        String string3 = "";
        for (int i = 0; i < n; ++i) {
            string3 = new StringBuffer().append(string3).append("  ").toString();
        }
        String string4 = string;
        if (!bl) {
            string4 = "...}";
        } else {
            object = this.structFields.values().iterator();
            while (object.hasNext()) {
                StructField structField = (StructField)object.next();
                Object object2 = this.getField(structField);
                String string5 = this.format(structField.type);
                String string6 = "";
                string4 = new StringBuffer().append(string4).append(string3).toString();
                if (structField.type.isArray() && object2 != null) {
                    string5 = this.format(structField.type.getComponentType());
                    string6 = new StringBuffer().append("[").append(Array.getLength(object2)).append("]").toString();
                }
                string4 = new StringBuffer().append(string4).append("  ").append(string5).append(" ").append(structField.name).append(string6).append("@").append(Integer.toHexString(structField.offset)).toString();
                if (object2 instanceof Structure) {
                    object2 = ((Structure)object2).toString(n + 1, !(object2 instanceof ByReference));
                }
                string4 = new StringBuffer().append(string4).append("=").toString();
                string4 = object2 instanceof Long ? new StringBuffer().append(string4).append(Long.toHexString((Long)object2)).toString() : (object2 instanceof Integer ? new StringBuffer().append(string4).append(Integer.toHexString((Integer)object2)).toString() : (object2 instanceof Short ? new StringBuffer().append(string4).append(Integer.toHexString(((Short)object2).shortValue())).toString() : (object2 instanceof Byte ? new StringBuffer().append(string4).append(Integer.toHexString(((Byte)object2).byteValue())).toString() : new StringBuffer().append(string4).append(String.valueOf(object2).trim()).toString())));
                string4 = new StringBuffer().append(string4).append(string).toString();
                if (object.hasNext()) continue;
                string4 = new StringBuffer().append(string4).append(string3).append("}").toString();
            }
        }
        if (n == 0 && Boolean.getBoolean("jna.dump_memory")) {
            object = this.getPointer().getByteArray(0L, this.size());
            int n2 = 4;
            string4 = new StringBuffer().append(string4).append(string).append("memory dump").append(string).toString();
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (i % 4 == 0) {
                    string4 = new StringBuffer().append(string4).append("[").toString();
                }
                if (object[i] >= 0 && object[i] < 16) {
                    string4 = new StringBuffer().append(string4).append("0").toString();
                }
                string4 = new StringBuffer().append(string4).append(Integer.toHexString(object[i] & 0xFF)).toString();
                if (i % 4 != 3 || i >= ((Object)object).length - 1) continue;
                string4 = new StringBuffer().append(string4).append("]").append(string).toString();
            }
            string4 = new StringBuffer().append(string4).append("]").toString();
        }
        return new StringBuffer().append(string2).append(" {").append(string4).toString();
    }

    public Structure[] toArray(Structure[] array) {
        this.ensureAllocated();
        if (this.memory instanceof AutoAllocated) {
            Memory m = (Memory)this.memory;
            int requiredSize = array.length * this.size();
            if (m.getSize() < (long)requiredSize) {
                m = new AutoAllocated(requiredSize);
                m.clear();
                this.useMemory(m);
            }
        }
        array[0] = this;
        int size = this.size();
        for (int i = 1; i < array.length; ++i) {
            array[i] = Structure.newInstance(this.getClass());
            array[i].useMemory(this.memory.share(i * size, size));
            array[i].read();
        }
        if (!(this instanceof ByValue)) {
            this.array = array;
        }
        return array;
    }

    public Structure[] toArray(int size) {
        return this.toArray((Structure[])Array.newInstance(this.getClass(), size));
    }

    private Class baseClass() {
        if ((this instanceof ByReference || this instanceof ByValue) && (class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Structure.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(this.getClass().getSuperclass())) {
            return this.getClass().getSuperclass();
        }
        return this.getClass();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass() && ((Structure)o).baseClass() != this.baseClass()) {
            return false;
        }
        Structure s = (Structure)o;
        if (s.size() == this.size()) {
            this.clear();
            this.write();
            byte[] buf = this.getPointer().getByteArray(0L, this.size());
            s.clear();
            s.write();
            byte[] sbuf = s.getPointer().getByteArray(0L, s.size());
            return Arrays.equals(buf, sbuf);
        }
        return false;
    }

    public int hashCode() {
        this.clear();
        this.write();
        return Arrays.hashCode(this.getPointer().getByteArray(0L, this.size()));
    }

    protected void cacheTypeInfo(Pointer p) {
        this.typeInfo = p.peer;
    }

    Pointer getTypeInfo() {
        Pointer p = Structure.getTypeInfo(this);
        this.cacheTypeInfo(p);
        return p;
    }

    public void setAutoSynch(boolean auto) {
        this.setAutoRead(auto);
        this.setAutoWrite(auto);
    }

    public void setAutoRead(boolean auto) {
        this.autoRead = auto;
    }

    public boolean getAutoRead() {
        return this.autoRead;
    }

    public void setAutoWrite(boolean auto) {
        this.autoWrite = auto;
    }

    public boolean getAutoWrite() {
        return this.autoWrite;
    }

    static Pointer getTypeInfo(Object obj) {
        return FFIType.get(obj);
    }

    public static Structure newInstance(Class clazz) throws IllegalArgumentException {
        try {
            Structure structure = (Structure)clazz.newInstance();
            if (structure instanceof ByValue) {
                structure.allocateMemory();
            }
            return structure;
        }
        catch (InstantiationException instantiationException) {
            String string = new StringBuffer().append("Can't instantiate ").append(clazz).append(" (").append(instantiationException).append(")").toString();
            throw new IllegalArgumentException(string);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = new StringBuffer().append("Instantiation of ").append(clazz).append(" not allowed, is it public? (").append(illegalAccessException).append(")").toString();
            throw new IllegalArgumentException(string);
        }
    }

    private static void structureArrayCheck(Structure[] structureArray) {
        Pointer pointer = structureArray[0].getPointer();
        int n = structureArray[0].size();
        for (int i = 1; i < structureArray.length; ++i) {
            if (structureArray[i].getPointer().peer == pointer.peer + (long)(n * i)) continue;
            String string = new StringBuffer().append("Structure array elements must use contiguous memory (bad backing address at Structure array index ").append(i).append(")").toString();
            throw new IllegalArgumentException(string);
        }
    }

    public static void autoRead(Structure[] ss) {
        Structure.structureArrayCheck(ss);
        if (ss[0].array == ss) {
            ss[0].autoRead();
        } else {
            for (int si = 0; si < ss.length; ++si) {
                ss[si].autoRead();
            }
        }
    }

    public void autoRead() {
        if (this.getAutoRead()) {
            this.read();
            if (this.array != null) {
                for (int i = 1; i < this.array.length; ++i) {
                    this.array[i].autoRead();
                }
            }
        }
    }

    public static void autoWrite(Structure[] ss) {
        Structure.structureArrayCheck(ss);
        if (ss[0].array == ss) {
            ss[0].autoWrite();
        } else {
            for (int si = 0; si < ss.length; ++si) {
                ss[si].autoWrite();
            }
        }
    }

    public void autoWrite() {
        if (this.getAutoWrite()) {
            this.write();
            if (this.array != null) {
                for (int i = 1; i < this.array.length; ++i) {
                    this.array[i].autoWrite();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        Field[] fieldArray = (class$com$sun$jna$Structure$MemberOrder == null ? (class$com$sun$jna$Structure$MemberOrder = Structure.class$("com.sun.jna.Structure$MemberOrder")) : class$com$sun$jna$Structure$MemberOrder).getFields();
        REVERSE_FIELDS = "last".equals(fieldArray[0].getName());
        REQUIRES_FIELD_ORDER = !"middle".equals(fieldArray[1].getName());
        String string = System.getProperty("os.arch").toLowerCase();
        isPPC = "ppc".equals(string) || "powerpc".equals(string);
        isSPARC = "sparc".equals(string);
        MAX_GNUC_ALIGNMENT = isSPARC ? 8 : Native.LONG_SIZE;
        busy = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new StructureSet();
            }

            class StructureSet
            extends AbstractCollection
            implements Set {
                private Structure[] elements;
                private int count;

                StructureSet() {
                }

                private void ensureCapacity(int size) {
                    if (this.elements == null) {
                        this.elements = new Structure[size * 3 / 2];
                    } else if (this.elements.length < size) {
                        Structure[] e = new Structure[size * 3 / 2];
                        System.arraycopy(this.elements, 0, e, 0, this.elements.length);
                        this.elements = e;
                    }
                }

                public int size() {
                    return this.count;
                }

                public boolean contains(Object o) {
                    return this.indexOf(o) != -1;
                }

                public boolean add(Object o) {
                    if (!this.contains(o)) {
                        this.ensureCapacity(this.count + 1);
                        this.elements[this.count++] = (Structure)o;
                    }
                    return true;
                }

                private int indexOf(Object o) {
                    Structure s1 = (Structure)o;
                    for (int i = 0; i < this.count; ++i) {
                        Structure s2 = this.elements[i];
                        if (s1 != s2 && (s1.baseClass() != s2.baseClass() || s1.size() != s2.size() || !s1.getPointer().equals(s2.getPointer()))) continue;
                        return i;
                    }
                    return -1;
                }

                public boolean remove(Object o) {
                    int idx = this.indexOf(o);
                    if (idx != -1) {
                        if (--this.count > 0) {
                            this.elements[idx] = this.elements[this.count];
                            this.elements[this.count] = null;
                        }
                        return true;
                    }
                    return false;
                }

                public Iterator iterator() {
                    return null;
                }
            }
        };
    }

    private class AutoAllocated
    extends Memory {
        public AutoAllocated(int size) {
            super(size);
        }
    }

    static class FFIType
    extends Structure {
        private static Map typeInfoMap = new WeakHashMap();
        private static final int FFI_TYPE_STRUCT = 13;
        public size_t size;
        public short alignment;
        public short type = (short)13;
        public Pointer elements;

        private FFIType(Structure ref) {
            Pointer[] els;
            if (ref instanceof Union) {
                StructField sf = ((Union)ref).biggestField;
                els = new Pointer[]{FFIType.get(ref.getField(sf), sf.type), null};
            } else {
                els = new Pointer[ref.fields().size() + 1];
                int idx = 0;
                for (StructField sf : ref.fields().values()) {
                    els[idx++] = FFIType.get(ref.getField(sf), sf.type);
                }
            }
            this.init(els);
        }

        private FFIType(Object array, Class type) {
            int length = Array.getLength(array);
            Pointer[] els = new Pointer[length + 1];
            Pointer p = FFIType.get(null, type.getComponentType());
            for (int i = 0; i < length; ++i) {
                els[i] = p;
            }
            this.init(els);
        }

        private void init(Pointer[] els) {
            this.elements = new Memory(Pointer.SIZE * els.length);
            this.elements.write(0L, els, 0, els.length);
            this.write();
        }

        static Pointer get(Object obj) {
            if (obj == null) {
                return FFITypes.ffi_type_pointer;
            }
            if (obj instanceof Class) {
                return FFIType.get(null, (Class)obj);
            }
            return FFIType.get(obj, obj.getClass());
        }

        private static Pointer get(Object obj, Class cls) {
            Map map = typeInfoMap;
            synchronized (map) {
                Object o = typeInfoMap.get(cls);
                if (o instanceof Pointer) {
                    return (Pointer)o;
                }
                if (o instanceof FFIType) {
                    return ((FFIType)o).getPointer();
                }
                if ((class$java$nio$Buffer == null ? (class$java$nio$Buffer = Structure.class$("java.nio.Buffer")) : class$java$nio$Buffer).isAssignableFrom(cls) || (class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Structure.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(cls)) {
                    typeInfoMap.put(cls, FFITypes.ffi_type_pointer);
                    return FFITypes.ffi_type_pointer;
                }
                if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Structure.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(cls)) {
                    if (obj == null) {
                        obj = FFIType.newInstance(cls);
                    }
                    if ((class$com$sun$jna$Structure$ByReference == null ? (class$com$sun$jna$Structure$ByReference = Structure.class$("com.sun.jna.Structure$ByReference")) : class$com$sun$jna$Structure$ByReference).isAssignableFrom(cls)) {
                        typeInfoMap.put(cls, FFITypes.ffi_type_pointer);
                        return FFITypes.ffi_type_pointer;
                    }
                    FFIType type = new FFIType((Structure)obj);
                    typeInfoMap.put(cls, type);
                    return type.getPointer();
                }
                if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = Structure.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(cls)) {
                    NativeMappedConverter c = NativeMappedConverter.getInstance(cls);
                    return FFIType.get(c.toNative(obj, new ToNativeContext()), c.nativeType());
                }
                if (cls.isArray()) {
                    FFIType type = new FFIType(obj, cls);
                    typeInfoMap.put(obj, type);
                    return type.getPointer();
                }
                throw new IllegalArgumentException(new StringBuffer().append("Unsupported type ").append(cls).toString());
            }
        }

        static {
            if (Native.POINTER_SIZE == 0) {
                throw new Error("Native library not initialized");
            }
            if (FFITypes.ffi_type_void == null) {
                throw new Error("FFI types not initialized");
            }
            typeInfoMap.put(Void.TYPE, FFITypes.ffi_type_void);
            typeInfoMap.put(class$java$lang$Void == null ? (class$java$lang$Void = Structure.class$("java.lang.Void")) : class$java$lang$Void, FFITypes.ffi_type_void);
            typeInfoMap.put(Float.TYPE, FFITypes.ffi_type_float);
            typeInfoMap.put(class$java$lang$Float == null ? (class$java$lang$Float = Structure.class$("java.lang.Float")) : class$java$lang$Float, FFITypes.ffi_type_float);
            typeInfoMap.put(Double.TYPE, FFITypes.ffi_type_double);
            typeInfoMap.put(class$java$lang$Double == null ? (class$java$lang$Double = Structure.class$("java.lang.Double")) : class$java$lang$Double, FFITypes.ffi_type_double);
            typeInfoMap.put(Long.TYPE, FFITypes.ffi_type_sint64);
            typeInfoMap.put(class$java$lang$Long == null ? (class$java$lang$Long = Structure.class$("java.lang.Long")) : class$java$lang$Long, FFITypes.ffi_type_sint64);
            typeInfoMap.put(Integer.TYPE, FFITypes.ffi_type_sint32);
            typeInfoMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = Structure.class$("java.lang.Integer")) : class$java$lang$Integer, FFITypes.ffi_type_sint32);
            typeInfoMap.put(Short.TYPE, FFITypes.ffi_type_sint16);
            typeInfoMap.put(class$java$lang$Short == null ? (class$java$lang$Short = Structure.class$("java.lang.Short")) : class$java$lang$Short, FFITypes.ffi_type_sint16);
            Pointer ctype = Native.WCHAR_SIZE == 2 ? FFITypes.ffi_type_uint16 : FFITypes.ffi_type_uint32;
            typeInfoMap.put(Character.TYPE, ctype);
            typeInfoMap.put(class$java$lang$Character == null ? (class$java$lang$Character = Structure.class$("java.lang.Character")) : class$java$lang$Character, ctype);
            typeInfoMap.put(Byte.TYPE, FFITypes.ffi_type_sint8);
            typeInfoMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = Structure.class$("java.lang.Byte")) : class$java$lang$Byte, FFITypes.ffi_type_sint8);
            typeInfoMap.put(Boolean.TYPE, FFITypes.ffi_type_uint32);
            typeInfoMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Structure.class$("java.lang.Boolean")) : class$java$lang$Boolean, FFITypes.ffi_type_uint32);
            typeInfoMap.put(class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = Structure.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer, FFITypes.ffi_type_pointer);
            typeInfoMap.put(class$java$lang$String == null ? (class$java$lang$String = Structure.class$("java.lang.String")) : class$java$lang$String, FFITypes.ffi_type_pointer);
            typeInfoMap.put(class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Structure.class$("com.sun.jna.WString")) : class$com$sun$jna$WString, FFITypes.ffi_type_pointer);
        }

        private static class FFITypes {
            private static Pointer ffi_type_void;
            private static Pointer ffi_type_float;
            private static Pointer ffi_type_double;
            private static Pointer ffi_type_longdouble;
            private static Pointer ffi_type_uint8;
            private static Pointer ffi_type_sint8;
            private static Pointer ffi_type_uint16;
            private static Pointer ffi_type_sint16;
            private static Pointer ffi_type_uint32;
            private static Pointer ffi_type_sint32;
            private static Pointer ffi_type_uint64;
            private static Pointer ffi_type_sint64;
            private static Pointer ffi_type_pointer;

            private FFITypes() {
            }
        }

        public static class size_t
        extends IntegerType {
            public size_t() {
                this(0L);
            }

            public size_t(long value) {
                super(Native.POINTER_SIZE, value);
            }
        }
    }

    class StructField {
        public String name;
        public Class type;
        public Field field;
        public int size = -1;
        public int offset = -1;
        public boolean isVolatile;
        public FromNativeConverter readConverter;
        public ToNativeConverter writeConverter;
        public FromNativeContext context;

        StructField() {
        }
    }

    private static class MemberOrder {
        public int first;
        public int middle;
        public int last;

        private MemberOrder() {
        }
    }

    public static interface ByReference {
    }

    public static interface ByValue {
    }
}

