/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.FunctionMapper;
import com.sun.jna.Library;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.Buffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public final class Native {
    private static String nativeLibraryPath = null;
    private static boolean unpacked;
    private static Map typeMappers;
    private static Map alignments;
    private static Map options;
    private static Map libraries;
    private static final Callback.UncaughtExceptionHandler DEFAULT_HANDLER;
    private static Callback.UncaughtExceptionHandler callbackExceptionHandler;
    public static final int POINTER_SIZE;
    public static final int LONG_SIZE;
    public static final int WCHAR_SIZE;
    public static final int SIZE_T_SIZE;
    private static final int TYPE_VOIDP = 0;
    private static final int TYPE_LONG = 1;
    private static final int TYPE_WCHAR_T = 2;
    private static final int TYPE_SIZE_T = 3;
    private static final Object finalizer;
    private static final ThreadLocal lastError;
    private static Map registeredClasses;
    private static Map registeredLibraries;
    private static Object unloader;
    private static final int CVT_UNSUPPORTED = -1;
    private static final int CVT_DEFAULT = 0;
    private static final int CVT_POINTER = 1;
    private static final int CVT_STRING = 2;
    private static final int CVT_STRUCTURE = 3;
    private static final int CVT_STRUCTURE_BYVAL = 4;
    private static final int CVT_BUFFER = 5;
    private static final int CVT_ARRAY_BYTE = 6;
    private static final int CVT_ARRAY_SHORT = 7;
    private static final int CVT_ARRAY_CHAR = 8;
    private static final int CVT_ARRAY_INT = 9;
    private static final int CVT_ARRAY_LONG = 10;
    private static final int CVT_ARRAY_FLOAT = 11;
    private static final int CVT_ARRAY_DOUBLE = 12;
    private static final int CVT_ARRAY_BOOLEAN = 13;
    private static final int CVT_BOOLEAN = 14;
    private static final int CVT_CALLBACK = 15;
    private static final int CVT_FLOAT = 16;
    private static final int CVT_NATIVE_MAPPED = 17;
    private static final int CVT_WSTRING = 18;
    private static final int CVT_INTEGER_TYPE = 19;
    private static final int CVT_POINTER_TYPE = 20;
    private static final int CVT_TYPE_MAPPER = 21;
    static /* synthetic */ Class class$com$sun$jna$Native;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$com$sun$jna$Library;
    static /* synthetic */ Class class$com$sun$jna$Callback;
    static /* synthetic */ Class class$com$sun$jna$TypeMapper;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$jna$Structure;
    static /* synthetic */ Class class$com$sun$jna$Structure$ByReference;
    static /* synthetic */ Class class$com$sun$jna$NativeMapped;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$com$sun$jna$Structure$ByValue;
    static /* synthetic */ Class class$com$sun$jna$Pointer;
    static /* synthetic */ Class class$java$nio$Buffer;
    static /* synthetic */ Class class$com$sun$jna$WString;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$com$sun$jna$IntegerType;
    static /* synthetic */ Class class$com$sun$jna$PointerType;
    static /* synthetic */ Class class$com$sun$jna$LastErrorException;

    private static boolean deleteNativeLibrary() {
        String path = nativeLibraryPath;
        if (path == null || !unpacked) {
            return true;
        }
        File flib = new File(path);
        if (flib.delete()) {
            nativeLibraryPath = null;
            unpacked = false;
            return true;
        }
        try {
            ClassLoader cl = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("com.sun.jna.Native")) : class$com$sun$jna$Native).getClassLoader();
            Field f = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Native.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredField("nativeLibraries");
            f.setAccessible(true);
            List libs = (List)f.get(cl);
            for (Object lib : libs) {
                f = lib.getClass().getDeclaredField("name");
                f.setAccessible(true);
                String name = (String)f.get(lib);
                if (!name.equals(path) && name.indexOf(path) == -1) continue;
                Method m = lib.getClass().getDeclaredMethod("finalize", new Class[0]);
                m.setAccessible(true);
                m.invoke(lib, new Object[0]);
                nativeLibraryPath = null;
                if (unpacked && flib.exists()) {
                    if (flib.delete()) {
                        unpacked = false;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Native() {
    }

    private static native void initIDs();

    public static synchronized native void setProtected(boolean var0);

    public static synchronized native boolean isProtected();

    public static synchronized native void setPreserveLastError(boolean var0);

    public static synchronized native boolean getPreserveLastError();

    public static long getWindowID(Window w) throws HeadlessException {
        return Native.getComponentID(w);
    }

    public static long getComponentID(Component c) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException("No native windows when headless");
        }
        if (c.isLightweight()) {
            throw new IllegalArgumentException("Component must be heavyweight");
        }
        if (!c.isDisplayable()) {
            throw new IllegalStateException("Component must be displayable");
        }
        if (Platform.isX11() && System.getProperty("java.version").startsWith("1.4") && !c.isVisible()) {
            throw new IllegalStateException("Component must be visible");
        }
        return Native.getWindowHandle0(c);
    }

    public static Pointer getWindowPointer(Window w) throws HeadlessException {
        return Native.getComponentPointer(w);
    }

    public static Pointer getComponentPointer(Component c) throws HeadlessException {
        return new Pointer(Native.getComponentID(c));
    }

    private static native long getWindowHandle0(Component var0);

    public static native Pointer getDirectBufferPointer(Buffer var0);

    public static String toString(byte[] buf) {
        return Native.toString(buf, System.getProperty("jna.encoding"));
    }

    public static String toString(byte[] buf, String encoding) {
        int term;
        String s = null;
        if (encoding != null) {
            try {
                s = new String(buf, encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (s == null) {
            s = new String(buf);
        }
        if ((term = s.indexOf(0)) != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static String toString(char[] buf) {
        String s = new String(buf);
        int term = s.indexOf(0);
        if (term != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static Object loadLibrary(Class interfaceClass) {
        return Native.loadLibrary(null, interfaceClass);
    }

    public static Object loadLibrary(Class interfaceClass, Map options) {
        return Native.loadLibrary(null, interfaceClass, options);
    }

    public static Object loadLibrary(String name, Class interfaceClass) {
        return Native.loadLibrary(name, interfaceClass, Collections.EMPTY_MAP);
    }

    public static Object loadLibrary(String name, Class interfaceClass, Map options) {
        Library.Handler handler = new Library.Handler(name, interfaceClass, options);
        ClassLoader loader = interfaceClass.getClassLoader();
        Library proxy = (Library)Proxy.newProxyInstance(loader, new Class[]{interfaceClass}, (InvocationHandler)handler);
        Native.cacheOptions(interfaceClass, options, proxy);
        return proxy;
    }

    private static void loadLibraryInstance(Class cls) {
        if (cls != null && !libraries.containsKey(cls)) {
            try {
                Field[] fields = cls.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (field.getType() != cls || !Modifier.isStatic(field.getModifiers())) continue;
                    libraries.put(cls, new WeakReference<Object>(field.get(null)));
                    break;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(new StringBuffer().append("Could not access instance of ").append(cls).append(" (").append(e).append(")").toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class findEnclosingLibraryClass(Class cls) {
        Class<?> declaring;
        Class fromDeclaring;
        if (cls == null) {
            return null;
        }
        Map map = libraries;
        synchronized (map) {
            if (options.containsKey(cls)) {
                return cls;
            }
        }
        if ((class$com$sun$jna$Library == null ? (class$com$sun$jna$Library = Native.class$("com.sun.jna.Library")) : class$com$sun$jna$Library).isAssignableFrom(cls)) {
            return cls;
        }
        if ((class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Native.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(cls)) {
            cls = CallbackReference.findCallbackClass(cls);
        }
        if ((fromDeclaring = Native.findEnclosingLibraryClass(declaring = cls.getDeclaringClass())) != null) {
            return fromDeclaring;
        }
        return Native.findEnclosingLibraryClass(cls.getSuperclass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getLibraryOptions(Class type) {
        Map map = libraries;
        synchronized (map) {
            Class interfaceClass = Native.findEnclosingLibraryClass(type);
            if (interfaceClass != null) {
                Native.loadLibraryInstance(interfaceClass);
            } else {
                interfaceClass = type;
            }
            if (!options.containsKey(interfaceClass)) {
                try {
                    Field field = interfaceClass.getField("OPTIONS");
                    field.setAccessible(true);
                    options.put(interfaceClass, field.get(null));
                }
                catch (NoSuchFieldException e) {
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(new StringBuffer().append("OPTIONS must be a public field of type java.util.Map (").append(e).append("): ").append(interfaceClass).toString());
                }
            }
            return (Map)options.get(interfaceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeMapper getTypeMapper(Class cls) {
        Map map = libraries;
        synchronized (map) {
            Class interfaceClass = Native.findEnclosingLibraryClass(cls);
            if (interfaceClass != null) {
                Native.loadLibraryInstance(interfaceClass);
            } else {
                interfaceClass = cls;
            }
            if (!typeMappers.containsKey(interfaceClass)) {
                try {
                    Field field = interfaceClass.getField("TYPE_MAPPER");
                    field.setAccessible(true);
                    typeMappers.put(interfaceClass, field.get(null));
                }
                catch (NoSuchFieldException e) {
                    Map options = Native.getLibraryOptions(cls);
                    if (options != null && options.containsKey("type-mapper")) {
                        typeMappers.put(interfaceClass, options.get("type-mapper"));
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(new StringBuffer().append("TYPE_MAPPER must be a public field of type ").append((class$com$sun$jna$TypeMapper == null ? (class$com$sun$jna$TypeMapper = Native.class$("com.sun.jna.TypeMapper")) : class$com$sun$jna$TypeMapper).getName()).append(" (").append(e).append("): ").append(interfaceClass).toString());
                }
            }
            return (TypeMapper)typeMappers.get(interfaceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStructureAlignment(Class cls) {
        Map map = libraries;
        synchronized (map) {
            Integer value;
            Class interfaceClass = Native.findEnclosingLibraryClass(cls);
            if (interfaceClass != null) {
                Native.loadLibraryInstance(interfaceClass);
            } else {
                interfaceClass = cls;
            }
            if (!alignments.containsKey(interfaceClass)) {
                try {
                    Field field = interfaceClass.getField("STRUCTURE_ALIGNMENT");
                    field.setAccessible(true);
                    alignments.put(interfaceClass, field.get(null));
                }
                catch (NoSuchFieldException e) {
                    Map options = Native.getLibraryOptions(interfaceClass);
                    if (options != null && options.containsKey("structure-alignment")) {
                        alignments.put(interfaceClass, options.get("structure-alignment"));
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(new StringBuffer().append("STRUCTURE_ALIGNMENT must be a public field of type int (").append(e).append("): ").append(interfaceClass).toString());
                }
            }
            int n = (value = (Integer)alignments.get(interfaceClass)) != null ? value : 0;
            return n;
        }
    }

    static byte[] getBytes(String s) {
        try {
            return Native.getBytes(s, System.getProperty("jna.encoding"));
        }
        catch (UnsupportedEncodingException e) {
            return s.getBytes();
        }
    }

    static byte[] getBytes(String s, String encoding) throws UnsupportedEncodingException {
        if (encoding != null) {
            return s.getBytes(encoding);
        }
        return s.getBytes();
    }

    public static byte[] toByteArray(String s) {
        byte[] bytes = Native.getBytes(s);
        byte[] buf = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, buf, 0, bytes.length);
        return buf;
    }

    public static byte[] toByteArray(String s, String encoding) throws UnsupportedEncodingException {
        byte[] bytes = Native.getBytes(s, encoding);
        byte[] buf = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, buf, 0, bytes.length);
        return buf;
    }

    public static char[] toCharArray(String s) {
        char[] chars = s.toCharArray();
        char[] buf = new char[chars.length + 1];
        System.arraycopy(chars, 0, buf, 0, chars.length);
        return buf;
    }

    static String getNativeLibraryResourcePath(int osType, String arch, String name) {
        String osPrefix;
        arch = arch.toLowerCase();
        switch (osType) {
            case 2: {
                if ("i386".equals(arch)) {
                    arch = "x86";
                }
                osPrefix = new StringBuffer().append("win32-").append(arch).toString();
                break;
            }
            case 0: {
                osPrefix = "darwin";
                break;
            }
            case 1: {
                if ("x86".equals(arch)) {
                    arch = "i386";
                } else if ("x86_64".equals(arch)) {
                    arch = "amd64";
                }
                osPrefix = new StringBuffer().append("linux-").append(arch).toString();
                break;
            }
            case 3: {
                osPrefix = new StringBuffer().append("sunos-").append(arch).toString();
                break;
            }
            default: {
                int space;
                osPrefix = name.toLowerCase();
                if ("x86".equals(arch)) {
                    arch = "i386";
                }
                if ("x86_64".equals(arch)) {
                    arch = "amd64";
                }
                if ("powerpc".equals(arch)) {
                    arch = "ppc";
                }
                if ((space = osPrefix.indexOf(" ")) != -1) {
                    osPrefix = osPrefix.substring(0, space);
                }
                osPrefix = new StringBuffer().append(osPrefix).append("-").append(arch).toString();
            }
        }
        return new StringBuffer().append("/com/sun/jna/").append(osPrefix).toString();
    }

    private static void loadNativeLibrary() {
        String libName = "jnidispatch";
        String bootPath = System.getProperty("jna.boot.library.path");
        if (bootPath != null) {
            String[] dirs = bootPath.split(File.pathSeparator);
            for (int i = 0; i < dirs.length; ++i) {
                String path = new File(new File(dirs[i]), System.mapLibraryName(libName)).getAbsolutePath();
                try {
                    System.load(path);
                    nativeLibraryPath = path;
                    return;
                }
                catch (UnsatisfiedLinkError ex) {
                    String ext;
                    String orig;
                    if (!Platform.isMac()) continue;
                    if (path.endsWith("dylib")) {
                        orig = "dylib";
                        ext = "jnilib";
                    } else {
                        orig = "jnilib";
                        ext = "dylib";
                    }
                    try {
                        path = new StringBuffer().append(path.substring(0, path.lastIndexOf(orig))).append(ext).toString();
                        System.load(path);
                        nativeLibraryPath = path;
                        return;
                    }
                    catch (UnsatisfiedLinkError ex2) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        try {
            System.loadLibrary(libName);
            nativeLibraryPath = libName;
        }
        catch (UnsatisfiedLinkError e) {
            Native.loadNativeLibraryFromJar();
        }
    }

    private static void loadNativeLibraryFromJar() {
        String resourceName;
        String libname = System.mapLibraryName("jnidispatch");
        String arch = System.getProperty("os.arch");
        String name = System.getProperty("os.name");
        URL url = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("com.sun.jna.Native")) : class$com$sun$jna$Native).getResource(resourceName = new StringBuffer().append(Native.getNativeLibraryResourcePath(Platform.getOSType(), arch, name)).append("/").append(libname).toString());
        if (url == null && Platform.isMac() && resourceName.endsWith(".dylib")) {
            resourceName = new StringBuffer().append(resourceName.substring(0, resourceName.lastIndexOf(".dylib"))).append(".jnilib").toString();
            url = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("com.sun.jna.Native")) : class$com$sun$jna$Native).getResource(resourceName);
        }
        if (url == null) {
            throw new UnsatisfiedLinkError(new StringBuffer().append("jnidispatch (").append(resourceName).append(") not found in resource path").toString());
        }
        File lib = null;
        if (url.getProtocol().toLowerCase().equals("file")) {
            lib = new File(URLDecoder.decode(url.getPath()));
        } else {
            InputStream is = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("com.sun.jna.Native")) : class$com$sun$jna$Native).getResourceAsStream(resourceName);
            if (is == null) {
                throw new Error("Can't obtain jnidispatch InputStream");
            }
            FileOutputStream fos = null;
            try {
                int count;
                lib = File.createTempFile("jna", Platform.isWindows() ? ".dll" : null);
                lib.deleteOnExit();
                ClassLoader cl = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("com.sun.jna.Native")) : class$com$sun$jna$Native).getClassLoader();
                if (Platform.deleteNativeLibraryAfterVMExit() && (cl == null || cl.equals(ClassLoader.getSystemClassLoader()))) {
                    Runtime.getRuntime().addShutdownHook(new DeleteNativeLibrary(lib));
                }
                fos = new FileOutputStream(lib);
                byte[] buf = new byte[1024];
                while ((count = is.read(buf, 0, buf.length)) > 0) {
                    fos.write(buf, 0, count);
                }
            }
            catch (IOException e) {
                throw new Error(new StringBuffer().append("Failed to create temporary file for jnidispatch library: ").append(e).toString());
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
            unpacked = true;
        }
        System.load(lib.getAbsolutePath());
        nativeLibraryPath = lib.getAbsolutePath();
    }

    private static native int sizeof(int var0);

    private static native String getNativeVersion();

    private static native String getAPIChecksum();

    public static int getLastError() {
        return (Integer)lastError.get();
    }

    public static native void setLastError(int var0);

    static void updateLastError(int e) {
        lastError.set(new Integer(e));
    }

    public static Library synchronizedLibrary(final Library library) {
        Class<?> cls = library.getClass();
        if (!Proxy.isProxyClass(cls)) {
            throw new IllegalArgumentException("Library must be a proxy class");
        }
        InvocationHandler ih = Proxy.getInvocationHandler(library);
        if (!(ih instanceof Library.Handler)) {
            throw new IllegalArgumentException(new StringBuffer().append("Unrecognized proxy handler: ").append(ih).toString());
        }
        final Library.Handler handler = (Library.Handler)ih;
        InvocationHandler newHandler = new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                NativeLibrary nativeLibrary = handler.getNativeLibrary();
                synchronized (nativeLibrary) {
                    return handler.invoke(library, method, args);
                }
            }
        };
        return (Library)Proxy.newProxyInstance(cls.getClassLoader(), cls.getInterfaces(), newHandler);
    }

    public static String getWebStartLibraryPath(String libName) {
        if (System.getProperty("javawebstart.version") == null) {
            return null;
        }
        try {
            ClassLoader cl = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("com.sun.jna.Native")) : class$com$sun$jna$Native).getClassLoader();
            Method m = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Method m = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Native.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("findLibrary", class$java$lang$String == null ? (class$java$lang$String = Native.class$("java.lang.String")) : class$java$lang$String);
                        m.setAccessible(true);
                        return m;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
            String libpath = (String)m.invoke((Object)cl, libName);
            if (libpath != null) {
                return new File(libpath).getParent();
            }
            String msg = new StringBuffer().append("Library '").append(libName).append("' was not found by class loader ").append(cl).toString();
            throw new UnsatisfiedLinkError(msg);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getNativeSize(Class type, Object value) {
        if (type.isArray()) {
            int len = Array.getLength(value);
            if (len > 0) {
                Object o = Array.get(value, 0);
                return len * Native.getNativeSize(type.getComponentType(), o);
            }
            throw new IllegalArgumentException(new StringBuffer().append("Arrays of length zero not allowed: ").append(type).toString());
        }
        if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Native.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(type) && !(class$com$sun$jna$Structure$ByReference == null ? (class$com$sun$jna$Structure$ByReference = Native.class$("com.sun.jna.Structure$ByReference")) : class$com$sun$jna$Structure$ByReference).isAssignableFrom(type)) {
            if (value == null) {
                value = Structure.newInstance(type);
            }
            return ((Structure)value).size();
        }
        try {
            return Native.getNativeSize(type);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(new StringBuffer().append("The type \"").append(type.getName()).append("\" is not supported: ").append(e.getMessage()).toString());
        }
    }

    public static int getNativeSize(Class clazz) {
        if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = Native.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(clazz)) {
            clazz = NativeMappedConverter.getInstance(clazz).nativeType();
        }
        if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Native.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return 4;
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Native.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return 1;
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Native.class$("java.lang.Short")) : class$java$lang$Short)) {
            return 2;
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Native.class$("java.lang.Character")) : class$java$lang$Character)) {
            return WCHAR_SIZE;
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Native.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return 4;
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Native.class$("java.lang.Long")) : class$java$lang$Long)) {
            return 8;
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Native.class$("java.lang.Float")) : class$java$lang$Float)) {
            return 4;
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Native.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 8;
        }
        if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Native.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(clazz)) {
            if ((class$com$sun$jna$Structure$ByValue == null ? (class$com$sun$jna$Structure$ByValue = Native.class$("com.sun.jna.Structure$ByValue")) : class$com$sun$jna$Structure$ByValue).isAssignableFrom(clazz)) {
                return Structure.newInstance(clazz).size();
            }
            return POINTER_SIZE;
        }
        if ((class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = Native.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer).isAssignableFrom(clazz) || (class$java$nio$Buffer == null ? (class$java$nio$Buffer = Native.class$("java.nio.Buffer")) : class$java$nio$Buffer).isAssignableFrom(clazz) || (class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Native.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(clazz) || (class$java$lang$String == null ? (class$java$lang$String = Native.class$("java.lang.String")) : class$java$lang$String) == clazz || (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Native.class$("com.sun.jna.WString")) : class$com$sun$jna$WString) == clazz) {
            return POINTER_SIZE;
        }
        throw new IllegalArgumentException(new StringBuffer().append("Native size for type \"").append(clazz.getName()).append("\" is unknown").toString());
    }

    public static boolean isSupportedNativeType(Class cls) {
        if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Native.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(cls)) {
            return true;
        }
        try {
            return Native.getNativeSize(cls) != 0;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void setCallbackExceptionHandler(Callback.UncaughtExceptionHandler eh) {
        callbackExceptionHandler = eh == null ? DEFAULT_HANDLER : eh;
    }

    public static Callback.UncaughtExceptionHandler getCallbackExceptionHandler() {
        return callbackExceptionHandler;
    }

    public static void register(String libName) {
        Native.register(Native.getNativeClass(Native.getCallingClass()), NativeLibrary.getInstance(libName));
    }

    public static void register(NativeLibrary lib) {
        Native.register(Native.getNativeClass(Native.getCallingClass()), lib);
    }

    static Class getNativeClass(Class clazz) {
        int n;
        Method[] methodArray = clazz.getDeclaredMethods();
        for (n = 0; n < methodArray.length; ++n) {
            if ((methodArray[n].getModifiers() & 0x100) == 0) continue;
            return clazz;
        }
        n = clazz.getName().lastIndexOf("$");
        if (n != -1) {
            String string = clazz.getName().substring(0, n);
            try {
                return Native.getNativeClass(Class.forName(string, true, clazz.getClassLoader()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(new StringBuffer().append("Can't determine class with native methods from the current context (").append(clazz).append(")").toString());
    }

    static Class getCallingClass() {
        Class[] classArray = new SecurityManager(){

            public Class[] getClassContext() {
                return super.getClassContext();
            }
        }.getClassContext();
        if (classArray.length < 4) {
            throw new IllegalStateException("This method must be called from the static initializer of a class");
        }
        return classArray[3];
    }

    public static void unregister() {
        Native.unregister(Native.getNativeClass(Native.getCallingClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(Class cls) {
        Map map = registeredClasses;
        synchronized (map) {
            if (registeredClasses.containsKey(cls)) {
                Native.unregister(cls, (long[])registeredClasses.get(cls));
                registeredClasses.remove(cls);
                registeredLibraries.remove(cls);
            }
        }
    }

    private static native void unregister(Class var0, long[] var1);

    private static String getSignature(Class clazz) {
        if (clazz.isArray()) {
            return new StringBuffer().append("[").append(Native.getSignature(clazz.getComponentType())).toString();
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return "V";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
        }
        return new StringBuffer().append("L").append(clazz.getName().replace(".", "/")).append(";").toString();
    }

    private static int getConversion(Class clazz, TypeMapper typeMapper) {
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Native.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            clazz = Boolean.TYPE;
        } else if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Native.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            clazz = Byte.TYPE;
        } else if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Native.class$("java.lang.Short")) : class$java$lang$Short)) {
            clazz = Short.TYPE;
        } else if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Native.class$("java.lang.Character")) : class$java$lang$Character)) {
            clazz = Character.TYPE;
        } else if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Native.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            clazz = Integer.TYPE;
        } else if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Native.class$("java.lang.Long")) : class$java$lang$Long)) {
            clazz = Long.TYPE;
        } else if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Native.class$("java.lang.Float")) : class$java$lang$Float)) {
            clazz = Float.TYPE;
        } else if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Native.class$("java.lang.Double")) : class$java$lang$Double)) {
            clazz = Double.TYPE;
        } else if (clazz == (class$java$lang$Void == null ? (class$java$lang$Void = Native.class$("java.lang.Void")) : class$java$lang$Void)) {
            clazz = Void.TYPE;
        }
        if (typeMapper != null && (typeMapper.getFromNativeConverter(clazz) != null || typeMapper.getToNativeConverter(clazz) != null)) {
            return 21;
        }
        if ((class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = Native.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer).isAssignableFrom(clazz)) {
            return 1;
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = Native.class$("java.lang.String")) : class$java$lang$String) == clazz) {
            return 2;
        }
        if ((class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Native.class$("com.sun.jna.WString")) : class$com$sun$jna$WString).isAssignableFrom(clazz)) {
            return 18;
        }
        if ((class$java$nio$Buffer == null ? (class$java$nio$Buffer = Native.class$("java.nio.Buffer")) : class$java$nio$Buffer).isAssignableFrom(clazz)) {
            return 5;
        }
        if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Native.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(clazz)) {
            if ((class$com$sun$jna$Structure$ByValue == null ? (class$com$sun$jna$Structure$ByValue = Native.class$("com.sun.jna.Structure$ByValue")) : class$com$sun$jna$Structure$ByValue).isAssignableFrom(clazz)) {
                return 4;
            }
            return 3;
        }
        if (clazz.isArray()) {
            switch (clazz.getName().charAt(1)) {
                case 'Z': {
                    return 13;
                }
                case 'B': {
                    return 6;
                }
                case 'S': {
                    return 7;
                }
                case 'C': {
                    return 8;
                }
                case 'I': {
                    return 9;
                }
                case 'J': {
                    return 10;
                }
                case 'F': {
                    return 11;
                }
                case 'D': {
                    return 12;
                }
            }
        }
        if (clazz.isPrimitive()) {
            return clazz == Boolean.TYPE ? 14 : 0;
        }
        if ((class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Native.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(clazz)) {
            return 15;
        }
        if ((class$com$sun$jna$IntegerType == null ? (class$com$sun$jna$IntegerType = Native.class$("com.sun.jna.IntegerType")) : class$com$sun$jna$IntegerType).isAssignableFrom(clazz)) {
            return 19;
        }
        if ((class$com$sun$jna$PointerType == null ? (class$com$sun$jna$PointerType = Native.class$("com.sun.jna.PointerType")) : class$com$sun$jna$PointerType).isAssignableFrom(clazz)) {
            return 20;
        }
        if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = Native.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(clazz)) {
            return 17;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Class clazz, NativeLibrary nativeLibrary) {
        Method[] methodArray = clazz.getDeclaredMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        TypeMapper typeMapper = (TypeMapper)nativeLibrary.getOptions().get("type-mapper");
        for (int i = 0; i < methodArray.length; ++i) {
            if ((methodArray[i].getModifiers() & 0x100) == 0) continue;
            arrayList.add(methodArray[i]);
        }
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < lArray.length; ++i) {
            Object object;
            long l;
            long l2;
            Method method = (Method)arrayList.get(i);
            String string = "(";
            Class<?> clazz2 = method.getReturnType();
            Class<?>[] classArray = method.getParameterTypes();
            long[] lArray2 = new long[classArray.length];
            long[] lArray3 = new long[classArray.length];
            int[] nArray = new int[classArray.length];
            ToNativeConverter[] toNativeConverterArray = new ToNativeConverter[classArray.length];
            FromNativeConverter fromNativeConverter = null;
            int n = Native.getConversion(clazz2, typeMapper);
            boolean bl = false;
            switch (n) {
                case -1: {
                    throw new IllegalArgumentException(new StringBuffer().append(clazz2).append(" is not a supported return type (in method ").append(method.getName()).append(" in ").append(clazz).append(")").toString());
                }
                case 21: {
                    fromNativeConverter = typeMapper.getFromNativeConverter(clazz2);
                    l2 = Structure.FFIType.get(clazz2).peer;
                    l = Structure.FFIType.get((Object)fromNativeConverter.nativeType()).peer;
                    break;
                }
                case 17: 
                case 19: 
                case 20: {
                    l2 = Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                    l = Structure.FFIType.get((Object)NativeMappedConverter.getInstance(clazz2).nativeType()).peer;
                    break;
                }
                case 3: {
                    l2 = l = Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                    break;
                }
                case 4: {
                    l2 = Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                    l = Structure.FFIType.get(clazz2).peer;
                    break;
                }
                default: {
                    l2 = l = Structure.FFIType.get(clazz2).peer;
                }
            }
            block19: for (int j = 0; j < classArray.length; ++j) {
                object = classArray[j];
                string = new StringBuffer().append(string).append(Native.getSignature(object)).toString();
                nArray[j] = Native.getConversion(object, typeMapper);
                if (nArray[j] == -1) {
                    throw new IllegalArgumentException(new StringBuffer().append(object).append(" is not a supported argument type (in method ").append(method.getName()).append(" in ").append(clazz).append(")").toString());
                }
                if (nArray[j] == 17 || nArray[j] == 19) {
                    object = NativeMappedConverter.getInstance(object).nativeType();
                } else if (nArray[j] == 21) {
                    toNativeConverterArray[j] = typeMapper.getToNativeConverter((Class)object);
                }
                switch (nArray[j]) {
                    case 4: 
                    case 17: 
                    case 19: 
                    case 20: {
                        lArray2[j] = Structure.FFIType.get((Object)object).peer;
                        lArray3[j] = Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                        continue block19;
                    }
                    case 21: {
                        lArray3[j] = ((Class)object).isPrimitive() ? Structure.FFIType.get((Object)object).peer : Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                        lArray2[j] = Structure.FFIType.get((Object)toNativeConverterArray[j].nativeType()).peer;
                        continue block19;
                    }
                    case 0: {
                        lArray3[j] = lArray2[j] = Structure.FFIType.get((Object)object).peer;
                        continue block19;
                    }
                    default: {
                        lArray3[j] = lArray2[j] = Structure.FFIType.get((Object)(Native.class$com$sun$jna$Pointer == null ? Native.class$((String)"com.sun.jna.Pointer") : Native.class$com$sun$jna$Pointer)).peer;
                    }
                }
            }
            string = new StringBuffer().append(string).append(")").toString();
            string = new StringBuffer().append(string).append(Native.getSignature(clazz2)).toString();
            Class<?>[] classArray2 = method.getExceptionTypes();
            for (int j = 0; j < classArray2.length; ++j) {
                if (!(class$com$sun$jna$LastErrorException == null ? Native.class$("com.sun.jna.LastErrorException") : class$com$sun$jna$LastErrorException).isAssignableFrom(classArray2[j])) continue;
                bl = true;
                break;
            }
            object = method.getName();
            FunctionMapper functionMapper = (FunctionMapper)nativeLibrary.getOptions().get("function-mapper");
            if (functionMapper != null) {
                object = functionMapper.getFunctionName(nativeLibrary, method);
            }
            Function function = nativeLibrary.getFunction((String)object, method);
            try {
                lArray[i] = Native.registerMethod(clazz, method.getName(), string, nArray, lArray3, lArray2, n, l2, l, clazz2, function.peer, function.getCallingConvention(), bl, toNativeConverterArray, fromNativeConverter);
                continue;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new UnsatisfiedLinkError(new StringBuffer().append("No method ").append(method.getName()).append(" with signature ").append(string).append(" in ").append(clazz).toString());
            }
        }
        Map map = registeredClasses;
        synchronized (map) {
            registeredClasses.put(clazz, lArray);
            registeredLibraries.put(clazz, nativeLibrary);
        }
        Native.cacheOptions(clazz, nativeLibrary.getOptions(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheOptions(Class cls, Map libOptions, Object proxy) {
        Map map = libraries;
        synchronized (map) {
            if (!libOptions.isEmpty()) {
                options.put(cls, libOptions);
            }
            if (libOptions.containsKey("type-mapper")) {
                typeMappers.put(cls, libOptions.get("type-mapper"));
            }
            if (libOptions.containsKey("structure-alignment")) {
                alignments.put(cls, libOptions.get("structure-alignment"));
            }
            if (proxy != null) {
                libraries.put(cls, new WeakReference<Object>(proxy));
            }
            if (!cls.isInterface() && (class$com$sun$jna$Library == null ? (class$com$sun$jna$Library = Native.class$("com.sun.jna.Library")) : class$com$sun$jna$Library).isAssignableFrom(cls)) {
                Class<?>[] ifaces = cls.getInterfaces();
                for (int i = 0; i < ifaces.length; ++i) {
                    if (!(class$com$sun$jna$Library == null ? Native.class$("com.sun.jna.Library") : class$com$sun$jna$Library).isAssignableFrom(ifaces[i])) continue;
                    Native.cacheOptions(ifaces[i], libOptions, proxy);
                    break;
                }
            }
        }
    }

    private static native long registerMethod(Class var0, String var1, String var2, int[] var3, long[] var4, long[] var5, int var6, long var7, long var9, Class var11, long var12, int var14, boolean var15, ToNativeConverter[] var16, FromNativeConverter var17);

    private static NativeMapped fromNative(Class cls, Object value) {
        return (NativeMapped)NativeMappedConverter.getInstance(cls).fromNative(value, new FromNativeContext(cls));
    }

    private static Class nativeType(Class cls) {
        return NativeMappedConverter.getInstance(cls).nativeType();
    }

    private static Object toNative(ToNativeConverter cvt, Object o) {
        return cvt.toNative(o, new ToNativeContext());
    }

    private static Object fromNative(FromNativeConverter cvt, Object o, Class cls) {
        return cvt.fromNative(o, new FromNativeContext(cls));
    }

    public static native long ffi_prep_cif(int var0, int var1, long var2, long var4);

    public static native void ffi_call(long var0, long var2, long var4, long var6);

    public static native long ffi_prep_closure(long var0, ffi_callback var2);

    public static native void ffi_free_closure(long var0);

    static native int initialize_ffi_type(long var0);

    public static void main(String[] stringArray) {
        String string;
        String string2 = "Java Native Access (JNA)";
        String string3 = "unknown - package information missing";
        Package package_ = (class$com$sun$jna$Native == null ? (class$com$sun$jna$Native = Native.class$("com.sun.jna.Native")) : class$com$sun$jna$Native).getPackage();
        String string4 = package_.getSpecificationTitle();
        if (string4 == null) {
            string4 = "Java Native Access (JNA)";
        }
        if ((string = package_.getSpecificationVersion()) == null) {
            string = "unknown - package information missing";
        }
        string4 = new StringBuffer().append(string4).append(" API Version ").append(string).toString();
        System.out.println(string4);
        string = package_.getImplementationVersion();
        if (string == null) {
            string = "unknown - package information missing";
        }
        System.out.println(new StringBuffer().append("Version: ").append(string).toString());
        System.out.println(new StringBuffer().append(" Native: ").append(Native.getNativeVersion()).append(" (").append(Native.getAPIChecksum()).append(")").toString());
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        typeMappers = new WeakHashMap();
        alignments = new WeakHashMap();
        options = new WeakHashMap();
        libraries = new WeakHashMap();
        callbackExceptionHandler = DEFAULT_HANDLER = new Callback.UncaughtExceptionHandler(){

            public void uncaughtException(Callback c, Throwable e) {
                System.err.println(new StringBuffer().append("JNA: Callback ").append(c).append(" threw the following exception:").toString());
                e.printStackTrace();
            }
        };
        Native.loadNativeLibrary();
        POINTER_SIZE = Native.sizeof(0);
        LONG_SIZE = Native.sizeof(1);
        WCHAR_SIZE = Native.sizeof(2);
        SIZE_T_SIZE = Native.sizeof(3);
        Native.initIDs();
        if (Boolean.getBoolean("jna.protected")) {
            Native.setProtected(true);
        }
        finalizer = new Object(){

            protected void finalize() {
                Native.deleteNativeLibrary();
            }
        };
        lastError = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Integer(0);
            }
        };
        registeredClasses = new HashMap();
        registeredLibraries = new HashMap();
        unloader = new Object(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() {
                Map map = registeredClasses;
                synchronized (map) {
                    Iterator i = registeredClasses.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry e = i.next();
                        Native.unregister((Class)e.getKey(), (long[])e.getValue());
                        i.remove();
                    }
                }
            }
        };
    }

    public static interface ffi_callback {
        public void invoke(long var1, long var3, long var5);
    }

    public static class DeleteNativeLibrary
    extends Thread {
        private final File file;

        public DeleteNativeLibrary(File file) {
            this.file = file;
        }

        public void run() {
            if (!Native.deleteNativeLibrary()) {
                try {
                    Runtime.getRuntime().exec(new String[]{new StringBuffer().append(System.getProperty("java.home")).append("/bin/java").toString(), "-cp", System.getProperty("java.class.path"), this.getClass().getName(), this.file.getAbsolutePath()});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public static void main(String[] args) {
            File file;
            if (args.length == 1 && (file = new File(args[0])).exists()) {
                long start = System.currentTimeMillis();
                while (!file.delete() && file.exists()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - start <= 5000L) continue;
                    System.err.println(new StringBuffer().append("Could not remove temp file: ").append(file.getAbsolutePath()).toString());
                    break;
                }
            }
            System.exit(0);
        }
    }
}

