/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.C018FE95;
import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSNameSpi;
import com.sun.gssapi.MechInfo;
import com.sun.gssapi.MechTable;
import com.sun.gssapi.Oid;
import java.security.Provider;
import java.security.Security;
import java.util.ResourceBundle;

public class GSSManager {
    private static MechInfo m_defaultMech;

    static {
        GSSManager.initialize();
    }

    static C018FE95 _M4092FBA(Oid oid) throws GSSException {
        MechInfo mechInfo = GSSManager.getMechInfo(oid, true);
        return mechInfo._M4092FBA();
    }

    public static Oid getDefaultMech() throws GSSException {
        if (m_defaultMech != null) {
            return m_defaultMech.getOid();
        }
        Provider[] providerArray = Security.getProviders();
        int n = 0;
        while (n < providerArray.length) {
            String[] stringArray = MechInfo.getMechsForProvider(providerArray[n]);
            if (stringArray != null) {
                m_defaultMech = new MechInfo(providerArray[n], stringArray[0]);
                return m_defaultMech.getOid();
            }
            ++n;
        }
        throw new GSSException(2);
    }

    private static synchronized MechInfo getMechInfo(Oid oid, boolean bl) throws GSSException {
        MechInfo mechInfo = MechTable.getMechInfo(oid);
        if (mechInfo != null) {
            if (bl) {
                MechTable.putMechInfo(mechInfo);
            }
            return mechInfo;
        }
        Provider[] providerArray = Security.getProviders();
        String string = oid.toString();
        int n = 0;
        while (n < providerArray.length) {
            if (MechInfo.implementsMech(providerArray[n], string)) {
                try {
                    mechInfo = new MechInfo(providerArray[n], string);
                    if (bl) {
                        MechTable.putMechInfo(mechInfo);
                    }
                    return mechInfo;
                }
                catch (GSSException gSSException) {}
            }
            ++n;
        }
        throw new GSSException(2);
    }

    static GSSNameSpi getNameInstance(Oid oid) throws GSSException {
        MechInfo mechInfo = GSSManager.getMechInfo(oid, true);
        return mechInfo.getNameInstance();
    }

    private static void initialize() {
        int n = 1;
        try {
            String string;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sun.gssapi.mechs");
            while ((string = resourceBundle.getString(new StringBuffer("gss.provider.").append(n++).toString())) != null) {
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                if (!(obj instanceof Provider)) continue;
                Security.addProvider((Provider)obj);
            }
        }
        catch (Exception exception) {}
    }
}

