/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.C018FE95;
import com.sun.gssapi.ChannelBinding;
import com.sun.gssapi.GSSCredSpi;
import com.sun.gssapi.GSSCredential;
import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSManager;
import com.sun.gssapi.GSSName;
import com.sun.gssapi.MessageProp;
import com.sun.gssapi.Oid;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class GSSContext {
    private C018FE95 m_mechCtxt;
    private int m_reqFlags;
    private GSSCredential m_myCred;
    private int m_reqLifetime;
    private int m_curState;
    private Oid m_mechOid;
    private GSSName m_targName;
    private ChannelBinding m_chB;

    public GSSContext(GSSName gSSName, Oid oid, GSSCredential gSSCredential, int n) throws GSSException {
        this.initialize();
        this.m_myCred = gSSCredential;
        this.m_reqLifetime = n;
        this.m_targName = gSSName;
        this.m_mechOid = oid == null ? GSSManager.getDefaultMech() : oid;
    }

    private void checkState(int n) throws GSSException {
        if (this.m_curState < n) {
            throw new GSSException(12);
        }
        if (n > 1 && this.m_mechCtxt == null) {
            throw new GSSException(12, -1, "error in checkState");
        }
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        messageProp.resetStatusValues();
        this.checkState(3);
        this.m_mechCtxt._S1513DBA(inputStream, outputStream, messageProp);
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.getMIC(byteArrayInputStream, byteArrayOutputStream, messageProp);
        return byteArrayOutputStream.toByteArray();
    }

    public int init(InputStream inputStream, OutputStream outputStream) throws GSSException {
        if (this.m_mechCtxt == null) {
            this.m_mechCtxt = GSSManager._M4092FBA(this.m_mechOid);
            GSSCredSpi gSSCredSpi = null;
            if (this.m_myCred != null) {
                gSSCredSpi = this.m_myCred.getMechCred(this.m_mechOid, true);
            }
            this.m_mechCtxt._S235D9C1(gSSCredSpi, this.m_targName.canonicalizeInPlace(this.m_mechOid), this.m_reqLifetime, this.m_reqFlags);
            if (this.m_chB != null) {
                this.m_mechCtxt._S9B00AB2(this.m_chB);
            }
            this.m_curState = 2;
        }
        if (this.m_curState != 2) {
            throw new GSSException(11, -1, "wrong status in init");
        }
        int n = this.m_mechCtxt._S0E039DB(inputStream, outputStream);
        if (n == 0) {
            this.m_curState = 3;
        }
        return n;
    }

    public byte[] init(byte[] byArray, int n, int n2) throws GSSException {
        ByteArrayInputStream byteArrayInputStream = null;
        if (byArray != null) {
            byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.init(byteArrayInputStream, byteArrayOutputStream);
        if (byteArrayOutputStream.size() == 0) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void initialize() {
        this.m_reqFlags = 14;
        this.m_myCred = null;
        this.m_reqLifetime = Integer.MAX_VALUE;
        this.m_curState = 1;
        this.m_mechOid = null;
        this.m_targName = null;
        this.m_chB = null;
    }

    public boolean isEstablished() {
        return this.m_curState == 3;
    }

    public void requestConf(boolean bl) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = bl ? (this.m_reqFlags |= 0x20) : (this.m_reqFlags ^= 0x20);
    }

    public void requestInteg(boolean bl) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = bl ? (this.m_reqFlags |= 0x40) : (this.m_reqFlags ^= 0x40);
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = bl ? (this.m_reqFlags |= 2) : (this.m_reqFlags ^= 2);
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = bl ? (this.m_reqFlags |= 4) : (this.m_reqFlags ^= 4);
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = bl ? (this.m_reqFlags |= 8) : (this.m_reqFlags ^= 8);
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        throw new GSSException(11);
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        messageProp.resetStatusValues();
        this.checkState(3);
        this.m_mechCtxt._S00256CF(inputStream, inputStream2, messageProp);
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray2, n3, n4);
        this.verifyMIC(byteArrayInputStream, byteArrayInputStream2, messageProp);
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        throw new GSSException(11);
    }
}

