/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.dsa;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.dsa.SshDssPublicKey;
import com.sshtools.j2ssh.util.SimpleASNReader;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class SshDssPrivateKey
extends SshPrivateKey {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPrivateKey == null ? (class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPrivateKey = SshDssPrivateKey.class$("com.sshtools.j2ssh.transport.publickey.dsa.SshDssPrivateKey")) : class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPrivateKey);
    DSAPrivateKey prvkey;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPrivateKey;

    public SshDssPrivateKey(byte[] byArray) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                throw new InvalidSshKeyException();
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            BigInteger bigInteger4 = byteArrayReader.readBigInteger();
            DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            this.prvkey = (DSAPrivateKey)keyFactory.generatePrivate(dSAPrivateKeySpec);
        }
        catch (Exception exception) {
            throw new InvalidSshKeyException();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SshDssPrivateKey) {
            return this.prvkey.equals(((SshDssPrivateKey)object).prvkey);
        }
        return false;
    }

    public int hashCode() {
        return this.prvkey.hashCode();
    }

    public String getAlgorithmName() {
        return "ssh-dss";
    }

    public SshPublicKey getPublicKey() {
        try {
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(this.getY(), this.prvkey.getParams().getP(), this.prvkey.getParams().getQ(), this.prvkey.getParams().getG());
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return new SshDssPublicKey((DSAPublicKey)keyFactory.generatePublic(dSAPublicKeySpec));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] generateSignature(byte[] byArray) throws InvalidSshKeySignatureException {
        try {
            Object object;
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initSign(this.prvkey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            byte[] byArray3 = new byte[40];
            SimpleASNReader simpleASNReader = new SimpleASNReader(byArray2);
            simpleASNReader.getByte();
            simpleASNReader.getLength();
            simpleASNReader.getByte();
            byte[] byArray4 = simpleASNReader.getData();
            simpleASNReader.getByte();
            byte[] byArray5 = simpleASNReader.getData();
            if (byArray4.length >= 20) {
                System.arraycopy(byArray4, byArray4.length - 20, byArray3, 0, 20);
            } else {
                System.arraycopy(byArray4, 0, byArray3, 20 - byArray4.length, byArray4.length);
            }
            if (byArray5.length >= 20) {
                System.arraycopy(byArray5, byArray5.length - 20, byArray3, 20, 20);
            } else {
                System.arraycopy(byArray5, 0, byArray3, 20 + (20 - byArray5.length), byArray5.length);
            }
            if (log.isDebugEnabled()) {
                int n;
                log.debug(new StringBuffer().append("s length is ").append(String.valueOf(byArray5.length)).toString());
                log.debug(new StringBuffer().append("r length is ").append(String.valueOf(byArray4.length)).toString());
                object = "";
                for (n = 0; n < byArray2.length; ++n) {
                    object = new StringBuffer().append((String)object).append(Integer.toHexString(byArray2[n] & 0xFF)).append(" ").toString();
                }
                log.debug(new StringBuffer().append("Java signature is ").append((String)object).toString());
                object = "";
                for (n = 0; n < byArray3.length; ++n) {
                    object = new StringBuffer().append((String)object).append(Integer.toHexString(byArray3[n] & 0xFF)).append(" ").toString();
                }
                log.debug(new StringBuffer().append("SSH signature is ").append((String)object).toString());
            }
            object = new ByteArrayWriter();
            ((ByteArrayWriter)object).writeString(this.getAlgorithmName());
            ((ByteArrayWriter)object).writeBinaryString(byArray3);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (Exception exception) {
            throw new InvalidSshKeySignatureException(exception);
        }
    }

    private BigInteger getY() {
        return this.prvkey.getParams().getG().modPow(this.prvkey.getX(), this.prvkey.getParams().getP());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

