/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;
import com.sshtools.j2ssh.transport.compression.SshCompressionFactory;
import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;
import com.sshtools.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;

public class SshMsgKexInit
extends SshMessage {
    private List supportedCompCS;
    private List supportedCompSC;
    private List supportedEncryptCS;
    private List supportedEncryptSC;
    private List supportedKex;
    private List supportedLangCS;
    private List supportedLangSC;
    private List supportedMacCS;
    private List supportedMacSC;
    private List supportedPK;
    private byte[] cookie;
    private boolean firstKexFollows;

    public SshMsgKexInit() {
        super(20);
    }

    public SshMsgKexInit(SshConnectionProperties sshConnectionProperties) {
        super(20);
        this.cookie = new byte[16];
        SecureRandom secureRandom = ConfigurationLoader.getRND();
        ((Random)secureRandom).nextBytes(this.cookie);
        this.supportedKex = this.sortAlgorithmList(SshKeyExchangeFactory.getSupportedKeyExchanges(), sshConnectionProperties.getPrefKex());
        this.supportedPK = this.sortAlgorithmList(SshKeyPairFactory.getSupportedKeys(), sshConnectionProperties.getPrefPublicKey());
        this.supportedEncryptCS = this.sortAlgorithmList(SshCipherFactory.getSupportedCiphers(), sshConnectionProperties.getPrefCSEncryption());
        this.supportedEncryptSC = this.sortAlgorithmList(SshCipherFactory.getSupportedCiphers(), sshConnectionProperties.getPrefSCEncryption());
        this.supportedMacCS = this.sortAlgorithmList(SshHmacFactory.getSupportedMacs(), sshConnectionProperties.getPrefCSMac());
        this.supportedMacSC = this.sortAlgorithmList(SshHmacFactory.getSupportedMacs(), sshConnectionProperties.getPrefSCMac());
        this.supportedCompCS = this.sortAlgorithmList(SshCompressionFactory.getSupportedCompression(), sshConnectionProperties.getPrefCSComp());
        this.supportedCompSC = this.sortAlgorithmList(SshCompressionFactory.getSupportedCompression(), sshConnectionProperties.getPrefSCComp());
        this.supportedLangCS = new ArrayList();
        this.supportedLangSC = new ArrayList();
        this.firstKexFollows = false;
    }

    public String getMessageName() {
        return "SSH_MSG_KEX_INIT";
    }

    public List getSupportedCSEncryption() {
        return this.supportedEncryptCS;
    }

    public List getSupportedCSMac() {
        return this.supportedMacCS;
    }

    public List getSupportedKex() {
        return this.supportedKex;
    }

    public List getSupportedPublicKeys() {
        return this.supportedPK;
    }

    public List getSupportedSCEncryption() {
        return this.supportedEncryptSC;
    }

    public List getSupportedSCMac() {
        return this.supportedMacSC;
    }

    public String createDelimString(List list) {
        String string = "";
        String string2 = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            string2 = new StringBuffer().append(string2).append(string).append((String)iterator.next()).toString();
            string = ",";
        }
        return string2;
    }

    public String toString() {
        String string = "SshMsgKexInit:\n";
        string = new StringBuffer().append(string).append("Supported Kex ").append(this.supportedKex.toString()).append("\n").toString();
        string = new StringBuffer().append(string).append("Supported Public Keys ").append(this.supportedPK.toString()).append("\n").toString();
        string = new StringBuffer().append(string).append("Supported Encryption Client->Server ").append(this.supportedEncryptCS.toString()).append("\n").toString();
        string = new StringBuffer().append(string).append("Supported Encryption Server->Client ").append(this.supportedEncryptSC.toString()).append("\n").toString();
        string = new StringBuffer().append(string).append("Supported Mac Client->Server ").append(this.supportedMacCS.toString()).append("\n").toString();
        string = new StringBuffer().append(string).append("Supported Mac Server->Client ").append(this.supportedMacSC.toString()).append("\n").toString();
        string = new StringBuffer().append(string).append("Supported Compression Client->Server ").append(this.supportedCompCS.toString()).append("\n").toString();
        string = new StringBuffer().append(string).append("Supported Compression Server->Client ").append(this.supportedCompSC.toString()).append("\n").toString();
        string = new StringBuffer().append(string).append("Supported Languages Client->Server ").append(this.supportedLangCS.toString()).append("\n").toString();
        string = new StringBuffer().append(string).append("Supported Languages Server->Client ").append(this.supportedLangSC.toString()).append("\n").toString();
        string = new StringBuffer().append(string).append("First Kex Packet Follows [").append(this.firstKexFollows ? "TRUE]" : "FALSE]").toString();
        return string;
    }

    protected void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException {
        try {
            byteArrayWriter.write(this.cookie);
            byteArrayWriter.writeString(this.createDelimString(this.supportedKex));
            byteArrayWriter.writeString(this.createDelimString(this.supportedPK));
            byteArrayWriter.writeString(this.createDelimString(this.supportedEncryptCS));
            byteArrayWriter.writeString(this.createDelimString(this.supportedEncryptSC));
            byteArrayWriter.writeString(this.createDelimString(this.supportedMacCS));
            byteArrayWriter.writeString(this.createDelimString(this.supportedMacSC));
            byteArrayWriter.writeString(this.createDelimString(this.supportedCompCS));
            byteArrayWriter.writeString(this.createDelimString(this.supportedCompSC));
            byteArrayWriter.writeString(this.createDelimString(this.supportedLangCS));
            byteArrayWriter.writeString(this.createDelimString(this.supportedLangSC));
            byteArrayWriter.write(this.firstKexFollows ? 1 : 0);
            byteArrayWriter.writeInt(0);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException(new StringBuffer().append("Error writing message data: ").append(iOException.getMessage()).toString());
        }
    }

    protected void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        try {
            this.cookie = new byte[16];
            byteArrayReader.read(this.cookie);
            this.supportedKex = this.loadListFromString(byteArrayReader.readString());
            this.supportedPK = this.loadListFromString(byteArrayReader.readString());
            this.supportedEncryptCS = this.loadListFromString(byteArrayReader.readString());
            this.supportedEncryptSC = this.loadListFromString(byteArrayReader.readString());
            this.supportedMacCS = this.loadListFromString(byteArrayReader.readString());
            this.supportedMacSC = this.loadListFromString(byteArrayReader.readString());
            this.supportedCompCS = this.loadListFromString(byteArrayReader.readString());
            this.supportedCompSC = this.loadListFromString(byteArrayReader.readString());
            this.supportedLangCS = this.loadListFromString(byteArrayReader.readString());
            this.supportedLangSC = this.loadListFromString(byteArrayReader.readString());
            this.firstKexFollows = byteArrayReader.read() != 0;
        }
        catch (IOException iOException) {
            throw new InvalidMessageException(new StringBuffer().append("Error reading message data: ").append(iOException.getMessage()).toString());
        }
    }

    private List loadListFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(stringTokenizer.nextElement());
        }
        return arrayList;
    }

    private List sortAlgorithmList(List list, String string) {
        if (list.contains(string)) {
            list.remove(string);
            list.add(0, string);
        }
        return list;
    }
}

