/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;

public abstract class SshMessage {
    private int messageId;

    public SshMessage(int n) {
        this.messageId = n;
    }

    public final int getMessageId() {
        return this.messageId;
    }

    public abstract String getMessageName();

    public final byte[] toByteArray() throws InvalidMessageException {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.write(this.messageId);
        this.constructByteArray(byteArrayWriter);
        return byteArrayWriter.toByteArray();
    }

    protected final void fromByteArray(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        byteArrayReader.skip(5L);
        int n = byteArrayReader.read();
        if (n != this.messageId) {
            throw new InvalidMessageException(new StringBuffer().append("The message id ").append(String.valueOf(n)).append(" is not the same as the message implementation id ").append(String.valueOf(this.messageId)).toString());
        }
        this.constructMessage(byteArrayReader);
    }

    public static Integer getMessageId(byte[] byArray) {
        return new Integer(byArray[5]);
    }

    protected abstract void constructByteArray(ByteArrayWriter var1) throws InvalidMessageException;

    protected abstract void constructMessage(ByteArrayReader var1) throws InvalidMessageException;
}

