/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import java.io.IOException;

public class SftpFile
implements Comparable {
    private String filename;
    private byte[] handle;
    private FileAttributes attrs;
    private SftpSubsystemClient sftp;
    private String absolutePath;

    public SftpFile(String string, FileAttributes fileAttributes) {
        this.absolutePath = string;
        int n = string.lastIndexOf("/");
        this.filename = n > -1 ? string.substring(n + 1) : string;
        this.attrs = fileAttributes;
    }

    protected void setHandle(byte[] byArray) {
        this.handle = byArray;
    }

    protected byte[] getHandle() {
        return this.handle;
    }

    protected void setSFTPSubsystem(SftpSubsystemClient sftpSubsystemClient) {
        this.sftp = sftpSubsystemClient;
    }

    protected SftpSubsystemClient getSFTPSubsystem() {
        return this.sftp;
    }

    public String getFilename() {
        return this.filename;
    }

    private String pad(int n) {
        String string = "";
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                string = new StringBuffer().append(string).append(" ").toString();
            }
        }
        return string;
    }

    public String getLongname() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new StringBuffer().append(this.pad(10 - this.getAttributes().getPermissionsString().length())).append(this.getAttributes().getPermissionsString()).toString());
        stringBuffer.append("   1 ");
        stringBuffer.append(new StringBuffer().append(this.getAttributes().getUID().toString()).append(this.pad(8 - this.getAttributes().getUID().toString().length())).toString());
        stringBuffer.append(" ");
        stringBuffer.append(new StringBuffer().append(this.getAttributes().getGID().toString()).append(this.pad(8 - this.getAttributes().getGID().toString().length())).toString());
        stringBuffer.append(" ");
        stringBuffer.append(new StringBuffer().append(this.pad(8 - this.getAttributes().getSize().toString().length())).append(this.getAttributes().getSize().toString()).toString());
        stringBuffer.append(" ");
        stringBuffer.append(new StringBuffer().append(this.pad(12 - this.getAttributes().getModTimeString().length())).append(this.getAttributes().getModTimeString()).toString());
        stringBuffer.append(" ");
        stringBuffer.append(this.filename);
        return stringBuffer.toString();
    }

    public FileAttributes getAttributes() {
        try {
            if (this.attrs == null) {
                this.attrs = this.sftp.getAttributes(this);
            }
        }
        catch (IOException iOException) {
            this.attrs = new FileAttributes();
        }
        return this.attrs;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void close() throws IOException {
        this.sftp.closeFile(this);
    }

    public boolean isDirectory() {
        return this.getAttributes().isDirectory();
    }

    public int compareTo(Object object) {
        return this.getFilename().compareTo(((SftpFile)object).getFilename());
    }
}

