/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.openssh;

import com.sshtools.j2ssh.openssh.PEM;
import com.sshtools.j2ssh.util.Base64;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class PEMReader
extends PEM {
    private LineNumberReader reader;
    private String type;
    private Map header;
    private byte[] payload;

    public PEMReader(Reader reader) throws IOException {
        this.reader = new LineNumberReader(reader);
        this.read();
    }

    private void read() throws IOException {
        int n;
        String string;
        while ((string = this.reader.readLine()) != null) {
            if (!string.startsWith("-----") || !string.endsWith("-----")) continue;
            if (string.startsWith("-----BEGIN ")) {
                this.type = string.substring("-----BEGIN ".length(), string.length() - "-----".length());
                break;
            }
            throw new IOException(new StringBuffer().append("Invalid PEM boundary at line ").append(this.reader.getLineNumber()).append(": ").append(string).toString());
        }
        this.header = new HashMap();
        block1: while ((string = this.reader.readLine()) != null && (n = string.indexOf(58)) != -1) {
            String string2;
            String string3 = string.substring(0, n).trim();
            if (string.endsWith("\\")) {
                string2 = string.substring(n + 1, string.length() - 1).trim();
                StringBuffer stringBuffer = new StringBuffer(string2);
                while ((string = this.reader.readLine()) != null) {
                    if (string.endsWith("\\")) {
                        stringBuffer.append(" ").append(string.substring(0, string.length() - 1).trim());
                        continue;
                    }
                    stringBuffer.append(" ").append(string.trim());
                    continue block1;
                }
                continue;
            }
            string2 = string.substring(n + 1).trim();
            this.header.put(string3, string2);
        }
        if (string == null) {
            throw new IOException("The key format is invalid! OpenSSH formatted keys must begin with -----BEGIN RSA or -----BEGIN DSA");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while ((string = this.reader.readLine()) != null) {
            if (string.startsWith("-----") && string.endsWith("-----")) {
                if (string.startsWith(new StringBuffer().append("-----END ").append(this.type).toString())) break;
                throw new IOException(new StringBuffer().append("Invalid PEM end boundary at line ").append(this.reader.getLineNumber()).append(": ").append(string).toString());
            }
            stringBuffer.append(string);
        }
        this.payload = Base64.decode(stringBuffer.toString());
    }

    public String getType() {
        return this.type;
    }

    public byte[] decryptPayload(String string) throws GeneralSecurityException {
        String string2 = (String)this.header.get("DEK-Info");
        if (string2 != null) {
            int n = string2.indexOf(44);
            String string3 = string2.substring(0, n);
            if (!"DES-EDE3-CBC".equals(string3)) {
                throw new NoSuchAlgorithmException(new StringBuffer().append("Unsupported passphrase algorithm: ").append(string3).toString());
            }
            String string4 = string2.substring(n + 1);
            byte[] byArray = new byte[string4.length() / 2];
            for (int i = 0; i < string4.length(); i += 2) {
                byArray[i / 2] = (byte)Integer.parseInt(string4.substring(i, i + 2), 16);
            }
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            SecretKey secretKey = PEMReader.getKeyFromPassphrase(string, byArray, 24);
            cipher.init(2, (Key)secretKey, new IvParameterSpec(byArray));
            byte[] byArray2 = new byte[this.payload.length];
            cipher.update(this.payload, 0, this.payload.length, byArray2, 0);
            return byArray2;
        }
        return this.payload;
    }
}

