/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.openssh;

import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.openssh.DSAKeyInfo;
import com.sshtools.j2ssh.openssh.PEMReader;
import com.sshtools.j2ssh.openssh.RSAKeyInfo;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.sshtools.j2ssh.util.SimpleASNReader;
import java.io.IOException;
import java.io.StringReader;
import java.security.GeneralSecurityException;

public class OpenSSHPrivateKeyFormat
implements SshPrivateKeyFormat {
    public String getFormatType() {
        return "OpenSSH-PrivateKey";
    }

    public String toString() {
        return this.getFormatType();
    }

    public byte[] decryptKeyblob(byte[] byArray, String string) throws InvalidSshKeyException {
        try {
            StringReader stringReader = new StringReader(new String(byArray, "US-ASCII"));
            PEMReader pEMReader = new PEMReader(stringReader);
            byte[] byArray2 = pEMReader.decryptPayload(string);
            SimpleASNReader simpleASNReader = new SimpleASNReader(byArray2);
            if ("DSA PRIVATE KEY".equals(pEMReader.getType())) {
                DSAKeyInfo dSAKeyInfo = DSAKeyInfo.getDSAKeyInfo(simpleASNReader);
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.writeString("ssh-dss");
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getP());
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getQ());
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getG());
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getX());
                return byteArrayWriter.toByteArray();
            }
            if ("RSA PRIVATE KEY".equals(pEMReader.getType())) {
                RSAKeyInfo rSAKeyInfo = RSAKeyInfo.getRSAKeyInfo(simpleASNReader);
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.writeString("ssh-rsa");
                byteArrayWriter.writeBigInteger(rSAKeyInfo.getPublicExponent());
                byteArrayWriter.writeBigInteger(rSAKeyInfo.getModulus());
                byteArrayWriter.writeBigInteger(rSAKeyInfo.getPrivateExponent());
                return byteArrayWriter.toByteArray();
            }
            throw new InvalidSshKeyException(new StringBuffer().append("Unsupported type: ").append(pEMReader.getType()).toString());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidSshKeyException(new StringBuffer().append("Can't read key due to cryptography problems: ").append(generalSecurityException).toString());
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(new StringBuffer().append("Can't read key due to internal IO problems: ").append(iOException).toString());
        }
    }

    public boolean isFormatted(byte[] byArray) {
        try {
            StringReader stringReader = new StringReader(new String(byArray, "US-ASCII"));
            PEMReader pEMReader = new PEMReader(stringReader);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

