/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationListener;
import com.sshtools.j2ssh.forwarding.ForwardingSocketChannel;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForwardingConfiguration {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$forwarding$ForwardingConfiguration == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingConfiguration = ForwardingConfiguration.class$("com.sshtools.j2ssh.forwarding.ForwardingConfiguration")) : class$com$sshtools$j2ssh$forwarding$ForwardingConfiguration);
    protected StartStopState state = new StartStopState(2);
    protected String addressToBind;
    protected String hostToConnect;
    protected String name;
    protected int portToBind;
    protected int portToConnect;
    protected ForwardingConfigurationMonitor monitor = new ForwardingConfigurationMonitor();
    protected EventListenerList listenerList = new EventListenerList();
    private List activeForwardings = new Vector();
    static /* synthetic */ Class class$com$sshtools$j2ssh$forwarding$ForwardingConfiguration;
    static /* synthetic */ Class class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener;

    public ForwardingConfiguration(String string, String string2, int n, String string3, int n2) {
        this.addressToBind = string2;
        this.portToBind = n;
        this.name = string;
        this.hostToConnect = string3;
        this.portToConnect = n2;
    }

    public String getAddressToBind() {
        return this.addressToBind;
    }

    public String getHostToConnect() {
        return this.hostToConnect;
    }

    public String getName() {
        return this.name;
    }

    public int getPortToBind() {
        return this.portToBind;
    }

    public int getPortToConnect() {
        return this.portToConnect;
    }

    public StartStopState getState() {
        return this.state;
    }

    public void start() throws IOException {
        this.state.setValue(1);
    }

    public void stop() {
        this.state.setValue(2);
    }

    public ForwardingSocketChannel createForwardingSocketChannel(String string, String string2, int n, String string3, int n2) throws ForwardingConfigurationException {
        if (this.state.getValue() == 2) {
            throw new ForwardingConfigurationException("The forwarding has been stopped");
        }
        if (!(string.equals("direct-tcpip") || string.equals("forwarded-tcpip") || string.equals("x11"))) {
            throw new ForwardingConfigurationException("The channel type must either be ForwardingSocketChannel.LOCAL_FORWARDING_CHANNEL_TYPE or ForwardingSocketChannel.REMOTE_FORWARDING_CHANNEL_TYPE");
        }
        ForwardingSocketChannel forwardingSocketChannel = string.equals("direct-tcpip") ? new ForwardingSocketChannel(string, this.name, string2, n, string3, n2) : new ForwardingSocketChannel(string, this.name, this.getAddressToBind(), this.getPortToBind(), string3, n2);
        forwardingSocketChannel.addEventListener(this.monitor);
        return forwardingSocketChannel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public class ForwardingConfigurationMonitor
    implements ChannelEventListener {
        public void onChannelOpen(Channel channel) {
            ForwardingConfigurationListener[] forwardingConfigurationListenerArray;
            if (log.isDebugEnabled()) {
                forwardingConfigurationListenerArray = (ForwardingConfigurationListener[])channel;
                log.debug(new StringBuffer().append("Opening forwarding channel from ").append(forwardingConfigurationListenerArray.getOriginatingHost()).append(":").append(String.valueOf(forwardingConfigurationListenerArray.getOriginatingPort())).toString());
            }
            ForwardingConfiguration.this.activeForwardings.add(channel);
            forwardingConfigurationListenerArray = (ForwardingConfigurationListener[])ForwardingConfiguration.this.listenerList.getListeners(class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener = ForwardingConfiguration.class$("com.sshtools.j2ssh.forwarding.ForwardingConfigurationListener")) : class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener);
            for (int i = forwardingConfigurationListenerArray.length - 1; i >= 0; --i) {
                forwardingConfigurationListenerArray[i].opened(ForwardingConfiguration.this, (ForwardingSocketChannel)channel);
            }
        }

        public void onChannelEOF(Channel channel) {
        }

        public void onChannelClose(Channel channel) {
            ForwardingConfigurationListener[] forwardingConfigurationListenerArray;
            if (log.isDebugEnabled()) {
                forwardingConfigurationListenerArray = (ForwardingConfigurationListener[])channel;
                log.debug(new StringBuffer().append("Closing forwarding channel from ").append(forwardingConfigurationListenerArray.getOriginatingHost()).append(":").append(String.valueOf(forwardingConfigurationListenerArray.getOriginatingPort())).toString());
            }
            ForwardingConfiguration.this.activeForwardings.remove(channel);
            forwardingConfigurationListenerArray = (ForwardingConfigurationListener[])ForwardingConfiguration.this.listenerList.getListeners(class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener = ForwardingConfiguration.class$("com.sshtools.j2ssh.forwarding.ForwardingConfigurationListener")) : class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener);
            for (int i = forwardingConfigurationListenerArray.length - 1; i >= 0; --i) {
                forwardingConfigurationListenerArray[i].closed(ForwardingConfiguration.this, (ForwardingSocketChannel)channel);
            }
        }

        public void onDataReceived(Channel channel, byte[] byArray) {
            ForwardingConfigurationListener[] forwardingConfigurationListenerArray = (ForwardingConfigurationListener[])ForwardingConfiguration.this.listenerList.getListeners(class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener = ForwardingConfiguration.class$("com.sshtools.j2ssh.forwarding.ForwardingConfigurationListener")) : class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener);
            for (int i = forwardingConfigurationListenerArray.length - 1; i >= 0; --i) {
                forwardingConfigurationListenerArray[i].dataReceived(ForwardingConfiguration.this, (ForwardingSocketChannel)channel, byArray.length);
            }
        }

        public void onDataSent(Channel channel, byte[] byArray) {
            ForwardingConfigurationListener[] forwardingConfigurationListenerArray = (ForwardingConfigurationListener[])ForwardingConfiguration.this.listenerList.getListeners(class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener = ForwardingConfiguration.class$("com.sshtools.j2ssh.forwarding.ForwardingConfigurationListener")) : class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener);
            for (int i = forwardingConfigurationListenerArray.length - 1; i >= 0; --i) {
                forwardingConfigurationListenerArray[i].dataSent(ForwardingConfiguration.this, (ForwardingSocketChannel)channel, byArray.length);
            }
        }
    }
}

