/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.forwarding.ForwardingListener;
import com.sshtools.j2ssh.forwarding.ForwardingSocketChannel;
import com.sshtools.j2ssh.forwarding.XDisplay;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketPermission;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForwardingClient
implements ChannelFactory {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$forwarding$ForwardingClient == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingClient = ForwardingClient.class$("com.sshtools.j2ssh.forwarding.ForwardingClient")) : class$com$sshtools$j2ssh$forwarding$ForwardingClient);
    private ConnectionProtocol connection;
    private List channelTypes = new Vector();
    private Map localForwardings = new HashMap();
    private Map remoteForwardings = new HashMap();
    private XDisplay xDisplay;
    private ForwardingConfiguration x11ForwardingConfiguration;
    static /* synthetic */ Class class$com$sshtools$j2ssh$forwarding$ForwardingClient;

    public ForwardingClient(ConnectionProtocol connectionProtocol) throws IOException {
        this.connection = connectionProtocol;
        connectionProtocol.addChannelFactory("forwarded-tcpip", this);
        connectionProtocol.addChannelFactory("x11", this);
    }

    public void synchronizeConfiguration(SshConnectionProperties sshConnectionProperties) {
        Iterator iterator;
        ForwardingConfiguration forwardingConfiguration = null;
        if (sshConnectionProperties.getLocalForwardings().size() > 0) {
            iterator = sshConnectionProperties.getLocalForwardings().values().iterator();
            while (iterator.hasNext()) {
                try {
                    forwardingConfiguration = (ForwardingConfiguration)iterator.next();
                    forwardingConfiguration = this.addLocalForwarding(forwardingConfiguration);
                    if (!sshConnectionProperties.getForwardingAutoStartMode()) continue;
                    this.startLocalForwarding(forwardingConfiguration.getName());
                }
                catch (Throwable throwable) {
                    log.warn(new StringBuffer().append("Failed to start local forwarding ").append(forwardingConfiguration).toString() != null ? forwardingConfiguration.getName() : "", throwable);
                }
            }
        }
        if (sshConnectionProperties.getRemoteForwardings().size() > 0) {
            iterator = sshConnectionProperties.getRemoteForwardings().values().iterator();
            while (iterator.hasNext()) {
                try {
                    forwardingConfiguration = (ForwardingConfiguration)iterator.next();
                    this.addRemoteForwarding(forwardingConfiguration);
                    if (!sshConnectionProperties.getForwardingAutoStartMode()) continue;
                    this.startRemoteForwarding(forwardingConfiguration.getName());
                }
                catch (Throwable throwable) {
                    log.warn(new StringBuffer().append("Failed to start remote forwarding ").append(forwardingConfiguration).toString() != null ? forwardingConfiguration.getName() : "", throwable);
                }
            }
        }
    }

    public ForwardingConfiguration getRemoteForwardingByAddress(String string, int n) throws ForwardingConfigurationException {
        for (ForwardingConfiguration forwardingConfiguration : this.remoteForwardings.values()) {
            if (!forwardingConfiguration.getAddressToBind().equals(string) || forwardingConfiguration.getPortToBind() != n) continue;
            return forwardingConfiguration;
        }
        throw new ForwardingConfigurationException("The configuration does not exist");
    }

    public ForwardingConfiguration addLocalForwarding(String string, String string2, int n, String string3, int n2) throws ForwardingConfigurationException {
        if (this.localForwardings.containsKey(string)) {
            throw new ForwardingConfigurationException("The configuration name already exists!");
        }
        for (ForwardingConfiguration forwardingConfiguration : this.localForwardings.values()) {
            if (!forwardingConfiguration.getAddressToBind().equals(string2) || forwardingConfiguration.getPortToBind() != n) continue;
            throw new ForwardingConfigurationException("The address and port are already in use");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new SocketPermission(new StringBuffer().append(string2).append(":").append(String.valueOf(n)).toString(), "accept,listen"));
            }
            catch (SecurityException securityException) {
                throw new ForwardingConfigurationException(new StringBuffer().append("The security manager has denied listen permision on ").append(string2).append(":").append(String.valueOf(n)).toString());
            }
        }
        ClientForwardingListener clientForwardingListener = new ClientForwardingListener(string, this.connection, string2, n, string3, n2);
        this.localForwardings.put(string, clientForwardingListener);
        return clientForwardingListener;
    }

    public ForwardingConfiguration addLocalForwarding(ForwardingConfiguration forwardingConfiguration) throws ForwardingConfigurationException {
        return this.addLocalForwarding(forwardingConfiguration.getName(), forwardingConfiguration.getAddressToBind(), forwardingConfiguration.getPortToBind(), forwardingConfiguration.getHostToConnect(), forwardingConfiguration.getPortToConnect());
    }

    public void addRemoteForwarding(ForwardingConfiguration forwardingConfiguration) throws ForwardingConfigurationException {
        if (this.remoteForwardings.containsKey(forwardingConfiguration.getName())) {
            throw new ForwardingConfigurationException("The remote forwaring configuration name already exists!");
        }
        for (ForwardingConfiguration forwardingConfiguration2 : this.remoteForwardings.values()) {
            if (!forwardingConfiguration2.getAddressToBind().equals(forwardingConfiguration.getAddressToBind()) || forwardingConfiguration2.getPortToBind() != forwardingConfiguration.getPortToBind()) continue;
            throw new ForwardingConfigurationException("The remote forwarding address and port are already in use");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new SocketPermission(new StringBuffer().append(forwardingConfiguration.getHostToConnect()).append(":").append(String.valueOf(forwardingConfiguration.getPortToConnect())).toString(), "connect"));
            }
            catch (SecurityException securityException) {
                throw new ForwardingConfigurationException(new StringBuffer().append("The security manager has denied connect permision on ").append(forwardingConfiguration.getHostToConnect()).append(":").append(String.valueOf(forwardingConfiguration.getPortToConnect())).toString());
            }
        }
        this.remoteForwardings.put(forwardingConfiguration.getName(), forwardingConfiguration);
    }

    public Channel createChannel(String string, byte[] byArray) throws InvalidChannelException {
        if (string.equals("x11")) {
            if (this.xDisplay == null) {
                throw new InvalidChannelException("Local display has not been set for X11 forwarding.");
            }
            try {
                ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
                String string2 = byteArrayReader.readString();
                int n = (int)byteArrayReader.readInt();
                log.debug(new StringBuffer().append("Creating socket to ").append(this.x11ForwardingConfiguration.getHostToConnect()).append("/").append(this.x11ForwardingConfiguration.getPortToConnect()).toString());
                Socket socket = new Socket(this.x11ForwardingConfiguration.getHostToConnect(), this.x11ForwardingConfiguration.getPortToConnect());
                ForwardingSocketChannel forwardingSocketChannel = this.x11ForwardingConfiguration.createForwardingSocketChannel(string, this.x11ForwardingConfiguration.getHostToConnect(), this.x11ForwardingConfiguration.getPortToConnect(), string2, n);
                forwardingSocketChannel.bindSocket(socket);
                forwardingSocketChannel.addEventListener(this.x11ForwardingConfiguration.monitor);
                return forwardingSocketChannel;
            }
            catch (IOException iOException) {
                throw new InvalidChannelException(iOException.getMessage());
            }
        }
        if (string.equals("forwarded-tcpip")) {
            try {
                ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
                String string3 = byteArrayReader.readString();
                int n = (int)byteArrayReader.readInt();
                String string4 = byteArrayReader.readString();
                int n2 = (int)byteArrayReader.readInt();
                ForwardingConfiguration forwardingConfiguration = this.getRemoteForwardingByAddress(string3, n);
                Socket socket = new Socket(forwardingConfiguration.getHostToConnect(), forwardingConfiguration.getPortToConnect());
                ForwardingSocketChannel forwardingSocketChannel = forwardingConfiguration.createForwardingSocketChannel(string, forwardingConfiguration.getHostToConnect(), forwardingConfiguration.getPortToConnect(), string4, n2);
                forwardingSocketChannel.bindSocket(socket);
                forwardingSocketChannel.addEventListener(forwardingConfiguration.monitor);
                return forwardingSocketChannel;
            }
            catch (ForwardingConfigurationException forwardingConfigurationException) {
                throw new InvalidChannelException("No valid forwarding configuration was available for the request address");
            }
            catch (IOException iOException) {
                throw new InvalidChannelException(iOException.getMessage());
            }
        }
        throw new InvalidChannelException("The server can only request a remote forwarding channel or anX11 forwarding channel");
    }

    public void startLocalForwarding(String string) throws ForwardingConfigurationException {
        if (!this.localForwardings.containsKey(string)) {
            throw new ForwardingConfigurationException("The name is not a valid forwarding configuration");
        }
        try {
            ForwardingListener forwardingListener = (ForwardingListener)this.localForwardings.get(string);
            forwardingListener.start();
        }
        catch (IOException iOException) {
            throw new ForwardingConfigurationException(iOException.getMessage());
        }
    }

    public void startRemoteForwarding(String string) throws IOException, ForwardingConfigurationException {
        if (!this.remoteForwardings.containsKey(string)) {
            throw new ForwardingConfigurationException("The name is not a valid forwarding configuration");
        }
        ForwardingConfiguration forwardingConfiguration = (ForwardingConfiguration)this.remoteForwardings.get(string);
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(forwardingConfiguration.getAddressToBind());
        byteArrayWriter.writeInt(forwardingConfiguration.getPortToBind());
        this.connection.sendGlobalRequest("tcpip-forward", true, byteArrayWriter.toByteArray());
        this.remoteForwardings.put(string, forwardingConfiguration);
        forwardingConfiguration.getState().setValue(1);
        log.info(new StringBuffer().append("Remote forwarding configuration '").append(string).append("' started").toString());
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append("Address to bind: ").append(forwardingConfiguration.getAddressToBind()).toString());
            log.debug(new StringBuffer().append("Port to bind: ").append(String.valueOf(forwardingConfiguration.getPortToBind())).toString());
            log.debug(new StringBuffer().append("Host to connect: ").append(forwardingConfiguration.hostToConnect).toString());
            log.debug(new StringBuffer().append("Port to connect: ").append(forwardingConfiguration.portToConnect).toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public class ClientForwardingListener
    extends ForwardingListener {
        public ClientForwardingListener(String string, ConnectionProtocol connectionProtocol, String string2, int n, String string3, int n2) {
            super(string, connectionProtocol, string2, n, string3, n2);
        }

        public ForwardingSocketChannel createChannel(String string, int n, Socket socket) throws ForwardingConfigurationException {
            return this.createForwardingSocketChannel("direct-tcpip", string, n, socket.getInetAddress().getHostAddress(), socket.getPort());
        }
    }
}

