/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgChannelOpen
extends SshMessage {
    private String channelType;
    private byte[] channelData;
    private long initialWindowSize;
    private long maximumPacketSize;
    private long senderChannelId;

    public SshMsgChannelOpen(String string, long l, long l2, long l3, byte[] byArray) {
        super(90);
        this.channelType = string;
        this.senderChannelId = l;
        this.initialWindowSize = l2;
        this.maximumPacketSize = l3;
        this.channelData = byArray;
    }

    public SshMsgChannelOpen() {
        super(90);
    }

    public byte[] getChannelData() {
        return this.channelData;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public long getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public long getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public String getMessageName() {
        return "SSH_MSG_CHANNEL_OPEN";
    }

    public long getSenderChannelId() {
        return this.senderChannelId;
    }

    protected void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException {
        try {
            byteArrayWriter.writeString(this.channelType);
            byteArrayWriter.writeInt(this.senderChannelId);
            byteArrayWriter.writeInt(this.initialWindowSize);
            byteArrayWriter.writeInt(this.maximumPacketSize);
            if (this.channelData != null) {
                byteArrayWriter.write(this.channelData);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Could not write message data");
        }
    }

    protected void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        try {
            this.channelType = byteArrayReader.readString();
            this.senderChannelId = byteArrayReader.readInt();
            this.initialWindowSize = byteArrayReader.readInt();
            this.maximumPacketSize = byteArrayReader.readInt();
            if (byteArrayReader.available() > 0) {
                this.channelData = new byte[byteArrayReader.available()];
                byteArrayReader.read(this.channelData);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}

