/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.KBIPrompt;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgUserAuthInfoRequest
extends SshMessage {
    private String name;
    private String instruction;
    private String langtag;
    private KBIPrompt[] prompts;

    public SshMsgUserAuthInfoRequest() {
        super(60);
    }

    public void addPrompt(String string, boolean bl) {
        if (this.prompts == null) {
            this.prompts = new KBIPrompt[1];
            this.prompts[0] = new KBIPrompt(string, bl);
        } else {
            KBIPrompt[] kBIPromptArray = new KBIPrompt[this.prompts.length + 1];
            System.arraycopy(this.prompts, 0, kBIPromptArray, 0, this.prompts.length);
            this.prompts = kBIPromptArray;
            this.prompts[this.prompts.length - 1] = new KBIPrompt(string, bl);
        }
    }

    public KBIPrompt[] getPrompts() {
        return this.prompts;
    }

    public String getName() {
        return this.name;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public String getMessageName() {
        return "SSH_MSG_USERAUTH_INFO_REQUEST";
    }

    protected void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException {
        try {
            if (this.name != null) {
                byteArrayWriter.writeString(this.name);
            } else {
                byteArrayWriter.writeString("");
            }
            if (this.instruction != null) {
                byteArrayWriter.writeString(this.instruction);
            } else {
                byteArrayWriter.writeString("");
            }
            if (this.langtag != null) {
                byteArrayWriter.writeString(this.langtag);
            } else {
                byteArrayWriter.writeString("");
            }
            if (this.prompts == null) {
                byteArrayWriter.writeInt(0);
            } else {
                byteArrayWriter.writeInt(this.prompts.length);
                for (int i = 0; i < this.prompts.length; ++i) {
                    byteArrayWriter.writeString(this.prompts[i].getPrompt());
                    byteArrayWriter.write(this.prompts[i].echo() ? 1 : 0);
                }
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Failed to write message data");
        }
    }

    protected void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        try {
            this.name = byteArrayReader.readString();
            this.instruction = byteArrayReader.readString();
            this.langtag = byteArrayReader.readString();
            long l = byteArrayReader.readInt();
            int n = 0;
            while ((long)n < l) {
                String string = byteArrayReader.readString();
                boolean bl = byteArrayReader.read() == 1;
                this.addPrompt(string, bl);
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Failed to read message data");
        }
    }
}

