/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.SshEventAdapter;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventAdapter;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.forwarding.ForwardingClient;
import com.sshtools.j2ssh.net.TransportProvider;
import com.sshtools.j2ssh.net.TransportProviderFactory;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.TransportProtocolClient;
import com.sshtools.j2ssh.transport.TransportProtocolState;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshClient {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$SshClient == null ? (class$com$sshtools$j2ssh$SshClient = SshClient.class$("com.sshtools.j2ssh.SshClient")) : class$com$sshtools$j2ssh$SshClient);
    protected AuthenticationProtocolClient authentication;
    protected ConnectionProtocol connection;
    protected ForwardingClient forwarding;
    protected TransportProtocolClient transport;
    protected int authenticationState = 1;
    protected int socketTimeout = 0;
    protected SshEventAdapter eventHandler = null;
    protected Vector activeChannels = new Vector();
    protected ActiveChannelEventListener activeChannelListener = new ActiveChannelEventListener();
    protected boolean useDefaultForwarding = true;
    private Vector activeSftpClients = new Vector();
    static /* synthetic */ Class class$com$sshtools$j2ssh$SshClient;

    public List getAvailableAuthMethods(String string) throws IOException {
        if (this.authentication != null) {
            return this.authentication.getAvailableAuths(string, this.connection.getServiceName());
        }
        return null;
    }

    public boolean isConnected() {
        TransportProtocolState transportProtocolState = this.transport == null ? null : this.transport.getState();
        int n = transportProtocolState == null ? 5 : transportProtocolState.getValue();
        return n == 4 || n == 3;
    }

    public int authenticate(SshAuthenticationClient sshAuthenticationClient) throws IOException {
        this.authenticationState = this.authentication.authenticate(sshAuthenticationClient, this.connection);
        if (this.authenticationState == 4 && this.useDefaultForwarding) {
            this.forwarding.synchronizeConfiguration(this.transport.getProperties());
        }
        return this.authenticationState;
    }

    public void connect(String string, int n, HostKeyVerification hostKeyVerification) throws IOException {
        SshConnectionProperties sshConnectionProperties = new SshConnectionProperties();
        sshConnectionProperties.setHost(string);
        sshConnectionProperties.setPort(n);
        this.connect(sshConnectionProperties, hostKeyVerification);
    }

    public void connect(SshConnectionProperties sshConnectionProperties, HostKeyVerification hostKeyVerification) throws UnknownHostException, IOException {
        TransportProvider transportProvider = TransportProviderFactory.connectTransportProvider(sshConnectionProperties, this.socketTimeout);
        this.transport = new TransportProtocolClient(hostKeyVerification);
        this.transport.addEventHandler(this.eventHandler);
        this.transport.startTransportProtocol(transportProvider, sshConnectionProperties);
        this.authentication = new AuthenticationProtocolClient();
        this.authentication.addEventListener(this.eventHandler);
        this.transport.requestService(this.authentication);
        this.connection = new ConnectionProtocol();
        if (this.useDefaultForwarding) {
            this.forwarding = new ForwardingClient(this.connection);
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.stop();
        }
        if (this.transport != null) {
            this.transport.disconnect("Terminating connection");
        }
    }

    public SessionChannelClient openSessionChannel(ChannelEventListener channelEventListener) throws IOException {
        if (this.authenticationState != 4) {
            throw new SshException("Authentication has not been completed!");
        }
        SessionChannelClient sessionChannelClient = new SessionChannelClient();
        sessionChannelClient.addEventListener(this.activeChannelListener);
        if (!this.connection.openChannel(sessionChannelClient, channelEventListener)) {
            throw new SshException("The server refused to open a session");
        }
        return sessionChannelClient;
    }

    public SftpClient openSftpClient() throws IOException {
        return this.openSftpClient(null);
    }

    public SftpClient openSftpClient(ChannelEventListener channelEventListener) throws IOException {
        SftpClient sftpClient = new SftpClient(this, channelEventListener);
        this.activeSftpClients.add(sftpClient);
        return sftpClient;
    }

    public SftpSubsystemClient openSftpChannel() throws IOException {
        return this.openSftpChannel(null);
    }

    public SftpSubsystemClient openSftpChannel(ChannelEventListener channelEventListener) throws IOException {
        SessionChannelClient sessionChannelClient = this.openSessionChannel(channelEventListener);
        SftpSubsystemClient sftpSubsystemClient = new SftpSubsystemClient();
        if (!this.openChannel(sftpSubsystemClient)) {
            throw new SshException("The SFTP subsystem failed to start");
        }
        if (!sftpSubsystemClient.initialize()) {
            throw new SshException("The SFTP Subsystem could not be initialized");
        }
        return sftpSubsystemClient;
    }

    public boolean openChannel(Channel channel) throws IOException {
        if (this.authenticationState != 4) {
            throw new SshException("Authentication has not been completed!");
        }
        return this.connection.openChannel(channel, this.activeChannelListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    class ActiveChannelEventListener
    extends ChannelEventAdapter {
        ActiveChannelEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChannelOpen(Channel channel) {
            Vector vector = SshClient.this.activeChannels;
            synchronized (vector) {
                SshClient.this.activeChannels.add(channel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChannelClose(Channel channel) {
            Vector vector = SshClient.this.activeChannels;
            synchronized (vector) {
                SshClient.this.activeChannels.remove(channel);
            }
        }
    }
}

