/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class SftpClient {
    SftpSubsystemClient sftp;
    String cwd;
    String lcwd;
    private int BLOCKSIZE = 65535;
    int umask = 18;
    int default_permissions = 511;

    SftpClient(SshClient sshClient, ChannelEventListener channelEventListener) throws IOException {
        if (!sshClient.isConnected()) {
            throw new IOException("SshClient is not connected");
        }
        this.sftp = sshClient.openSftpChannel(channelEventListener);
        this.cwd = this.sftp.getDefaultDirectory();
        this.lcwd = System.getProperty("user.home");
    }

    private String resolveRemotePath(String string) throws IOException {
        this.verifyConnection();
        String string2 = !string.startsWith("/") ? new StringBuffer().append(this.cwd).append(this.cwd.endsWith("/") ? "" : "/").append(string).toString() : string;
        return string2;
    }

    private void verifyConnection() throws SshException {
        if (this.sftp.isClosed()) {
            throw new SshException("The SFTP connection has been closed");
        }
    }

    public List ls(String string) throws IOException {
        String string2 = this.resolveRemotePath(string);
        FileAttributes fileAttributes = this.sftp.getAttributes(string2);
        if (!fileAttributes.isDirectory()) {
            throw new IOException(new StringBuffer().append(string).append(" is not a directory").toString());
        }
        SftpFile sftpFile = this.sftp.openDirectory(string2);
        Vector vector = new Vector();
        while (this.sftp.listChildren(sftpFile, vector) > -1) {
        }
        sftpFile.close();
        return vector;
    }

    public boolean isClosed() {
        return this.sftp.isClosed();
    }

    public void rename(String string, String string2) throws IOException {
        String string3 = this.resolveRemotePath(string);
        String string4 = this.resolveRemotePath(string2);
        this.sftp.renameFile(string3, string4);
    }

    public void quit() throws IOException {
        this.sftp.close();
    }
}

