/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.viewer.text;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.io.EncodingDetector;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.bom.BOMInputStream;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.DialogOwner;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.encoding.EncodingListener;
import com.mucommander.ui.encoding.EncodingMenu;
import com.mucommander.ui.helper.MenuToolkit;
import com.mucommander.ui.helper.MnemonicHelper;
import com.mucommander.ui.viewer.FileFrame;
import com.mucommander.ui.viewer.FileViewer;
import com.mucommander.ui.viewer.text.TextEditorImpl;
import com.mucommander.ui.viewer.text.TextLineNumbersPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;

class TextViewer
extends FileViewer
implements EncodingListener {
    private static final Dimension MIN_DIMENSION = new Dimension(500, 360);
    private TextEditorImpl textEditorImpl;
    private JMenu editMenu;
    private JMenu viewMenu;
    private JMenuItem copyItem;
    private JMenuItem selectAllItem;
    private JMenuItem findItem;
    private JMenuItem findNextItem;
    private JMenuItem findPreviousItem;
    private JMenuItem toggleLineWrapItem;
    private JMenuItem toggleLineNumbersItem;
    private String encoding;

    TextViewer() {
        this(new TextEditorImpl(false));
    }

    TextViewer(TextEditorImpl textEditorImpl) {
        this.textEditorImpl = textEditorImpl;
        this.setComponentToPresent(textEditorImpl.getTextArea());
        this.showLineNumbers(MuConfigurations.getPreferences().getVariable(MuPreference.LINE_NUMBERS, true));
        textEditorImpl.wrap(MuConfigurations.getPreferences().getVariable(MuPreference.LINE_WRAP, true));
        this.initMenuBarItems();
    }

    public void setFrame(FileFrame frame) {
        super.setFrame(frame);
        frame.setMinimumSize(MIN_DIMENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startEditing(AbstractFile file, DocumentListener documentListener) throws IOException {
        InputStream in = null;
        try {
            String encoding;
            if (file.isFileOperationSupported(FileOperation.RANDOM_READ_FILE)) {
                try {
                    in = file.getRandomAccessInputStream();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (in == null) {
                in = file.getInputStream();
            }
            if ((encoding = EncodingDetector.detectEncoding(in)) == null || !Charset.isSupported(encoding)) {
                encoding = "UTF-8";
            }
            if (in instanceof RandomAccessInputStream) {
                ((RandomAccessInputStream)in).seek(0L);
            } else {
                in.close();
                in = file.getInputStream();
            }
            this.loadDocument(in, encoding, documentListener);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    void loadDocument(InputStream in, String encoding, DocumentListener documentListener) throws IOException {
        this.encoding = encoding;
        if (encoding.toLowerCase().startsWith("utf")) {
            in = new BOMInputStream(in);
        }
        BufferedReader isr = new BufferedReader(new InputStreamReader(in, encoding));
        this.textEditorImpl.read(isr);
        if (documentListener != null) {
            this.textEditorImpl.addDocumentListener(documentListener);
        }
    }

    public JMenuBar getMenuBar() {
        JMenuBar menuBar = super.getMenuBar();
        EncodingMenu encodingMenu = new EncodingMenu(new DialogOwner(this.getFrame()), this.encoding);
        encodingMenu.addEncodingListener(this);
        menuBar.add(this.editMenu);
        menuBar.add(this.viewMenu);
        menuBar.add(encodingMenu);
        return menuBar;
    }

    public void beforeCloseHook() {
        MuConfigurations.getPreferences().setVariable(MuPreference.LINE_WRAP, this.textEditorImpl.isWrap());
        MuConfigurations.getPreferences().setVariable(MuPreference.LINE_NUMBERS, this.getRowHeader().getView() != null);
    }

    String getEncoding() {
        return this.encoding;
    }

    protected void showLineNumbers(boolean show) {
        this.setRowHeaderView(show ? new TextLineNumbersPanel(this.textEditorImpl.getTextArea()) : null);
    }

    protected void initMenuBarItems() {
        this.editMenu = new JMenu(Translator.get("text_viewer.edit", new String[0]));
        MnemonicHelper menuItemMnemonicHelper = new MnemonicHelper();
        this.copyItem = MenuToolkit.addMenuItem(this.editMenu, Translator.get("text_viewer.copy", new String[0]), menuItemMnemonicHelper, null, this);
        this.selectAllItem = MenuToolkit.addMenuItem(this.editMenu, Translator.get("text_viewer.select_all", new String[0]), menuItemMnemonicHelper, null, this);
        this.editMenu.addSeparator();
        this.findItem = MenuToolkit.addMenuItem(this.editMenu, Translator.get("text_viewer.find", new String[0]), menuItemMnemonicHelper, KeyStroke.getKeyStroke(70, 128), this);
        this.findNextItem = MenuToolkit.addMenuItem(this.editMenu, Translator.get("text_viewer.find_next", new String[0]), menuItemMnemonicHelper, KeyStroke.getKeyStroke(114, 0), this);
        this.findPreviousItem = MenuToolkit.addMenuItem(this.editMenu, Translator.get("text_viewer.find_previous", new String[0]), menuItemMnemonicHelper, KeyStroke.getKeyStroke(114, 64), this);
        this.viewMenu = new JMenu(Translator.get("text_viewer.view", new String[0]));
        this.toggleLineWrapItem = MenuToolkit.addCheckBoxMenuItem(this.viewMenu, Translator.get("text_viewer.line_wrap", new String[0]), menuItemMnemonicHelper, null, this);
        this.toggleLineWrapItem.setSelected(this.textEditorImpl.isWrap());
        this.toggleLineNumbersItem = MenuToolkit.addCheckBoxMenuItem(this.viewMenu, Translator.get("text_viewer.line_numbers", new String[0]), menuItemMnemonicHelper, null, this);
        this.toggleLineNumbersItem.setSelected(this.getRowHeader().getView() != null);
    }

    public void show(AbstractFile file) throws IOException {
        this.startEditing(file, null);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.copyItem) {
            this.textEditorImpl.copy();
        } else if (source == this.selectAllItem) {
            this.textEditorImpl.selectAll();
        } else if (source == this.findItem) {
            this.textEditorImpl.find();
        } else if (source == this.findNextItem) {
            this.textEditorImpl.findNext();
        } else if (source == this.findPreviousItem) {
            this.textEditorImpl.findPrevious();
        } else if (source == this.toggleLineWrapItem) {
            this.textEditorImpl.wrap(this.toggleLineWrapItem.isSelected());
        } else if (source == this.toggleLineNumbersItem) {
            this.setRowHeaderView(this.toggleLineNumbersItem.isSelected() ? new TextLineNumbersPanel(this.textEditorImpl.getTextArea()) : null);
        } else {
            super.actionPerformed(e);
        }
    }

    public void encodingChanged(Object source, String oldEncoding, String newEncoding) {
        try {
            this.loadDocument(this.getCurrentFile().getInputStream(), newEncoding, null);
        }
        catch (IOException ex) {
            InformationDialog.showErrorDialog(this.getFrame(), Translator.get("read_error", new String[0]), Translator.get("file_editor.cannot_read_file", this.getCurrentFile().getName()));
        }
    }
}

