/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.viewer.text;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.io.bom.BOM;
import com.mucommander.commons.io.bom.BOMInputStream;
import com.mucommander.commons.io.bom.BOMWriter;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.DialogOwner;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.encoding.EncodingListener;
import com.mucommander.ui.encoding.EncodingMenu;
import com.mucommander.ui.helper.MenuToolkit;
import com.mucommander.ui.helper.MnemonicHelper;
import com.mucommander.ui.viewer.FileEditor;
import com.mucommander.ui.viewer.text.TextEditorImpl;
import com.mucommander.ui.viewer.text.TextLineNumbersPanel;
import com.mucommander.ui.viewer.text.TextViewer;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TextEditor
extends FileEditor
implements EncodingListener,
DocumentListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextEditor.class);
    private JMenu editMenu;
    private JMenu viewMenu;
    private JMenuItem copyItem;
    private JMenuItem cutItem;
    private JMenuItem pasteItem;
    private JMenuItem selectAllItem;
    private JMenuItem findItem;
    private JMenuItem findNextItem;
    private JMenuItem findPreviousItem;
    private JMenuItem toggleLineWrapItem;
    private JMenuItem toggleLineNumbersItem;
    private BOM bom;
    private TextEditorImpl textEditorImpl = new TextEditorImpl(true);
    private TextViewer textViewerDelegate = new TextViewer(this.textEditorImpl){

        protected void setComponentToPresent(JComponent component) {
            TextEditor.this.setComponentToPresent(component);
        }

        protected void showLineNumbers(boolean show) {
            TextEditor.this.setRowHeaderView(show ? new TextLineNumbersPanel(TextEditor.this.textEditorImpl.getTextArea()) : null);
        }

        protected void initMenuBarItems() {
            TextEditor.this.editMenu = new JMenu(Translator.get("text_editor.edit", new String[0]));
            MnemonicHelper menuItemMnemonicHelper = new MnemonicHelper();
            TextEditor.this.copyItem = MenuToolkit.addMenuItem(TextEditor.this.editMenu, Translator.get("text_editor.copy", new String[0]), menuItemMnemonicHelper, null, TextEditor.this);
            TextEditor.this.cutItem = MenuToolkit.addMenuItem(TextEditor.this.editMenu, Translator.get("text_editor.cut", new String[0]), menuItemMnemonicHelper, null, TextEditor.this);
            TextEditor.this.pasteItem = MenuToolkit.addMenuItem(TextEditor.this.editMenu, Translator.get("text_editor.paste", new String[0]), menuItemMnemonicHelper, null, TextEditor.this);
            TextEditor.this.selectAllItem = MenuToolkit.addMenuItem(TextEditor.this.editMenu, Translator.get("text_editor.select_all", new String[0]), menuItemMnemonicHelper, null, TextEditor.this);
            TextEditor.this.editMenu.addSeparator();
            TextEditor.this.findItem = MenuToolkit.addMenuItem(TextEditor.this.editMenu, Translator.get("text_editor.find", new String[0]), menuItemMnemonicHelper, KeyStroke.getKeyStroke(70, 128), TextEditor.this);
            TextEditor.this.findNextItem = MenuToolkit.addMenuItem(TextEditor.this.editMenu, Translator.get("text_editor.find_next", new String[0]), menuItemMnemonicHelper, KeyStroke.getKeyStroke(114, 0), TextEditor.this);
            TextEditor.this.findPreviousItem = MenuToolkit.addMenuItem(TextEditor.this.editMenu, Translator.get("text_editor.find_previous", new String[0]), menuItemMnemonicHelper, KeyStroke.getKeyStroke(114, 64), TextEditor.this);
            TextEditor.this.viewMenu = new JMenu(Translator.get("text_editor.view", new String[0]));
            TextEditor.this.toggleLineWrapItem = MenuToolkit.addCheckBoxMenuItem(TextEditor.this.viewMenu, Translator.get("text_editor.line_wrap", new String[0]), menuItemMnemonicHelper, null, TextEditor.this);
            TextEditor.this.toggleLineWrapItem.setSelected(TextEditor.this.textEditorImpl.isWrap());
            TextEditor.this.toggleLineNumbersItem = MenuToolkit.addCheckBoxMenuItem(TextEditor.this.viewMenu, Translator.get("text_editor.line_numbers", new String[0]), menuItemMnemonicHelper, null, TextEditor.this);
            TextEditor.this.toggleLineNumbersItem.setSelected(TextEditor.this.getRowHeader().getView() != null);
        }
    };

    public TextEditor() {
        this.setComponentToPresent(this.textEditorImpl.getTextArea());
    }

    protected void setComponentToPresent(JComponent component) {
        this.getViewport().add(component);
    }

    void loadDocument(InputStream in, String encoding, DocumentListener documentListener) throws IOException {
        this.textViewerDelegate.loadDocument(in, encoding, documentListener);
        if (encoding.toLowerCase().startsWith("utf")) {
            this.bom = ((BOMInputStream)in).getBOM();
        }
    }

    private void write(OutputStream out) throws IOException {
        OutputStreamWriter writer = this.bom == null ? new OutputStreamWriter(out, this.textViewerDelegate.getEncoding()) : new BOMWriter(out, this.bom);
        this.textEditorImpl.write(writer);
    }

    public JMenuBar getMenuBar() {
        JMenuBar menuBar = super.getMenuBar();
        EncodingMenu encodingMenu = new EncodingMenu(new DialogOwner(this.getFrame()), this.textViewerDelegate.getEncoding());
        encodingMenu.addEncodingListener(this);
        menuBar.add(this.editMenu);
        menuBar.add(this.viewMenu);
        menuBar.add(encodingMenu);
        return menuBar;
    }

    public void beforeCloseHook() {
        MuConfigurations.getPreferences().setVariable(MuPreference.LINE_WRAP, this.textEditorImpl.isWrap());
        MuConfigurations.getPreferences().setVariable(MuPreference.LINE_NUMBERS, this.getRowHeader().getView() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAs(AbstractFile destFile) throws IOException {
        OutputStream out = null;
        try {
            out = destFile.getOutputStream();
            this.write(out);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        this.setSaveNeeded(false);
        if (destFile.isFileOperationSupported(FileOperation.CHANGE_DATE)) {
            try {
                destFile.getParent().changeDate(System.currentTimeMillis());
            }
            catch (IOException e) {
                LOGGER.debug("failed to change the date of " + destFile, e);
            }
        }
    }

    public void show(AbstractFile file) throws IOException {
        this.textViewerDelegate.startEditing(file, this);
    }

    public void changedUpdate(DocumentEvent e) {
        this.setSaveNeeded(true);
    }

    public void insertUpdate(DocumentEvent e) {
        this.setSaveNeeded(true);
    }

    public void removeUpdate(DocumentEvent e) {
        this.setSaveNeeded(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.copyItem) {
            this.textEditorImpl.copy();
        } else if (source == this.cutItem) {
            this.textEditorImpl.cut();
        } else if (source == this.pasteItem) {
            this.textEditorImpl.paste();
        } else if (source == this.selectAllItem) {
            this.textEditorImpl.selectAll();
        } else if (source == this.findItem) {
            this.textEditorImpl.find();
        } else if (source == this.findNextItem) {
            this.textEditorImpl.findNext();
        } else if (source == this.findPreviousItem) {
            this.textEditorImpl.findPrevious();
        } else if (source == this.toggleLineWrapItem) {
            this.textEditorImpl.wrap(this.toggleLineWrapItem.isSelected());
        } else if (source == this.toggleLineNumbersItem) {
            this.setRowHeaderView(this.toggleLineNumbersItem.isSelected() ? new TextLineNumbersPanel(this.textEditorImpl.getTextArea()) : null);
        } else {
            super.actionPerformed(e);
        }
    }

    public void encodingChanged(Object source, String oldEncoding, String newEncoding) {
        if (!this.askSave()) {
            return;
        }
        try {
            this.loadDocument(this.getCurrentFile().getInputStream(), newEncoding, null);
        }
        catch (IOException ex) {
            InformationDialog.showErrorDialog(this.getFrame(), Translator.get("read_error", new String[0]), Translator.get("file_editor.cannot_read_file", this.getCurrentFile().getName()));
        }
    }
}

