/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.viewer;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.ui.viewer.FileFrame;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;

abstract class FilePresenter
extends JScrollPane {
    private FileFrame frame;
    private AbstractFile file;

    public FilePresenter() {
        super(20, 30);
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Component component = FilePresenter.this.getViewport().getComponent(0);
                if (component != null) {
                    component.requestFocus();
                }
            }
        });
    }

    protected void setComponentToPresent(JComponent component) {
        this.getViewport().removeAll();
        this.getViewport().add(component);
    }

    protected FileFrame getFrame() {
        return this.frame;
    }

    public void setFrame(FileFrame frame) {
        this.frame = frame;
    }

    protected String getTitle() {
        return this.file.getAbsolutePath();
    }

    protected AbstractFile getCurrentFile() {
        return this.file;
    }

    protected final void setCurrentFile(AbstractFile file) {
        this.file = file;
        this.getFrame().setTitle(this.getTitle());
    }

    public void open(AbstractFile file) throws IOException {
        this.show(file);
        this.setCurrentFile(file);
    }

    public void beforeCloseHook() {
    }

    protected abstract void show(AbstractFile var1) throws IOException;

    protected abstract JMenuBar getMenuBar();
}

