/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.viewer;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.helper.FocusRequester;
import com.mucommander.ui.layout.AsyncPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.viewer.FilePresenter;
import com.mucommander.ui.viewer.UserCancelledException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileFrame
extends JFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileFrame.class);
    private FilePresenter filePresenter;
    private MainFrame mainFrame;

    FileFrame(MainFrame mainFrame, AbstractFile file, Image icon) {
        this.mainFrame = mainFrame;
        this.setIconImage(icon);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.initContentPane(file);
    }

    protected void initContentPane(final AbstractFile file) {
        AsyncPanel asyncPanel = new AsyncPanel(){

            public JComponent getTargetComponent() {
                try {
                    FileFrame.this.filePresenter = FileFrame.this.createFilePresenter(file);
                    FileFrame.this.filePresenter.open(file);
                }
                catch (Exception e) {
                    LOGGER.debug("Exception caught", e);
                    if (!(e instanceof UserCancelledException)) {
                        FileFrame.this.showGenericErrorDialog();
                    }
                    FileFrame.this.dispose();
                    return FileFrame.this.filePresenter == null ? new JPanel() : FileFrame.this.filePresenter;
                }
                FileFrame.this.setJMenuBar(FileFrame.this.filePresenter.getMenuBar());
                if (OsFamilies.MAC_OS_X.isCurrent()) {
                    FileFrame.this.filePresenter.getInputMap(2).put(KeyStroke.getKeyStroke(87, 4), "CUSTOM_DISPOSE_EVENT");
                    FileFrame.this.filePresenter.getActionMap().put("CUSTOM_DISPOSE_EVENT", new AbstractAction(){

                        public void actionPerformed(ActionEvent e) {
                            FileFrame.this.dispose();
                        }
                    });
                }
                return FileFrame.this.filePresenter;
            }

            protected void updateLayout() {
                super.updateLayout();
                FocusRequester.requestFocus(FileFrame.this.filePresenter);
            }
        };
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)asyncPanel, "Center");
        this.setContentPane(contentPane);
        this.pack();
        this.setVisible(true);
    }

    protected MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void pack() {
        super.pack();
        DialogToolkit.fitToScreen(this);
        DialogToolkit.fitToMinDimension(this, this.getMinimumSize());
        DialogToolkit.centerOnWindow(this, this.getMainFrame());
    }

    public void dispose() {
        if (this.filePresenter != null) {
            this.filePresenter.beforeCloseHook();
        }
        super.dispose();
    }

    protected abstract void showGenericErrorDialog();

    protected abstract FilePresenter createFilePresenter(AbstractFile var1) throws UserCancelledException, Exception;
}

