/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.viewer;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.job.FileCollisionChecker;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.dialog.QuestionDialog;
import com.mucommander.ui.dialog.file.FileCollisionDialog;
import com.mucommander.ui.helper.MenuToolkit;
import com.mucommander.ui.helper.MnemonicHelper;
import com.mucommander.ui.viewer.FilePresenter;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public abstract class FileEditor
extends FilePresenter
implements ActionListener {
    private JMenuItem saveItem;
    private JMenuItem saveAsItem;
    private JMenuItem closeItem;
    private boolean saveNeeded;

    protected void setSaveNeeded(boolean saveNeeded) {
        if (this.getFrame() != null && this.saveNeeded != saveNeeded) {
            this.saveNeeded = saveNeeded;
            if (OsFamilies.MAC_OS_X.isCurrent()) {
                this.getFrame().getRootPane().putClientProperty("windowModified", saveNeeded ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    private void trySaveAs() {
        JFileChooser fileChooser = new JFileChooser();
        AbstractFile currentFile = this.getCurrentFile();
        if (currentFile.getURL().getScheme().equals("file")) {
            fileChooser.setSelectedFile(new File(currentFile.getAbsolutePath()));
        }
        fileChooser.setDialogType(1);
        int ret = fileChooser.showSaveDialog(this.getFrame());
        if (ret == 0) {
            int action;
            AbstractFile destFile;
            try {
                destFile = FileFactory.getFile(fileChooser.getSelectedFile().getAbsolutePath(), true);
            }
            catch (IOException e) {
                InformationDialog.showErrorDialog(this.getFrame(), Translator.get("write_error", new String[0]), Translator.get("file_editor.cannot_write", new String[0]));
                return;
            }
            int collision = FileCollisionChecker.checkForCollision(null, destFile);
            if (collision != 0 && (action = new FileCollisionDialog((Frame)this.getFrame(), (Component)this.getFrame(), collision, null, destFile, false, false).getActionValue()) != 2) {
                return;
            }
            if (this.trySave(destFile)) {
                this.setCurrentFile(destFile);
            }
        }
    }

    private boolean trySave(AbstractFile destFile) {
        try {
            this.saveAs(destFile);
            return true;
        }
        catch (IOException e) {
            InformationDialog.showErrorDialog(this.getFrame(), Translator.get("write_error", new String[0]), Translator.get("file_editor.cannot_write", new String[0]));
            return false;
        }
    }

    public boolean askSave() {
        if (!this.saveNeeded) {
            return true;
        }
        QuestionDialog dialog = new QuestionDialog(this.getFrame(), null, Translator.get("file_editor.save_warning", new String[0]), (Component)this.getFrame(), new String[]{Translator.get("save", new String[0]), Translator.get("dont_save", new String[0]), Translator.get("cancel", new String[0])}, new int[]{0, 1, 2}, 0);
        int ret = dialog.getActionValue();
        if (ret == 0 && this.trySave(this.getCurrentFile()) || ret == 1) {
            this.setSaveNeeded(false);
            return true;
        }
        return false;
    }

    public JMenuBar getMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        MnemonicHelper menuMnemonicHelper = new MnemonicHelper();
        MnemonicHelper menuItemMnemonicHelper = new MnemonicHelper();
        JMenu fileMenu = MenuToolkit.addMenu(Translator.get("file_editor.file_menu", new String[0]), menuMnemonicHelper, null);
        this.saveItem = MenuToolkit.addMenuItem(fileMenu, Translator.get("file_editor.save", new String[0]), menuItemMnemonicHelper, KeyStroke.getKeyStroke(83, 2), this);
        this.saveAsItem = MenuToolkit.addMenuItem(fileMenu, Translator.get("file_editor.save_as", new String[0]), menuItemMnemonicHelper, null, this);
        fileMenu.add(new JSeparator());
        this.closeItem = MenuToolkit.addMenuItem(fileMenu, Translator.get("file_editor.close", new String[0]), menuItemMnemonicHelper, KeyStroke.getKeyStroke(27, 0), this);
        menuBar.add(fileMenu);
        return menuBar;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.saveItem) {
            this.trySave(this.getCurrentFile());
        } else if (source == this.saveAsItem) {
            this.trySaveAs();
        } else if (source == this.closeItem) {
            this.getFrame().dispose();
        }
    }

    protected abstract void saveAs(AbstractFile var1) throws IOException;
}

