/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.viewer;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.viewer.EditorRegistrar;
import com.mucommander.ui.viewer.FileEditor;
import com.mucommander.ui.viewer.FileFrame;
import com.mucommander.ui.viewer.FilePresenter;
import com.mucommander.ui.viewer.UserCancelledException;
import java.awt.Dimension;
import java.awt.Image;

public class EditorFrame
extends FileFrame {
    private FileEditor editor;
    private static final Dimension MIN_DIMENSION = new Dimension(500, 360);

    EditorFrame(MainFrame mainFrame, AbstractFile file, Image icon) {
        super(mainFrame, file, icon);
    }

    public Dimension getMinimumSize() {
        return MIN_DIMENSION;
    }

    public void dispose() {
        if (this.editor == null || this.editor.askSave()) {
            super.dispose();
        }
    }

    protected void showGenericErrorDialog() {
        InformationDialog.showErrorDialog(this.getMainFrame(), Translator.get("file_editor.edit_error_title", new String[0]), Translator.get("file_editor.edit_error", new String[0]));
    }

    protected FilePresenter createFilePresenter(AbstractFile file) throws UserCancelledException, Exception {
        this.editor = EditorRegistrar.createFileEditor(file, this);
        return this.editor;
    }
}

