/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.theme;

import com.mucommander.ui.theme.ThemeData;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ThemeReader
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeReader.class);
    private ThemeData template;
    private int state;
    private String unknownElement;

    private ThemeReader(ThemeData t) {
        this.template = t;
        this.state = 0;
    }

    public static void read(InputStream in, ThemeData template) throws Exception {
        SAXParserFactory.newInstance().newSAXParser().parse(in, (DefaultHandler)new ThemeReader(template));
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.unknownElement != null) {
            LOGGER.debug("Ignoring element " + qName);
            return;
        }
        if (qName.equals("theme")) {
            if (this.state != 0) {
                this.traceIllegalDeclaration("theme");
            }
            this.state = 1;
        } else if (qName.equals("file_table")) {
            if (this.state != 1) {
                this.traceIllegalDeclaration(qName);
            }
            this.state = 2;
        } else if (qName.equals("shell")) {
            if (this.state != 1) {
                this.traceIllegalDeclaration(qName);
            }
            this.state = 3;
        } else if (qName.equals("editor")) {
            if (this.state != 1) {
                this.traceIllegalDeclaration(qName);
            }
            this.state = 4;
        } else if (qName.equals("location_bar")) {
            if (this.state != 1) {
                this.traceIllegalDeclaration(qName);
            }
            this.state = 5;
        } else if (qName.equals("quick_list")) {
            if (this.state != 1) {
                this.traceIllegalDeclaration(qName);
            }
            this.state = 38;
        } else if (qName.equals("shell_history")) {
            if (this.state != 1) {
                this.traceIllegalDeclaration(qName);
            }
            this.state = 12;
        } else if (qName.equals("status_bar")) {
            if (this.state != 1) {
                this.traceIllegalDeclaration(qName);
            }
            this.state = 15;
        } else if (qName.equals("hidden")) {
            if (this.state != 2) {
                this.traceIllegalDeclaration(qName);
            }
            this.state = 16;
        } else if (qName.equals("folder")) {
            if (this.state != 2) {
                this.traceIllegalDeclaration(qName);
            }
            this.state = 19;
        } else if (qName.equals("archive")) {
            if (this.state != 2) {
                this.traceIllegalDeclaration(qName);
            }
            this.state = 22;
        } else if (qName.equals("symlink")) {
            if (this.state != 2) {
                this.traceIllegalDeclaration(qName);
            }
            this.state = 25;
        } else if (qName.equals("marked")) {
            if (this.state != 2) {
                this.traceIllegalDeclaration(qName);
            }
            this.state = 28;
        } else if (qName.equals("file")) {
            if (this.state != 2) {
                this.traceIllegalDeclaration(qName);
            }
            this.state = 31;
        } else if (qName.equals("alternate")) {
            if (this.state != 2) {
                this.traceIllegalDeclaration(qName);
            }
            this.state = 36;
        } else if (qName.equals("header")) {
            if (this.state == 38) {
                this.state = 39;
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("item")) {
            if (this.state == 38) {
                this.state = 40;
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("normal")) {
            if (this.state == 3) {
                this.state = 6;
            } else if (this.state == 4) {
                this.state = 8;
            } else if (this.state == 5) {
                this.state = 9;
            } else if (this.state == 12) {
                this.state = 13;
            } else if (this.state == 16) {
                this.state = 17;
            } else if (this.state == 19) {
                this.state = 20;
            } else if (this.state == 22) {
                this.state = 23;
            } else if (this.state == 25) {
                this.state = 26;
            } else if (this.state == 28) {
                this.state = 29;
            } else if (this.state == 31) {
                this.state = 32;
            } else if (this.state == 2) {
                this.state = 34;
            } else if (this.state == 40) {
                this.state = 41;
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("selected")) {
            if (this.state == 3) {
                this.state = 7;
            } else if (this.state == 4) {
                this.state = 10;
            } else if (this.state == 5) {
                this.state = 11;
            } else if (this.state == 12) {
                this.state = 14;
            } else if (this.state == 16) {
                this.state = 18;
            } else if (this.state == 19) {
                this.state = 21;
            } else if (this.state == 22) {
                this.state = 24;
            } else if (this.state == 25) {
                this.state = 27;
            } else if (this.state == 28) {
                this.state = 30;
            } else if (this.state == 31) {
                this.state = 33;
            } else if (this.state == 2) {
                this.state = 35;
            } else if (this.state == 40) {
                this.state = 42;
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("font")) {
            if (this.state == 3) {
                this.template.setFont(1, ThemeReader.createFont(attributes));
            } else if (this.state == 4) {
                this.template.setFont(2, ThemeReader.createFont(attributes));
            } else if (this.state == 5) {
                this.template.setFont(3, ThemeReader.createFont(attributes));
            } else if (this.state == 12) {
                this.template.setFont(4, ThemeReader.createFont(attributes));
            } else if (this.state == 15) {
                this.template.setFont(5, ThemeReader.createFont(attributes));
            } else if (this.state == 2) {
                this.template.setFont(0, ThemeReader.createFont(attributes));
            } else if (this.state == 39) {
                this.template.setFont(6, ThemeReader.createFont(attributes));
            } else if (this.state == 40) {
                this.template.setFont(7, ThemeReader.createFont(attributes));
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("inactive_background")) {
            if (this.state == 34) {
                this.template.setColor(3, ThemeReader.createColor(attributes));
            } else if (this.state == 35) {
                this.template.setColor(8, ThemeReader.createColor(attributes));
            } else if (this.state == 36) {
                this.template.setColor(4, ThemeReader.createColor(attributes));
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("secondary_background")) {
            if (this.state == 35) {
                this.template.setColor(59, ThemeReader.createColor(attributes));
            } else if (this.state == 39) {
                this.template.setColor(62, ThemeReader.createColor(attributes));
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("inactive_secondary_background")) {
            if (this.state == 35) {
                this.template.setColor(60, ThemeReader.createColor(attributes));
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("inactive_foreground")) {
            if (this.state == 32) {
                this.template.setColor(30, ThemeReader.createColor(attributes));
            } else if (this.state == 20) {
                this.template.setColor(14, ThemeReader.createColor(attributes));
            } else if (this.state == 23) {
                this.template.setColor(18, ThemeReader.createColor(attributes));
            } else if (this.state == 26) {
                this.template.setColor(22, ThemeReader.createColor(attributes));
            } else if (this.state == 17) {
                this.template.setColor(10, ThemeReader.createColor(attributes));
            } else if (this.state == 29) {
                this.template.setColor(26, ThemeReader.createColor(attributes));
            } else if (this.state == 33) {
                this.template.setColor(32, ThemeReader.createColor(attributes));
            } else if (this.state == 21) {
                this.template.setColor(16, ThemeReader.createColor(attributes));
            } else if (this.state == 24) {
                this.template.setColor(20, ThemeReader.createColor(attributes));
            } else if (this.state == 27) {
                this.template.setColor(24, ThemeReader.createColor(attributes));
            } else if (this.state == 18) {
                this.template.setColor(12, ThemeReader.createColor(attributes));
            } else if (this.state == 30) {
                this.template.setColor(28, ThemeReader.createColor(attributes));
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("border")) {
            if (this.state == 2) {
                this.template.setColor(0, ThemeReader.createColor(attributes));
            } else if (this.state == 15) {
                this.template.setColor(52, ThemeReader.createColor(attributes));
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("inactive_border")) {
            if (this.state == 2) {
                this.template.setColor(56, ThemeReader.createColor(attributes));
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("outline")) {
            if (this.state == 2) {
                this.template.setColor(57, ThemeReader.createColor(attributes));
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("inactive_outline")) {
            if (this.state == 2) {
                this.template.setColor(58, ThemeReader.createColor(attributes));
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("unmatched")) {
            if (this.state != 2) {
                this.traceIllegalDeclaration(qName);
            }
            this.state = 37;
        } else if (qName.equals("background")) {
            if (this.state == 34) {
                this.template.setColor(1, ThemeReader.createColor(attributes));
            } else if (this.state == 35) {
                this.template.setColor(7, ThemeReader.createColor(attributes));
            } else if (this.state == 36) {
                this.template.setColor(2, ThemeReader.createColor(attributes));
            } else if (this.state == 37) {
                this.template.setColor(5, ThemeReader.createColor(attributes));
            } else if (this.state == 6) {
                this.template.setColor(34, ThemeReader.createColor(attributes));
            } else if (this.state == 7) {
                this.template.setColor(36, ThemeReader.createColor(attributes));
            } else if (this.state == 8) {
                this.template.setColor(42, ThemeReader.createColor(attributes));
            } else if (this.state == 10) {
                this.template.setColor(44, ThemeReader.createColor(attributes));
            } else if (this.state == 9) {
                this.template.setColor(46, ThemeReader.createColor(attributes));
            } else if (this.state == 11) {
                this.template.setColor(48, ThemeReader.createColor(attributes));
            } else if (this.state == 13) {
                this.template.setColor(38, ThemeReader.createColor(attributes));
            } else if (this.state == 14) {
                this.template.setColor(40, ThemeReader.createColor(attributes));
            } else if (this.state == 15) {
                this.template.setColor(51, ThemeReader.createColor(attributes));
            } else if (this.state == 39) {
                this.template.setColor(61, ThemeReader.createColor(attributes));
            } else if (this.state == 41) {
                this.template.setColor(64, ThemeReader.createColor(attributes));
            } else if (this.state == 42) {
                this.template.setColor(66, ThemeReader.createColor(attributes));
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("progress")) {
            if (this.state == 5) {
                this.template.setColor(49, ThemeReader.createColor(attributes));
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("ok")) {
            if (this.state == 15) {
                this.template.setColor(53, ThemeReader.createColor(attributes));
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("warning")) {
            if (this.state == 15) {
                this.template.setColor(54, ThemeReader.createColor(attributes));
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("critical")) {
            if (this.state == 15) {
                this.template.setColor(55, ThemeReader.createColor(attributes));
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else if (qName.equals("foreground")) {
            if (this.state == 17) {
                this.template.setColor(9, ThemeReader.createColor(attributes));
            } else if (this.state == 18) {
                this.template.setColor(11, ThemeReader.createColor(attributes));
            } else if (this.state == 37) {
                this.template.setColor(6, ThemeReader.createColor(attributes));
            } else if (this.state == 20) {
                this.template.setColor(13, ThemeReader.createColor(attributes));
            } else if (this.state == 21) {
                this.template.setColor(15, ThemeReader.createColor(attributes));
            } else if (this.state == 23) {
                this.template.setColor(17, ThemeReader.createColor(attributes));
            } else if (this.state == 24) {
                this.template.setColor(19, ThemeReader.createColor(attributes));
            } else if (this.state == 26) {
                this.template.setColor(21, ThemeReader.createColor(attributes));
            } else if (this.state == 27) {
                this.template.setColor(23, ThemeReader.createColor(attributes));
            } else if (this.state == 29) {
                this.template.setColor(25, ThemeReader.createColor(attributes));
            } else if (this.state == 30) {
                this.template.setColor(27, ThemeReader.createColor(attributes));
            } else if (this.state == 32) {
                this.template.setColor(29, ThemeReader.createColor(attributes));
            } else if (this.state == 33) {
                this.template.setColor(31, ThemeReader.createColor(attributes));
            } else if (this.state == 6) {
                this.template.setColor(33, ThemeReader.createColor(attributes));
            } else if (this.state == 7) {
                this.template.setColor(35, ThemeReader.createColor(attributes));
            } else if (this.state == 13) {
                this.template.setColor(37, ThemeReader.createColor(attributes));
            } else if (this.state == 14) {
                this.template.setColor(39, ThemeReader.createColor(attributes));
            } else if (this.state == 8) {
                this.template.setColor(41, ThemeReader.createColor(attributes));
            } else if (this.state == 10) {
                this.template.setColor(43, ThemeReader.createColor(attributes));
            } else if (this.state == 9) {
                this.template.setColor(45, ThemeReader.createColor(attributes));
            } else if (this.state == 11) {
                this.template.setColor(47, ThemeReader.createColor(attributes));
            } else if (this.state == 15) {
                this.template.setColor(50, ThemeReader.createColor(attributes));
            } else if (this.state == 39) {
                this.template.setColor(63, ThemeReader.createColor(attributes));
            } else if (this.state == 41) {
                this.template.setColor(65, ThemeReader.createColor(attributes));
            } else if (this.state == 42) {
                this.template.setColor(67, ThemeReader.createColor(attributes));
            } else {
                this.traceIllegalDeclaration(qName);
            }
        } else {
            this.traceIllegalDeclaration(qName);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.unknownElement != null) {
            if (qName.equals(this.unknownElement)) {
                this.unknownElement = null;
            } else {
                return;
            }
        }
        if (qName.equals("theme")) {
            this.state = 0;
        } else if (qName.equals("file_table")) {
            this.state = 1;
        } else if (qName.equals("alternate")) {
            this.state = 2;
        } else if (qName.equals("unmatched")) {
            this.state = 2;
        } else if (qName.equals("hidden")) {
            this.state = 2;
        } else if (qName.equals("folder")) {
            this.state = 2;
        } else if (qName.equals("archive")) {
            this.state = 2;
        } else if (qName.equals("symlink")) {
            this.state = 2;
        } else if (qName.equals("marked")) {
            this.state = 2;
        } else if (qName.equals("file")) {
            this.state = 2;
        } else if (qName.equals("shell")) {
            this.state = 1;
        } else if (qName.equals("shell_history")) {
            this.state = 1;
        } else if (qName.equals("editor")) {
            this.state = 1;
        } else if (qName.equals("location_bar")) {
            this.state = 1;
        } else if (qName.equals("quick_list")) {
            this.state = 1;
        } else if (qName.equals("status_bar")) {
            this.state = 1;
        } else if (qName.equals("header")) {
            if (this.state == 39) {
                this.state = 38;
            }
        } else if (qName.equals("item")) {
            if (this.state == 40) {
                this.state = 38;
            }
        } else if (qName.equals("normal")) {
            if (this.state == 6) {
                this.state = 3;
            } else if (this.state == 13) {
                this.state = 12;
            } else if (this.state == 17) {
                this.state = 16;
            } else if (this.state == 20) {
                this.state = 19;
            } else if (this.state == 23) {
                this.state = 22;
            } else if (this.state == 26) {
                this.state = 25;
            } else if (this.state == 29) {
                this.state = 28;
            } else if (this.state == 32) {
                this.state = 31;
            } else if (this.state == 8) {
                this.state = 4;
            } else if (this.state == 9) {
                this.state = 5;
            } else if (this.state == 34) {
                this.state = 2;
            } else if (this.state == 41) {
                this.state = 40;
            }
        } else if (qName.equals("selected")) {
            if (this.state == 7) {
                this.state = 3;
            } else if (this.state == 14) {
                this.state = 12;
            } else if (this.state == 18) {
                this.state = 16;
            } else if (this.state == 21) {
                this.state = 19;
            } else if (this.state == 24) {
                this.state = 22;
            } else if (this.state == 27) {
                this.state = 25;
            } else if (this.state == 30) {
                this.state = 28;
            } else if (this.state == 33) {
                this.state = 31;
            } else if (this.state == 10) {
                this.state = 4;
            } else if (this.state == 11) {
                this.state = 5;
            } else if (this.state == 35) {
                this.state = 2;
            } else if (this.state == 42) {
                this.state = 40;
            }
        }
    }

    private static boolean isFontAvailable(String font) {
        String[] availableFonts;
        for (String availableFont : availableFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            if (!availableFont.equalsIgnoreCase(font)) continue;
            return true;
        }
        return false;
    }

    private static Font createFont(Attributes attributes) {
        int style = 0;
        String buffer = attributes.getValue("bold");
        if (buffer != null && buffer.equals("true")) {
            style |= 1;
        }
        if ((buffer = attributes.getValue("italic")) != null && buffer.equals("true")) {
            style |= 2;
        }
        if ((buffer = attributes.getValue("size")) == null) {
            LOGGER.debug("Missing font size attribute in theme, ignoring.");
            return null;
        }
        int size = Integer.parseInt(buffer);
        buffer = attributes.getValue("family");
        if (buffer == null) {
            LOGGER.debug("Missing font family attribute in theme, ignoring.");
            return null;
        }
        StringTokenizer parser = new StringTokenizer(buffer, ",");
        while (parser.hasMoreTokens()) {
            buffer = parser.nextToken().trim();
            if (!ThemeReader.isFontAvailable(buffer)) continue;
            return new Font(buffer, style, size);
        }
        LOGGER.debug("Requested font families are not installed on the system, using default.");
        return null;
    }

    private static Color createColor(Attributes attributes) {
        String buffer = attributes.getValue("color");
        if (buffer == null) {
            LOGGER.debug("Missing color attribute in theme, ignoring.");
            return null;
        }
        int color = Integer.parseInt(buffer, 16);
        buffer = attributes.getValue("alpha");
        if (buffer == null) {
            return new Color(color);
        }
        return new Color(color | Integer.parseInt(buffer, 16) << 24, true);
    }

    private void traceIllegalDeclaration(String element) {
        this.unknownElement = element;
        LOGGER.debug("Unexpected start of element " + element + ", ignoring.");
    }
}

