/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.theme;

import com.mucommander.text.Translator;
import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.ThemeData;
import com.mucommander.ui.theme.ThemeListener;
import java.awt.Color;
import java.awt.Font;
import java.util.WeakHashMap;

public class Theme
extends ThemeData {
    private static WeakHashMap<ThemeListener, ?> listeners = new WeakHashMap();
    private String name;
    private int type;
    private DefaultValuesListener defaultValuesListener;

    Theme(ThemeListener listener) {
        this.init(listener, 0, null);
    }

    Theme(ThemeListener listener, ThemeData template) {
        super(template);
        this.init(listener, 0, null);
    }

    Theme(ThemeListener listener, ThemeData template, int type, String name) {
        super(template);
        this.init(listener, type, name);
    }

    private void init(ThemeListener listener, int type, String name) {
        this.defaultValuesListener = new DefaultValuesListener();
        this.defaultValuesListener.setTheme(this);
        ThemeData.addDefaultValuesListener(this.defaultValuesListener);
        Theme.addThemeListener(listener);
        this.setType(type);
        if (name != null) {
            this.setName(name);
        }
    }

    public boolean canModify() {
        return this.type == 0;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean setFont(int id, Font font) {
        if (this.type != 0) {
            throw new IllegalStateException("Trying to modify a non user theme.");
        }
        if (super.setFont(id, font)) {
            Theme.triggerFontEvent(new FontChangedEvent(this, id, this.getFont(id)));
            return true;
        }
        return false;
    }

    public boolean setColor(int id, Color color) {
        if (this.type != 0) {
            throw new IllegalStateException("Trying to modify a non user theme.");
        }
        if (super.setColor(id, color)) {
            Theme.triggerColorEvent(new ColorChangedEvent(this, id, this.getColor(id)));
            return true;
        }
        return false;
    }

    void setType(int type) {
        Theme.checkType(type);
        this.type = type;
        if (type == 0) {
            this.setName(Translator.get("theme.custom_theme", new String[0]));
        }
    }

    void setName(String name) {
        this.name = name;
    }

    static void checkType(int type) {
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException("Illegal theme type: " + type);
        }
    }

    public String toString() {
        return this.getName();
    }

    private static void addThemeListener(ThemeListener listener) {
        listeners.put(listener, null);
    }

    private static void triggerFontEvent(FontChangedEvent event) {
        for (ThemeListener listener : listeners.keySet()) {
            listener.fontChanged(event);
        }
    }

    private static void triggerColorEvent(ColorChangedEvent event) {
        for (ThemeListener listener : listeners.keySet()) {
            listener.colorChanged(event);
        }
    }

    private class DefaultValuesListener
    implements ThemeListener {
        private Theme theme;

        public void setTheme(Theme theme) {
            this.theme = theme;
        }

        public void colorChanged(ColorChangedEvent event) {
            if (!this.theme.isColorSet(event.getColorId())) {
                Theme.triggerColorEvent(new ColorChangedEvent(this.theme, event.getColorId(), Theme.this.getColor(event.getColorId())));
            }
        }

        public void fontChanged(FontChangedEvent event) {
            if (!this.theme.isFontSet(event.getFontId())) {
                Theme.triggerFontEvent(new FontChangedEvent(this.theme, event.getFontId(), Theme.this.getFont(event.getFontId())));
            }
        }
    }
}

