/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.theme;

import com.mucommander.ui.theme.ComponentMapper;
import com.mucommander.ui.theme.DefaultColor;
import com.mucommander.ui.theme.ThemeData;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class SystemDefaultColor
extends DefaultColor
implements PropertyChangeListener {
    public static Color DEFAULT_FOREGROUND = Color.BLACK;
    public static Color DEFAULT_BACKGROUND = Color.WHITE;
    public static Color DEFAULT_SELECTION_FOREGROUND = Color.WHITE;
    public static Color DEFAULT_SELECTION_BACKGROUND = Color.BLUE;
    private String property;
    private int type;
    private Color color;
    private ComponentMapper mapper;

    public SystemDefaultColor(int type, String property, ComponentMapper mapper) {
        UIManager.addPropertyChangeListener(this);
        this.property = property;
        this.mapper = mapper;
        this.type = type;
    }

    private Color getColor(JComponent component) {
        if (this.type == 1) {
            return component.getForeground();
        }
        if (this.type == 2) {
            return component.getBackground();
        }
        if (component instanceof JTextComponent) {
            JTextComponent comp = (JTextComponent)component;
            if (this.type == 3) {
                return comp.getSelectedTextColor();
            }
            if (this.type == 4) {
                return comp.getSelectionColor();
            }
        }
        return null;
    }

    private Color getColor() {
        switch (this.type) {
            case 1: {
                return DEFAULT_FOREGROUND;
            }
            case 3: {
                return DEFAULT_SELECTION_FOREGROUND;
            }
            case 4: {
                return DEFAULT_SELECTION_BACKGROUND;
            }
        }
        return DEFAULT_BACKGROUND;
    }

    public Color getColor(ThemeData data) {
        if (this.color == null) {
            this.color = UIManager.getColor(this.property);
            if (this.color == null && (this.color = this.getColor(this.mapper.getComponent())) == null) {
                this.color = this.getColor();
            }
            this.color = new Color(this.color.getRGB(), (this.color.getRGB() & 0xFF000000) != -16777216);
        }
        return this.color;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName().toLowerCase();
        if (name.equals("lookandfeel") || name.equalsIgnoreCase(this.property)) {
            Color oldColor = this.color = null;
            this.color = this.getColor((ThemeData)null);
            if (!this.color.equals(oldColor)) {
                this.notifyChange(this.color);
            }
        }
    }
}

