/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.text;

import com.mucommander.ui.text.KeyStrokeUtils;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class RecordingKeyStrokeTextField
extends JTextField
implements FocusListener,
KeyListener {
    private KeyStroke lastKeyStroke;
    private final Border defaultTextFieldBorder = this.getBorder();

    public RecordingKeyStrokeTextField(int columns, KeyStroke keyStroke) {
        this.setColumns(columns);
        this.setHorizontalAlignment(0);
        this.setEditable(false);
        this.setSelectionColor(UIManager.getColor("jtextfield.background"));
        this.setSelectedTextColor(this.getForeground());
        this.lastKeyStroke = keyStroke;
        super.setText(KeyStrokeUtils.getKeyStrokeDisplayableRepresentation(this.lastKeyStroke));
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    public KeyStroke getKeyStroke() {
        return this.lastKeyStroke;
    }

    public void focusGained(FocusEvent e) {
        this.setBorder(BorderFactory.createLineBorder(Color.orange, 2));
    }

    public void focusLost(FocusEvent e) {
        this.setBorder(this.defaultTextFieldBorder);
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() != 27) {
            this.lastKeyStroke = KeyStroke.getKeyStroke(e.getKeyCode(), 0);
            this.setText(KeyStrokeUtils.getKeyStrokeDisplayableRepresentation(this.lastKeyStroke));
        }
        e.consume();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

