/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.text;

import com.mucommander.commons.runtime.OsFamilies;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

public class KeyStrokeUtils {
    private static final String SHIFT_MODIFIER_STRING = KeyEvent.getKeyModifiersText(1);
    private static final String CTRL_MODIFIER_STRING = KeyEvent.getKeyModifiersText(2);
    private static final String ALT_MODIFIER_STRING = KeyEvent.getKeyModifiersText(8);
    private static final String META_MODIFIER_STRING = KeyEvent.getKeyModifiersText(4);

    public static String getKeyStrokeRepresentation(KeyStroke ks) {
        return ks.toString().replaceFirst("(released )|(pressed )|(typed )", "");
    }

    public static String getKeyStrokeDisplayableRepresentation(KeyStroke ks) {
        if (ks == null) {
            return null;
        }
        int modifiers = ks.getModifiers();
        String keyText = KeyEvent.getKeyText(ks.getKeyCode());
        if (modifiers != 0) {
            return KeyStrokeUtils.getModifiersDisplayableRepresentation(modifiers) + "+" + keyText;
        }
        return keyText;
    }

    public static String getModifiersDisplayableRepresentation(int modifiers) {
        String modifiersString = "";
        if ((modifiers & 1) != 0) {
            modifiersString = modifiersString + SHIFT_MODIFIER_STRING;
        }
        if ((modifiers & 2) != 0) {
            modifiersString = modifiersString + (modifiersString.equals("") ? "" : "+") + CTRL_MODIFIER_STRING;
        }
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            if ((modifiers & 8) != 0) {
                modifiersString = modifiersString + (modifiersString.equals("") ? "" : "+") + ALT_MODIFIER_STRING;
            }
            if ((modifiers & 4) != 0) {
                modifiersString = modifiersString + (modifiersString.equals("") ? "" : "+") + META_MODIFIER_STRING;
            }
        } else {
            if ((modifiers & 4) != 0) {
                modifiersString = modifiersString + (modifiersString.equals("") ? "" : "+") + META_MODIFIER_STRING;
            }
            if ((modifiers & 8) != 0) {
                modifiersString = modifiersString + (modifiersString.equals("") ? "" : "+") + ALT_MODIFIER_STRING;
            }
        }
        return modifiersString;
    }
}

