/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.tabs;

import com.mucommander.ui.tabs.Tab;
import com.mucommander.ui.tabs.TabbedPane;
import com.mucommander.ui.tabs.TabsChangeListener;
import com.mucommander.ui.tabs.TabsCollection;
import com.mucommander.ui.tabs.TabsDisplay;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleTabsDisplay<T extends Tab>
extends TabsDisplay<T>
implements TabsChangeListener,
ChangeListener {
    private TabsCollection<T> tabs;
    private TabbedPane<T> pane;

    public MultipleTabsDisplay(TabsCollection<T> tabs, TabbedPane<T> tabbedpane) {
        super(tabbedpane, tabs);
        this.tabs = tabs;
        this.pane = tabbedpane;
        int index = 0;
        for (Tab tab : tabs) {
            tabbedpane.add(tab, index++);
        }
        tabs.addTabsListener(this);
        this.pane.addChangeListener(this);
    }

    @Override
    public int getSelectedTabIndex() {
        return this.pane.getSelectedIndex();
    }

    public void removeTab(int index) {
        this.pane.remove(index);
    }

    @Override
    public void tabUpdated(int index) {
        this.update(this.tabs.get(index), index);
    }

    @Override
    public void tabAdded(int index) {
        this.add(this.tabs.get(index), index);
    }

    @Override
    public void tabRemoved(int index) {
        this.removeTab(index);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int selectedIndex = this.getSelectedTabIndex();
        if (selectedIndex != -1) {
            this.show(this.tabs.get(selectedIndex));
        }
    }

    public void add(T tab, int index) {
        this.pane.add(tab, index);
    }

    public void update(T tab, int index) {
        this.pane.update(tab, index);
    }

    public void show(T t) {
        this.pane.show(t);
    }

    @Override
    public void destroy() {
        this.tabs.removeTabsListener(this);
        this.pane.removeChangeListener(this);
    }

    @Override
    public void setSelectedTabIndex(int index) {
        this.pane.setSelectedIndex(index);
    }

    @Override
    public void requestFocus() {
        this.pane.requestFocusInWindow();
    }

    @Override
    public T removeCurrentTab() {
        T tab = this.tabs.get(this.getSelectedTabIndex());
        this.tabs.remove(this.getSelectedTabIndex());
        return tab;
    }

    @Override
    public void removeDuplicateTabs() {
        HashSet<Tab> visitedTabs = new HashSet<Tab>();
        HashSet<Tab> duplicatedTabs = new HashSet<Tab>();
        int selectedTabIndex = this.getSelectedTabIndex();
        for (Tab tab : this.tabs) {
            if (visitedTabs.add(tab)) continue;
            duplicatedTabs.add(tab);
        }
        T selectedTab = this.tabs.get(selectedTabIndex);
        if (duplicatedTabs.remove(selectedTab)) {
            int removedTabsCount = 0;
            int tabsCount = this.tabs.count();
            for (int i = 0; i < tabsCount; ++i) {
                if (i == selectedTabIndex || !selectedTab.equals(this.tabs.get(i - removedTabsCount))) continue;
                this.tabs.remove(i - removedTabsCount++);
            }
        }
        for (int i = 0; i < this.tabs.count(); ++i) {
            T currentTab = this.tabs.get(i);
            if (!duplicatedTabs.remove(currentTab)) continue;
            for (int j = i + 1; j < this.tabs.count(); ++j) {
                if (!currentTab.equals(this.tabs.get(j))) continue;
                this.tabs.remove(j--);
            }
        }
    }

    @Override
    public void removeOtherTabs() {
        int i;
        int selectedTabIndex = this.getSelectedTabIndex();
        for (i = 0; i < selectedTabIndex; ++i) {
            this.tabs.remove(0);
        }
        for (i = this.tabs.count() - 1; i > 0; --i) {
            this.tabs.remove(1);
        }
    }

    @Override
    public void removeTab(Component header) {
        this.tabs.remove(this.pane.indexOfTabComponent(header));
    }
}

