/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.tabs;

import com.mucommander.ui.tabs.NullableTabsDisplay;
import com.mucommander.ui.tabs.Tab;
import com.mucommander.ui.tabs.TabsChangeListener;
import com.mucommander.ui.tabs.TabsCollection;
import com.mucommander.ui.tabs.TabsDisplay;
import com.mucommander.ui.tabs.TabsDisplayFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HideableTabbedPane<T extends Tab>
extends JComponent
implements TabsChangeListener {
    private TabsCollection<T> tabs;
    private TabsDisplay<T> display = new NullableTabsDisplay();
    private TabsDisplayFactory<T> tabsDisplayFactory;

    public HideableTabbedPane(TabsDisplayFactory<T> tabsDisplayFactory) {
        this.setLayout(new BorderLayout());
        this.tabsDisplayFactory = tabsDisplayFactory;
        this.tabs = new TabsCollection();
        this.tabs.addTabsListener(this);
    }

    protected void addTab(T tab) {
        this.tabs.add(tab);
    }

    protected void addAndSelectTab(T tab) {
        this.addTab(tab);
        this.display.setSelectedTabIndex(this.tabs.count() - 1);
    }

    protected void updateTab(T tab) {
        this.tabs.updateTab(this.display.getSelectedTabIndex(), tab);
    }

    protected void removeTab(Component header) {
        this.display.removeTab(header);
    }

    protected T removeTab() {
        return this.display.removeCurrentTab();
    }

    protected void removeDuplicateTabs() {
        this.display.removeDuplicateTabs();
    }

    protected void removeOtherTabs() {
        this.display.removeOtherTabs();
    }

    public void nextTab() {
        this.display.nextTab();
    }

    public void previousTab() {
        this.display.previousTab();
    }

    private void switchToMultipleTabs() {
        this.setTabsDisplay(this.tabsDisplayFactory.createMultipleTabsDisplay(this.tabs));
    }

    private void switchToSingleTab() {
        this.setTabsDisplay(this.tabsDisplayFactory.createSingleTabsDisplay(this.tabs));
    }

    private void setTabsDisplay(TabsDisplay<T> display) {
        this.display.destroy();
        this.display = display;
        this.removeAll();
        this.add(display);
        this.validate();
        display.requestFocus();
    }

    protected Iterator<T> getTabsIterator() {
        return this.tabs.iterator();
    }

    protected T getTab(int index) {
        return this.tabs.get(index);
    }

    protected void selectTab(int index) {
        this.display.setSelectedTabIndex(index);
    }

    @Override
    public void tabAdded(int index) {
        switch (this.tabs.count()) {
            case 2: {
                this.switchToMultipleTabs();
                break;
            }
            case 1: {
                this.switchToSingleTab();
                break;
            }
        }
    }

    @Override
    public void tabRemoved(int index) {
        if (this.tabs.count() == 1) {
            this.switchToSingleTab();
        }
    }

    @Override
    public void tabUpdated(int index) {
    }
}

