/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.notifier;

import com.mucommander.commons.runtime.JavaVersions;
import com.mucommander.ui.action.AWTActionProxy;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.main.WindowManager;
import com.mucommander.ui.notifier.AbstractNotifier;
import com.mucommander.ui.notifier.NotificationType;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTrayNotifier
extends AbstractNotifier
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemTrayNotifier.class);
    private TrayIcon trayIcon;
    private boolean isEnabled;
    private static final Map<NotificationType, TrayIcon.MessageType> MESSAGE_TYPES = new Hashtable<NotificationType, TrayIcon.MessageType>();

    SystemTrayNotifier() {
    }

    private void addMenuItem(Menu menu, String muActionId) {
        MuAction action = ActionManager.getActionInstance(muActionId, WindowManager.getCurrentMainFrame());
        MenuItem menuItem = new MenuItem(action.getLabel());
        menuItem.addActionListener(new AWTActionProxy(action));
        menu.add(menuItem);
    }

    public boolean setEnabled(boolean enabled) {
        if (enabled) {
            if (JavaVersions.JAVA_1_6.isCurrentLower() || !SystemTray.isSupported()) {
                return false;
            }
            if (this.trayIcon != null) {
                this.isEnabled = true;
                return true;
            }
            SystemTray systemTray = SystemTray.getSystemTray();
            Image iconImage = IconManager.getIcon(7, "icon16_8.png").getImage();
            Dimension trayIconSize = systemTray.getTrayIconSize();
            if (trayIconSize.width > 16 || trayIconSize.height > 16) {
                BufferedImage bi = new BufferedImage(trayIconSize.width, trayIconSize.height, 2);
                bi.getGraphics().drawImage(iconImage, (trayIconSize.width - 16) / 2, (trayIconSize.height - 16) / 2, null);
                iconImage = bi;
            }
            this.trayIcon = new TrayIcon(iconImage);
            this.trayIcon.setImageAutoSize(false);
            PopupMenu menu = new PopupMenu();
            this.addMenuItem(menu, "NewWindow");
            this.addMenuItem(menu, "BringAllToFront");
            menu.addSeparator();
            this.addMenuItem(menu, "Quit");
            this.trayIcon.setPopupMenu(menu);
            try {
                systemTray.add(this.trayIcon);
                this.trayIcon.addActionListener(this);
                this.isEnabled = true;
                return true;
            }
            catch (AWTException e) {
                this.trayIcon = null;
                this.isEnabled = false;
                return false;
            }
        }
        if (this.trayIcon != null) {
            SystemTray.getSystemTray().remove(this.trayIcon);
            this.trayIcon.removeActionListener(this);
            this.trayIcon = null;
        }
        this.isEnabled = false;
        return false;
    }

    public boolean isEnabled() {
        return this.trayIcon != null && this.isEnabled;
    }

    public boolean displayNotification(NotificationType notificationType, String title, String description) {
        LOGGER.debug("notificationType=" + (Object)((Object)notificationType) + " title=" + title + " description=" + description);
        if (!this.isEnabled()) {
            LOGGER.debug("Ignoring notification, this notifier is not enabled");
            return false;
        }
        this.trayIcon.displayMessage(title, description, MESSAGE_TYPES.get((Object)notificationType));
        return true;
    }

    public String getPrettyName() {
        return "System Tray";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        LOGGER.trace("caught SystemTray ActionEvent");
        WindowManager.getCurrentMainFrame().toFront();
    }

    protected void finalize() throws Throwable {
        if (this.isEnabled()) {
            this.setEnabled(false);
        }
        super.finalize();
    }

    static {
        MESSAGE_TYPES.put(NotificationType.JOB_COMPLETED, TrayIcon.MessageType.INFO);
        MESSAGE_TYPES.put(NotificationType.JOB_ERROR, TrayIcon.MessageType.ERROR);
    }
}

