/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.notifier;

import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.text.Translator;
import com.mucommander.ui.macosx.AppleScript;
import com.mucommander.ui.notifier.AbstractNotifier;
import com.mucommander.ui.notifier.NotificationType;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrowlNotifier
extends AbstractNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrowlNotifier.class);
    private static boolean isEnabled;
    private static boolean isRegistered;
    private static final Map<NotificationType, String> NOTIFICATION_KEYS;

    GrowlNotifier() {
    }

    private static boolean tellGrowl(String appleScript) {
        return AppleScript.execute("tell application \"GrowlHelperApp\"\n\t" + appleScript + "\n" + "end tell", null);
    }

    public String getPrettyName() {
        return "Growl";
    }

    public boolean setEnabled(boolean enabled) {
        if (enabled) {
            if (!OsFamilies.MAC_OS_X.isCurrent()) {
                return false;
            }
            if (isRegistered) {
                isEnabled = true;
                return true;
            }
            StringBuilder outputBuffer = new StringBuilder();
            if (!AppleScript.execute("tell application \"System Events\"\n\tset isRunning to (count of (every process whose name is \"GrowlHelperApp\")) > 0\nend tell", outputBuffer) || !outputBuffer.toString().equals("true")) {
                LOGGER.debug("Growl is not running, aborting");
                return false;
            }
            String notificationTypes = "{\"" + Translator.get(NOTIFICATION_KEYS.get((Object)NotificationType.JOB_COMPLETED), new String[0]) + "\"," + "\"" + Translator.get(NOTIFICATION_KEYS.get((Object)NotificationType.JOB_ERROR), new String[0]) + "\"" + "}";
            isRegistered = GrowlNotifier.tellGrowl("register as application \"muCommander\" all notifications " + notificationTypes + " default notifications " + notificationTypes + " icon of application \"" + "muCommander" + "\"");
            LOGGER.info(isRegistered ? "Successfully registered muCommander with Growl" : "Error while registering muCommander with Growl");
            isEnabled = isRegistered;
            return isEnabled;
        }
        isEnabled = false;
        return false;
    }

    public boolean isEnabled() {
        return isEnabled;
    }

    public boolean displayNotification(NotificationType notificationType, String title, String description) {
        LOGGER.debug("notificationType=" + (Object)((Object)notificationType) + " title=" + title + " description=" + description);
        if (!this.isEnabled()) {
            LOGGER.debug("Ignoring notification, this notifier is not enabled");
            return false;
        }
        boolean success = GrowlNotifier.tellGrowl("notify with name \"" + Translator.get(NOTIFICATION_KEYS.get((Object)notificationType), new String[0]) + "\"" + " title \"" + title + "\"" + " description \"" + description + "\"" + " application name \"" + "muCommander" + "\"");
        LOGGER.debug(success ? "Notification sent successfully" : "Error while sending notification");
        return success;
    }

    static {
        NOTIFICATION_KEYS = new Hashtable<NotificationType, String>();
        NOTIFICATION_KEYS.put(NotificationType.JOB_COMPLETED, "progress_dialog.job_finished");
        NOTIFICATION_KEYS.put(NotificationType.JOB_ERROR, "progress_dialog.job_error");
    }
}

