/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.notifier;

import com.mucommander.commons.runtime.JavaVersions;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.ui.main.WindowManager;
import com.mucommander.ui.notifier.GrowlNotifier;
import com.mucommander.ui.notifier.NotificationType;
import com.mucommander.ui.notifier.SystemTrayNotifier;
import java.awt.SystemTray;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNotifier.class);
    private static AbstractNotifier notifier;

    public static boolean isAvailable() {
        return notifier != null;
    }

    public static AbstractNotifier getNotifier() {
        return notifier;
    }

    public void displayBackgroundNotification(final NotificationType notificationType, final String title, final String description) {
        SwingUtilities.invokeLater(new Thread(){

            public void run() {
                if (WindowManager.getCurrentMainFrame().isAncestorOfActiveWindow()) {
                    LOGGER.debug("Ignoring notification, application is in foreground");
                    return;
                }
                if (!AbstractNotifier.this.displayNotification(notificationType, title, description)) {
                    LOGGER.debug("Notification failed to be displayed");
                }
            }
        });
    }

    public abstract boolean setEnabled(boolean var1);

    public abstract boolean isEnabled();

    public abstract boolean displayNotification(NotificationType var1, String var2, String var3);

    public abstract String getPrettyName();

    static {
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            notifier = new GrowlNotifier();
        } else if (JavaVersions.JAVA_1_6.isCurrentOrHigher() && SystemTray.isSupported()) {
            notifier = new SystemTrayNotifier();
        }
    }
}

