/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.tree;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOThread.class);
    private List<Runnable> queue;
    private long blockThreshold;
    private volatile long lastActionTime = 0L;

    public IOThread(List<Runnable> queue, long blockThreshold) {
        super("IOThread");
        this.queue = queue;
        this.blockThreshold = blockThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!IOThread.interrupted()) {
            Runnable task;
            this.lastActionTime = System.currentTimeMillis();
            while (this.queue.size() > 0) {
                task = this.queue.remove(0);
                try {
                    task.run();
                }
                catch (Exception e) {
                    LOGGER.debug("Caught exception", e);
                }
                this.lastActionTime = System.currentTimeMillis();
            }
            try {
                task = this;
                synchronized (task) {
                    this.wait(this.blockThreshold / 2L);
                }
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public boolean isBlocked() {
        return this.lastActionTime != 0L && System.currentTimeMillis() - this.lastActionTime > this.blockThreshold;
    }
}

