/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.tree;

import com.mucommander.commons.conf.ConfigurationEvent;
import com.mucommander.commons.conf.ConfigurationListener;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.filter.AndFileFilter;
import com.mucommander.commons.file.filter.AttributeFileFilter;
import com.mucommander.commons.file.util.FileComparator;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.event.LocationEvent;
import com.mucommander.ui.event.LocationListener;
import com.mucommander.ui.main.ConfigurableFolderFilter;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.tree.FilesTreeModel;
import com.mucommander.ui.main.tree.FoldersTreeRenderer;
import com.mucommander.ui.main.tree.TreeIOThreadManager;
import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.ThemeCache;
import com.mucommander.ui.theme.ThemeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoldersTreePanel
extends JPanel
implements ConfigurationListener,
LocationListener,
ThemeListener,
FocusListener,
TreeModelListener,
TreeSelectionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FoldersTreePanel.class);
    private JTree tree;
    private FolderPanel folderPanel;
    private FilesTreeModel model;
    private ChangeTimer changeTimer = new ChangeTimer();

    public FoldersTreePanel(FolderPanel folderPanel) {
        this.folderPanel = folderPanel;
        this.setLayout(new BorderLayout());
        AndFileFilter treeFileFilter = new AndFileFilter(new AttributeFileFilter(0), new ConfigurableFolderFilter());
        FileComparator sort = new FileComparator(0, true, true);
        this.model = new FilesTreeModel(treeFileFilter, sort);
        this.tree = new JTree(this.model);
        this.tree.setFont(ThemeCache.tableFont);
        this.tree.setBackground(ThemeCache.backgroundColors[0][0]);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.getModel().addTreeModelListener(this);
        JScrollPane sp = new JScrollPane(this.tree);
        sp.setBorder(null);
        this.add((Component)sp, "Center");
        FoldersTreeRenderer renderer = new FoldersTreeRenderer(this.tree);
        this.tree.setCellRenderer(renderer);
        this.tree.addTreeSelectionListener(this);
        this.tree.addFocusListener(this);
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem item = new JMenuItem(ActionProperties.getActionLabel("Refresh"), 82);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FoldersTreePanel.this.model.refresh(FoldersTreePanel.this.tree.getSelectionPath());
            }
        });
        popup.add(item);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        ThemeCache.addThemeListener(this);
        MuConfigurations.addPreferencesListener(this);
    }

    public void configurationChanged(ConfigurationEvent event) {
        Object root;
        String var = event.getVariable();
        if ((var.equals("file_table.show_hidden_files") || var.equals("file_table.show_ds_store_files") || var.equals("file_table.show_system_folders")) && (root = this.model.getRoot()) != null) {
            TreePath path = new TreePath(root);
            this.model.refresh(path);
        }
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (flag) {
            this.updateSelectedFolder();
            this.folderPanel.getLocationManager().addLocationListener(this);
        } else {
            this.folderPanel.getLocationManager().removeLocationListener(this);
        }
    }

    private void updateSelectedFolder() {
        AbstractFile tempParent;
        AbstractFile currentFolder;
        AbstractFile tempFolder = currentFolder = this.folderPanel.getCurrentFolder();
        while (!tempFolder.isDirectory() && (tempParent = tempFolder.getParent()) != null) {
            tempFolder = tempParent;
        }
        final AbstractFile selectedFolder = tempFolder;
        TreePath selectionPath = this.tree.getSelectionPath();
        if (selectionPath != null && selectionPath.getLastPathComponent() == currentFolder) {
            return;
        }
        AbstractFile currentRoot = selectedFolder.getRoot();
        if (!currentRoot.equals(this.model.getRoot())) {
            this.model.setRoot(currentRoot);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    TreePath path = new TreePath(FoldersTreePanel.this.model.getPathToRoot(selectedFolder));
                    FoldersTreePanel.this.tree.expandPath(path);
                    FoldersTreePanel.this.tree.setSelectionPath(path);
                    FoldersTreePanel.this.tree.scrollPathToVisible(path);
                }
                catch (Exception e) {
                    LOGGER.debug("Caught exception", e);
                }
            }
        });
    }

    public void refreshFolder(AbstractFile folder) {
        if (!this.isVisible()) {
            return;
        }
        this.model.fireTreeStructureChanged(this.tree, new TreePath(this.model.getPathToRoot(folder)));
    }

    public void requestFocus() {
        this.tree.requestFocus();
    }

    public JTree getTree() {
        return this.tree;
    }

    public void valueChanged(TreeSelectionEvent e) {
        AbstractFile f;
        TreePath path = e.getNewLeadSelectionPath();
        if (path != null && (f = (AbstractFile)path.getLastPathComponent()) != null && f.isBrowsable() && f != this.folderPanel.getCurrentFolder()) {
            this.changeTimer.folder = f;
            this.changeTimer.restart();
        }
    }

    public void locationCancelled(LocationEvent locationEvent) {
    }

    public void locationChanged(LocationEvent locationEvent) {
        this.updateSelectedFolder();
    }

    public void locationChanging(LocationEvent locationEvent) {
    }

    public void locationFailed(LocationEvent locationEvent) {
    }

    public void focusGained(FocusEvent e) {
        this.tree.setBackground(ThemeCache.backgroundColors[1][0]);
    }

    public void focusLost(FocusEvent e) {
        this.tree.setBackground(ThemeCache.backgroundColors[0][0]);
    }

    public void colorChanged(ColorChangedEvent event) {
        if (this.tree.hasFocus()) {
            this.tree.setBackground(ThemeCache.backgroundColors[1][0]);
        } else {
            this.tree.setBackground(ThemeCache.backgroundColors[0][0]);
        }
        this.tree.repaint();
    }

    public void fontChanged(FontChangedEvent event) {
        this.tree.setFont(ThemeCache.tableFont);
        this.tree.repaint();
    }

    public void treeNodesChanged(TreeModelEvent e) {
    }

    public void treeNodesInserted(TreeModelEvent e) {
    }

    public void treeNodesRemoved(TreeModelEvent e) {
    }

    public void treeStructureChanged(TreeModelEvent e) {
        if (!this.changeTimer.isRunning()) {
            this.updateSelectedFolder();
            this.tree.repaint();
        }
    }

    static {
        TreeIOThreadManager.getInstance().start();
    }

    private class ChangeTimer
    extends Timer {
        private transient AbstractFile folder;

        public ChangeTimer() {
            super(1000, null);
            this.setRepeats(false);
        }

        public void fireActionPerformed(ActionEvent ae) {
            if (!FoldersTreePanel.this.folderPanel.getCurrentFolder().equals(this.folder)) {
                FoldersTreePanel.this.folderPanel.tryChangeCurrentFolder(this.folder);
            }
        }
    }
}

