/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.tree;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.filter.FileFilter;
import com.mucommander.commons.file.util.FileComparator;
import com.mucommander.ui.icon.FileIcons;
import com.mucommander.ui.icon.SpinningDial;
import com.mucommander.ui.main.tree.CachedDirectory;
import com.mucommander.ui.main.tree.CachedDirectoryListener;
import com.mucommander.ui.main.tree.DirectoryCache;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FilesTreeModel
implements CachedDirectoryListener,
TreeModel {
    private DirectoryCache cache;
    private FileComparator sort;
    protected EventListenerList listenerList = new EventListenerList();
    private AbstractFile root;
    private int cachingNum = 0;
    private SpinningDial spinningIcon = new SpinningDial(16, 16, false);

    public FilesTreeModel(FileFilter filter, FileComparator sort) {
        this.sort = sort;
        this.cache = new DirectoryCache(filter, sort);
        this.cache.addCachedDirectoryListener(this);
    }

    public void setRoot(AbstractFile newRoot) {
        final CachedDirectory cachedRoot = new CachedDirectory(newRoot, this.cache);
        cachedRoot.setCachedIcon(FileIcons.getFileIcon(newRoot));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FilesTreeModel.this.root = cachedRoot.getProxiedFile();
                FilesTreeModel.this.cache.clear();
                FilesTreeModel.this.cache.put(FilesTreeModel.this.root, cachedRoot);
                TreePath path = new TreePath(FilesTreeModel.this.root);
                FilesTreeModel.this.fireTreeStructureChanged(this, path);
            }
        });
    }

    public Object getRoot() {
        return this.root;
    }

    private AbstractFile[] getChildren(AbstractFile parent) {
        CachedDirectory cachedDir = this.cache.getOrAdd(parent);
        if (cachedDir.isCached()) {
            return cachedDir.get();
        }
        return null;
    }

    public Object getChild(Object parent, int index) {
        AbstractFile[] children = this.getChildren((AbstractFile)parent);
        if (children != null) {
            return children[index];
        }
        return null;
    }

    public int getChildCount(Object parent) {
        AbstractFile[] children = this.getChildren((AbstractFile)parent);
        if (children != null) {
            return children.length;
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        AbstractFile[] children = this.getChildren((AbstractFile)parent);
        if (children != null) {
            return Arrays.binarySearch(children, (AbstractFile)child, this.sort);
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return false;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    void fireTreeStructureChanged(Object object, TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, treePath);
            }
            ((TreeModelListener)objectArray[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    public AbstractFile[] getPathToRoot(AbstractFile aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    protected AbstractFile[] getPathToRoot(AbstractFile aNode, int depth) {
        AbstractFile[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new AbstractFile[depth];
        } else {
            retNodes = aNode == this.root ? new AbstractFile[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
            this.cache.getOrAdd(aNode).isCached();
        }
        return retNodes;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    public void refresh(TreePath path) {
        AbstractFile folder = (AbstractFile)path.getLastPathComponent();
        CachedDirectory cached = this.cache.get(folder);
        Icon cachedIcon = cached.getCachedIcon();
        this.cache.removeWithChildren(folder);
        cached = this.cache.getOrAdd(folder);
        cached.setCachedIcon(cachedIcon);
        this.fireTreeStructureChanged(this, path);
    }

    public void cachingStarted(AbstractFile parent) {
        ++this.cachingNum;
        if (this.cachingNum == 1) {
            this.spinningIcon.setAnimated(true);
        }
    }

    public void cachingEnded(AbstractFile parent) {
        --this.cachingNum;
        if (this.cachingNum == 0) {
            this.spinningIcon.setAnimated(false);
        }
        TreePath path = new TreePath(this.getPathToRoot(parent));
        this.fireTreeStructureChanged(this, path);
    }

    public Icon getCurrentIcon(AbstractFile file) {
        CachedDirectory cached = this.cache.get(file);
        if (cached != null) {
            if (cached.isReadingChildren()) {
                return this.spinningIcon;
            }
            return cached.getCachedIcon();
        }
        return this.spinningIcon;
    }
}

