/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.tree;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.filter.FileFilter;
import com.mucommander.commons.file.util.FileComparator;
import com.mucommander.ui.main.tree.CachedDirectory;
import com.mucommander.ui.main.tree.CachedDirectoryListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class DirectoryCache {
    private Map<AbstractFile, CachedDirectory> cache;
    private FileComparator sort;
    private FileFilter filter;
    protected EventListenerList listenerList = new EventListenerList();

    public DirectoryCache(FileFilter filter, FileComparator sort) {
        this.cache = new HashMap<AbstractFile, CachedDirectory>();
        this.filter = filter;
        this.sort = sort;
    }

    public FileComparator getSort() {
        return this.sort;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void fireChildrenCached(CachedDirectory cachedDirectory, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CachedDirectoryListener.class) continue;
            if (bl) {
                ((CachedDirectoryListener)objectArray[i + 1]).cachingStarted(cachedDirectory);
                continue;
            }
            ((CachedDirectoryListener)objectArray[i + 1]).cachingEnded(cachedDirectory);
        }
    }

    public void addCachedDirectoryListener(CachedDirectoryListener cachedDirectoryListener) {
        this.listenerList.add(CachedDirectoryListener.class, cachedDirectoryListener);
    }

    public synchronized void clear() {
        this.cache.clear();
    }

    public synchronized CachedDirectory get(AbstractFile key) {
        return this.cache.get(key);
    }

    public synchronized void put(AbstractFile key, CachedDirectory value) {
        this.cache.put(key, value);
    }

    public synchronized void removeWithChildren(AbstractFile key) {
        CachedDirectory cachedDir = this.cache.get(key);
        if (cachedDir != null) {
            this.cache.remove(key);
            AbstractFile[] children = cachedDir.get();
            if (children != null) {
                for (AbstractFile child : children) {
                    this.removeWithChildren(child);
                }
            }
        }
    }

    public synchronized CachedDirectory getOrAdd(AbstractFile key) {
        CachedDirectory cachedDir = this.cache.get(key);
        if (cachedDir == null) {
            cachedDir = new CachedDirectory(key, this);
            this.cache.put(key, cachedDir);
        }
        return cachedDir;
    }
}

