/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.tree;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.impl.ProxyFile;
import com.mucommander.ui.icon.FileIcons;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.main.tree.DirectoryCache;
import com.mucommander.ui.main.tree.TreeIOThreadManager;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedDirectory
extends ProxyFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedDirectory.class);
    private static final ImageIcon NOT_ACCESSIBLE_ICON = IconManager.getIcon(0, "not_accessible.png");
    private AbstractFile[] cachedChildren = null;
    private boolean readingChildren = false;
    private long lsTimeStamp = -1L;
    private DirectoryCache cache;
    private Icon cachedIcon;

    public CachedDirectory(AbstractFile directory, DirectoryCache cache) {
        super(directory);
        this.cache = cache;
    }

    public synchronized boolean isCached() {
        if (this.isReadingChildren()) {
            return false;
        }
        if (this.lsTimeStamp != this.file.getDate()) {
            this.setReadingChildren(true);
            TreeIOThreadManager.getInstance().addTask(new Runnable(){

                public void run() {
                    CachedDirectory.this.lsAsync();
                }
            });
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lsAsync() {
        AbstractFile[] children;
        if (this.getCachedIcon() == null || this.getCachedIcon() == NOT_ACCESSIBLE_ICON) {
            this.setCachedIcon(FileIcons.getFileIcon(this.getProxiedFile()));
        }
        try {
            children = this.file.ls(this.cache.getFilter());
        }
        catch (Exception e) {
            LOGGER.debug("Caught exception", e);
            children = new AbstractFile[]{};
            this.setCachedIcon(NOT_ACCESSIBLE_ICON);
        }
        Arrays.sort(children, this.cache.getSort());
        Icon[] icons = new Icon[children.length];
        for (int i = 0; i < children.length; ++i) {
            icons[i] = FileIcons.getFileIcon(children[i]);
        }
        DirectoryCache i = this.cache;
        synchronized (i) {
            for (int i2 = 0; i2 < children.length; ++i2) {
                CachedDirectory cachedChild = this.cache.getOrAdd(children[i2]);
                cachedChild.setCachedIcon(icons[i2]);
            }
        }
        final AbstractFile[] children2 = children;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    CachedDirectory.this.setLsCache(children2, CachedDirectory.this.file.getDate());
                }
            });
        }
        catch (Exception e) {
            LOGGER.debug("Caught exception", e);
        }
    }

    private synchronized void setLsCache(AbstractFile[] children, long lsTimeStamp) {
        this.lsTimeStamp = lsTimeStamp;
        this.cachedChildren = children;
        this.setReadingChildren(false);
    }

    public synchronized boolean isReadingChildren() {
        return this.readingChildren;
    }

    private synchronized void setReadingChildren(boolean readingChildren) {
        this.readingChildren = readingChildren;
        this.cache.fireChildrenCached(this, readingChildren);
    }

    public synchronized AbstractFile[] get() {
        return this.cachedChildren;
    }

    public Icon getCachedIcon() {
        return this.cachedIcon;
    }

    public void setCachedIcon(Icon cachedIcon) {
        this.cachedIcon = cachedIcon;
    }
}

