/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.main.toolbar;

import com.mucommander.PlatformManager;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.ui.main.toolbar.ToolBarAttributes;
import com.mucommander.ui.main.toolbar.ToolBarReader;
import com.mucommander.ui.main.toolbar.ToolBarWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public abstract class ToolBarIO
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolBarIO.class);
    private static AbstractFile descriptionFile;
    private static ToolBarWriter toolBarWriter;
    protected static boolean wasToolBarModified;

    public static void loadDescriptionFile() throws Exception {
        AbstractFile descriptionFile = ToolBarIO.getDescriptionFile();
        if (descriptionFile != null && descriptionFile.exists()) {
            ToolBarReader reader = new ToolBarReader(descriptionFile);
            ToolBarAttributes.setActions(reader.getActionsRead());
        } else {
            LOGGER.debug("User toolbar.xml was not found, using default toolbar");
        }
        toolBarWriter = ToolBarWriter.create();
    }

    public static void saveToolBar() throws IOException {
        if (ToolBarAttributes.areDefaultAttributes()) {
            AbstractFile toolBarFile = ToolBarIO.getDescriptionFile();
            if (toolBarFile != null && toolBarFile.exists()) {
                LOGGER.info("Toolbar use default settings, removing descriptor file");
                toolBarFile.delete();
            } else {
                LOGGER.debug("Toolbar not modified, not saving");
            }
        } else if (toolBarWriter != null) {
            if (wasToolBarModified) {
                toolBarWriter.write();
            } else {
                LOGGER.debug("Toolbar not modified, not saving");
            }
        } else {
            LOGGER.warn("Could not save toolbar. writer is null");
        }
    }

    public static void setModified() {
        wasToolBarModified = true;
    }

    public static void setDescriptionFile(AbstractFile file) throws FileNotFoundException {
        if (file.isBrowsable()) {
            throw new FileNotFoundException("Not a valid file: " + file);
        }
        descriptionFile = file;
    }

    public static AbstractFile getDescriptionFile() throws IOException {
        if (descriptionFile == null) {
            return PlatformManager.getPreferencesFolder().getChild("toolbar.xml");
        }
        return descriptionFile;
    }

    public static void setDescriptionFile(String path) throws FileNotFoundException {
        AbstractFile file = FileFactory.getFile(path);
        if (file == null) {
            ToolBarIO.setDescriptionFile(new File(path));
        } else {
            ToolBarIO.setDescriptionFile(file);
        }
    }

    public static void setDescriptionFile(File file) throws FileNotFoundException {
        ToolBarIO.setDescriptionFile(FileFactory.getFile(file.getAbsolutePath()));
    }
}

